/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public abstract class GT_MetaTileEntity_ConcreteBackfillerBase
extends GT_MetaTileEntity_DrillerBase {
    private int mLastXOff = 0;
    private int mLastZOff = 0;

    public GT_MetaTileEntity_ConcreteBackfillerBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ConcreteBackfillerBase(String aName) {
        super(aName);
    }

    protected String[] getDescriptionInternal(String tierSuffix) {
        String casings = this.getCasingBlockItem().get(0L, new Object[0]).getDisplayName();
        return new String[]{"Controller Block for the Concrete Backfiller " + (tierSuffix != null ? tierSuffix : ""), "Size(WxHxD): 3x7x3", "Controller (Front middle at bottom)", "3x1x3 Base of " + casings, "1x3x1 " + casings + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().mName + " Frame Boxes (Each pillar side and on top)", "1x Input Hatch (One of base casings)", "1x Maintenance Hatch (One of base casings)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Radius is " + this.getRadius() + " blocks"};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DrillingRig.png");
    }

    protected abstract int getRadius();

    @Override
    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mInputHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    protected void setElectricityStats() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        int tier = Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
        this.mEUt = -6 * (1 << (tier << 1));
        this.mMaxProgresstime = (this.workState == 2 ? 240 : 80) / (1 << tier);
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
    }

    @Override
    protected boolean workingUpward(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        if (this.isRefillableBlock(xPipe, yHead - 1, zPipe)) {
            return this.tryRefillBlock(xPipe, yHead - 1, zPipe);
        }
        int radius = this.getRadius();
        if (this.mLastXOff == 0 && this.mLastZOff == 0) {
            this.mLastXOff = -radius;
            this.mLastZOff = -radius;
        }
        if (yHead != yDrill) {
            for (int i = this.mLastXOff; i <= radius; ++i) {
                int j;
                int n = j = i == this.mLastXOff ? this.mLastZOff : -radius;
                while (j <= radius) {
                    if (this.isRefillableBlock(xPipe + i, yHead, zPipe + j)) {
                        this.mLastXOff = i;
                        this.mLastZOff = j;
                        return this.tryRefillBlock(xPipe + i, yHead, zPipe + j);
                    }
                    ++j;
                }
            }
        }
        if (this.tryPickPipe()) {
            this.mLastXOff = 0;
            this.mLastZOff = 0;
            return true;
        }
        this.workState = 0;
        this.stopMachine();
        return false;
    }

    private boolean isRefillableBlock(int aX, int aY, int aZ) {
        IGregTechTileEntity aBaseTile = this.getBaseMetaTileEntity();
        if (!aBaseTile.getBlock(aX, aY, aZ).isAir((IBlockAccess)aBaseTile.getWorld(), aX, aY, aZ) || aBaseTile.getBlock(aX, aY, aZ).getMaterial().isSolid()) {
            return false;
        }
        return GT_Utility.setBlockByFakePlayer(this.getFakePlayer(aBaseTile), aX, aY, aZ, GregTech_API.sBlockConcretes, 8, true);
    }

    private boolean tryRefillBlock(int aX, int aY, int aZ) {
        if (!this.tryConsumeFluid()) {
            return false;
        }
        this.getBaseMetaTileEntity().getWorld().setBlock(aX, aY, aZ, GregTech_API.sBlockConcretes, 8, 3);
        return true;
    }

    private boolean tryConsumeFluid() {
        if (!this.depleteInput(Materials.Concrete.getMolten(144L))) {
            this.mMaxProgresstime = 0;
            return false;
        }
        return true;
    }
}

