/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_HeatExchanger
extends GT_MetaTileEntity_MultiBlockBase {
    public static float penalty_per_config = 0.015f;
    private static boolean controller;
    private GT_MetaTileEntity_Hatch_Input mInputHotFluidHatch;
    private GT_MetaTileEntity_Hatch_Output mOutputColdFluidHatch;
    private boolean superheated = false;
    private int superheated_threshold = 0;
    private float water;

    public GT_MetaTileEntity_HeatExchanger(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_HeatExchanger(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Heat Exchanger", "Size(WxHxD): 3x4x3, Controller (Front middle at bottom)", "3x3x4 of Stable Titanium Machine Casings (hollow, Min 20!)", "2x Titanium Pipe Casing (Inside the Hollow Machine Casings)", "1x Distillated Water Input (Any casing)", "1x Steam Output (Any casing)", "1x Hot Fluid Input (Bottom center)", "1x Cold Fluid Output (Top Center)", "1x Maintenance Hatch (Any casing)"};
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.superheated = aNBT.getBoolean("superheated");
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.setBoolean("superheated", this.superheated);
        super.saveNBTData(aNBT);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][50]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeHeatExchanger.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        int circuit_config;
        if (this.mInputHotFluidHatch.getFluid() == null) {
            return true;
        }
        int fluidAmountToConsume = this.mInputHotFluidHatch.getFluidAmount();
        this.superheated_threshold = 4000;
        float efficiency = 1.0f;
        int shs_reduction_per_config = 150;
        float steam_output_multiplier = 20.0f;
        float penalty = 0.0f;
        boolean do_lava = false;
        if (this.mInventory[1] != null && this.mInventory[1].getUnlocalizedName().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].getItemDamage()) >= 1 && circuit_config <= 25) {
            penalty = (float)(circuit_config - 1) * penalty_per_config;
            this.superheated_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        if (GT_ModHandler.isLava(this.mInputHotFluidHatch.getFluid())) {
            steam_output_multiplier /= 5.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 4.0f);
            do_lava = true;
        } else if (this.mInputHotFluidHatch.getFluid().isFluidEqual(FluidRegistry.getFluidStack((String)"ic2hotcoolant", (int)1))) {
            steam_output_multiplier /= 2.0f;
            this.superheated_threshold = (int)((float)this.superheated_threshold / 5.0f);
        } else {
            this.superheated_threshold = 0;
            return false;
        }
        this.superheated = fluidAmountToConsume >= this.superheated_threshold;
        fluidAmountToConsume = Math.min(fluidAmountToConsume, this.superheated_threshold * 2);
        this.mInputHotFluidHatch.drain(fluidAmountToConsume, true);
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((float)fluidAmountToConsume * steam_output_multiplier * efficiency);
        if (do_lava) {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2pahoehoelava", (int)fluidAmountToConsume), true);
            this.mEfficiencyIncrease = 80;
        } else {
            this.mOutputColdFluidHatch.fill(FluidRegistry.getFluidStack((String)"ic2coolant", (int)fluidAmountToConsume), true);
            this.mEfficiencyIncrease = 80;
        }
        return true;
    }

    private int useWater(float input) {
        this.water += input;
        int usage = (int)this.water;
        this.water -= (float)usage;
        return usage;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            int tGeneratedEU = (int)((long)this.mEUt * 2L * (long)this.mEfficiency / 10000L);
            if (tGeneratedEU > 0) {
                int distilledConsumed;
                FluidStack distilledStack;
                if (this.superheated) {
                    tGeneratedEU /= 2;
                }
                if (this.depleteInput(distilledStack = GT_ModHandler.getDistilledWater(distilledConsumed = this.useWater((float)tGeneratedEU / 160.0f)))) {
                    if (this.superheated) {
                        this.addOutput(FluidRegistry.getFluidStack((String)"ic2superheatedsteam", (int)tGeneratedEU));
                    } else {
                        this.addOutput(GT_ModHandler.getSteam(tGeneratedEU));
                    }
                } else {
                    GT_Log.exp.println(this.mName + " had no more Distilled water!");
                    this.explodeMultiblock();
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tCasingAmount = 0;
        controller = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i != 0 || j != 0) {
                    for (int k = 0; k <= 3; ++k) {
                        if (this.addOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), 50) || this.addInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), 50) || this.addMaintenanceToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, k, zDir + j), 50) || this.ignoreController(aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j))) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, k, zDir + j) != this.getCasingBlock()) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, k, zDir + j) != this.getCasingMeta()) {
                            return false;
                        }
                        ++tCasingAmount;
                    }
                    continue;
                }
                if (!this.addHotFluidInputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 50)) {
                    return false;
                }
                if (!this.addColdFluidOutputToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 3, zDir + j), 50)) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 1, zDir + j) != this.getPipeBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 1, zDir + j) != this.getPipeMeta()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 2, zDir + j) != this.getPipeBlock()) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 2, zDir + j) == this.getPipeMeta()) continue;
                return false;
            }
        }
        return tCasingAmount >= 20;
    }

    public boolean ignoreController(Block tTileEntity) {
        return !controller && tTileEntity == GregTech_API.sBlockMachines;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mOutputColdFluidHatch = (GT_MetaTileEntity_Hatch_Output)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            this.mInputHotFluidHatch = (GT_MetaTileEntity_Hatch_Input)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    public byte getCasingMeta() {
        return 2;
    }

    public byte getCasingTextureIndex() {
        return 50;
    }

    public Block getPipeBlock() {
        return GregTech_API.sBlockCasings2;
    }

    public byte getPipeMeta() {
        return 14;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_HeatExchanger(this.mName);
    }

    @Override
    public boolean isGivingInformation() {
        return super.isGivingInformation();
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.translateToLocal((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.translateToLocal((String)"GT5U.multiblock.usage") + " " + StatCollector.translateToLocal((String)"GT5U.LHE.steam") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + Integer.toString(this.superheated ? -2 * this.mEUt : -this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.translateToLocal((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %", StatCollector.translateToLocal((String)"GT5U.LHE.superheated") + ": " + (this.superheated ? EnumChatFormatting.RED : EnumChatFormatting.BLUE) + this.superheated + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.LHE.superheated") + " " + StatCollector.translateToLocal((String)"GT5U.LHE.threshold") + ": " + EnumChatFormatting.GREEN + this.superheated_threshold + EnumChatFormatting.RESET};
    }
}

