/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeChemicalReactor
extends GT_MetaTileEntity_MultiBlockBase {
    private final int CASING_INDEX = 176;

    public GT_MetaTileEntity_LargeChemicalReactor(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeChemicalReactor(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeChemicalReactor(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller block for the Large Chemical Reactor", "Has the same recipes as the Chemical Reactor", "Does not lose efficiency when overclocked", "Accepts fluids instead of fluid cells", "Size(WxHxD): 3x3x3", "3x3x3 of Chemically Inert Machine Casings (hollow, min 8!)", "Controller (Front centered)", "1x PTFE Pipe Machine Casing (inside the hollow casings)", "1x Cupronickel Coil Block (next to PTFE Pipe Machine Casing)", "1x Input Bus/Hatch (Any inert casing)", "1x Output Bus/Hatch (Any inert casing)", "1x Maintenance Hatch (Any inert casing)", "1x Energy Hatch (Any inert casing)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[1][48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "LargeChemicalReactor.png");
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tInputList_sS = tInputList.size();
        block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
            for (int j = i + 1; j < tInputList_sS; ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).stackSize >= tInputList.get((int)j).stackSize) {
                    tInputList.remove(j--);
                    tInputList_sS = tInputList.size();
                    continue;
                }
                tInputList.remove(i--);
                tInputList_sS = tInputList.size();
                continue block0;
            }
        }
        tInputList.add(this.mInventory[1]);
        ItemStack[] inputs = tInputList.toArray(new ItemStack[tInputList.size()]);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block2: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block2;
            }
        }
        FluidStack[] fluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
        if (inputs.length > 0 || fluids.length > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMultiblockChemicalRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, false, GT_Values.V[tier], fluids, inputs);
            if (tRecipe != null && tRecipe.isRecipeInputEqual(true, fluids, inputs)) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.calculatePerfectOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mOutputItems = tRecipe.mOutputs;
                this.mOutputFluids = tRecipe.mFluidOutputs;
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int casingAmount = 0;
        boolean hasHeatingCoil = false;
        for (int x = -1 + xDir; x <= xDir + 1; ++x) {
            for (int z = -1 + zDir; z <= zDir + 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    IGregTechTileEntity tileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(x, y, z);
                    Block block = aBaseMetaTileEntity.getBlockOffset(x, y, z);
                    int centerCoords = 0;
                    if (x == xDir) {
                        ++centerCoords;
                    }
                    if (y == 0) {
                        ++centerCoords;
                    }
                    if (z == zDir) {
                        ++centerCoords;
                    }
                    if (centerCoords == 3) {
                        if (block == GregTech_API.sBlockCasings8 && aBaseMetaTileEntity.getMetaIDOffset(x, y, z) == 1) continue;
                        return false;
                    }
                    if (centerCoords == 2 && block == GregTech_API.sBlockCasings5 && aBaseMetaTileEntity.getMetaIDOffset(x, y, z) == 0) {
                        hasHeatingCoil = true;
                        continue;
                    }
                    if (this.addInputToMachineList(tileEntity, 176) || this.addOutputToMachineList(tileEntity, 176) || this.addMaintenanceToMachineList(tileEntity, 176) || this.addEnergyInputToMachineList(tileEntity, 176)) continue;
                    if (block == GregTech_API.sBlockCasings8 && aBaseMetaTileEntity.getMetaIDOffset(x, y, z) == 0) {
                        ++casingAmount;
                        continue;
                    }
                    return false;
                }
            }
        }
        return casingAmount >= 8 && hasHeatingCoil;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

