/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.IMutationCustom;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.bees.GT_AlleleBeeSpecies;
import gregtech.common.bees.GT_Bee_Mutation;
import gregtech.common.items.CombType;
import gregtech.common.items.DropType;
import gregtech.common.items.PropolisType;
import gregtech.loaders.misc.GT_Bees;
import gregtech.loaders.misc.GT_BranchDefinition;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public enum GT_BeeDefinition implements IBeeDefinition
{
    CLAY(GT_BranchDefinition.ORGANIC, "Clay", true, 13158618, 255){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addProduct(new ItemStack(Items.clay_ball, 1), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("BiomesOPlenty", "mudball", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(1.getSpecies((byte)0, "Industrious"), 1.getSpecies((byte)0, "Diligent"), 10);
            tMutation.requireResource(Blocks.clay, 0);
        }
    }
    ,
    SLIMEBALL(GT_BranchDefinition.ORGANIC, "SlimeBall", true, 5152341, 65301){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 15), Float.valueOf(0.3f));
            beeSpecies.addProduct(new ItemStack(Items.slime_ball, 1), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            if (Loader.isModLoaded((String)"TConstruct")) {
                beeSpecies.addProduct(GT_ModHandler.getModItem("TConstruct", "strangeFood", 1L, 0), Float.valueOf(0.1f));
                beeSpecies.addSpecialty(GT_ModHandler.getModItem("TConstruct", "slime.gel", 1L, 2), Float.valueOf(0.01f));
            }
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)2.getFlowers((byte)1, "water"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(2.getSpecies((byte)0, "Marshy"), (IAlleleBeeSpecies)CLAY.species, 7);
            if (Loader.isModLoaded((String)"TConstruct")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"TConstruct", (String)"slime.gel"), 1);
            }
        }
    }
    ,
    PEAT(GT_BranchDefinition.ORGANIC, "Peat", true, 9462327, 5779467){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("Forestry", "peat", 1L, 0), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("Forestry", "mulch", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(3.getSpecies((byte)0, "Rural"), (IAlleleBeeSpecies)CLAY.species, 10);
        }
    }
    ,
    STICKYRESIN(GT_BranchDefinition.ORGANIC, "StickyResin", true, 3051355, 14467721){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(ItemList.IC2_Resin.get(1L, new Object[0]), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SLIMEBALL.species, (IAlleleBeeSpecies)PEAT.species, 15);
            tMutation.requireResource("logRubber");
        }
    }
    ,
    COAL(GT_BranchDefinition.ORGANIC, "Coal", true, 0x666666, 0x525252){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.COAL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectCreeper);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(5.getSpecies((byte)0, "Industrious"), (IAlleleBeeSpecies)PEAT.species, 9);
            tMutation.requireResource("blockCoal");
        }
    }
    ,
    OIL(GT_BranchDefinition.ORGANIC, "Oil", true, 0x4C4C4C, 0x333333){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OIL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)6.getFlowers((byte)1, "water"));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)STICKYRESIN.species, 4);
        }
    }
    ,
    SANDWICH(GT_BranchDefinition.ORGANIC, "Sandwich", true, 3329330, 14329120){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(ItemList.Food_Sliced_Cucumber.get(1L, new Object[0]), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(ItemList.Food_Sliced_Onion.get(1L, new Object[0]), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(ItemList.Food_Sliced_Tomato.get(1L, new Object[0]), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(ItemList.Food_Sliced_Cheese.get(1L, new Object[0]), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(new ItemStack(Items.cooked_porkchop, 1, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(new ItemStack(Items.cooked_beef, 1, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectFertile);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(7.getSpecies((byte)0, "Agrarian"), 7.getSpecies((byte)3, "TCBatty"), 10);
        }
    }
    ,
    ASH(GT_BranchDefinition.ORGANIC, "Ash", true, 1972760, 0xC6C6C6){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ASH), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.NORMAL);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.LARGE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)CLAY.species, 10);
            tMutation.restrictTemperature(EnumTemperature.HELLISH);
        }
    }
    ,
    APATITE(GT_BranchDefinition.ORGANIC, "Apatite", true, 12698102, 6776708){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.APATITE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)9.getFlowers((byte)1, "rock"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ASH.species, (IAlleleBeeSpecies)COAL.species, 10);
            tMutation.requireResource("blockApatite");
        }
    }
    ,
    FERTILIZER(GT_BranchDefinition.ORGANIC, "Fertilizer", true, 8376053, 6636837){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 9), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.Ash, 1L), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(ItemList.FR_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(ItemList.IC2_Fertilizer.get(1L, new Object[0]), Float.valueOf(0.3f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.WHEAT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FASTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ASH.species, (IAlleleBeeSpecies)APATITE.species, 8);
        }
    }
    ,
    COOLANT(GT_BranchDefinition.IC2, "Coolant", false, 1331034, 2397346){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 4), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.COOLANT), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(11.getSpecies((byte)0, "Icy"), 11.getSpecies((byte)0, "Glacial"), 10);
            tMutation.requireResource(Block.getBlockFromItem((Item)GT_ModHandler.getModItem("IC2", "fluidCoolant", 1L).getItem()), 0);
            tMutation.restrictTemperature(EnumTemperature.ICY);
        }
    }
    ,
    ENERGY(GT_BranchDefinition.IC2, "Energy", false, 0xC11F1F, 0xEBB9B9){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 12), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(12.getSpecies((byte)0, "Demonic"), 12.getSpecies((byte)1, "volcanic"), 10);
            tMutation.requireResource(Block.getBlockFromItem((Item)GT_ModHandler.getModItem("IC2", "fluidHotCoolant", 1L).getItem()), 0);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(128, "Boneyard Biome"));
        }
    }
    ,
    LAPOTRON(GT_BranchDefinition.IC2, "Lapotron", false, 6584575, 0x1414FF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LAPOTRON), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LAPIS.species, (IAlleleBeeSpecies)ENERGY.species, 6);
            tMutation.requireResource("blockLapis");
            tMutation.restrictTemperature(EnumTemperature.ICY);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
        }
    }
    ,
    PYROTHEUM(GT_BranchDefinition.IC2, "Pyrotheum", false, 16772036, 14902272){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ENERGY), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PYROTHEUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FASTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)ENERGY.species, 4);
            tMutation.restrictTemperature(EnumTemperature.HELLISH);
        }
    }
    ,
    CRYOTHEUM(GT_BranchDefinition.IC2, "Cryotheum", false, 2515199, 5961727){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COOLANT), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CRYOTHEUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectSnowing);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)COOLANT.species, 4);
            tMutation.restrictTemperature(EnumTemperature.ICY);
        }
    }
    ,
    REDALLOY(GT_BranchDefinition.GTALLOY, "RedAlloy", false, 0xE60000, 0xB80000){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDALLOY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COPPER.species, (IAlleleBeeSpecies)REDSTONE.species, 10);
            tMutation.requireResource("blockRedAlloy");
        }
    }
    ,
    REDSTONEALLOY(GT_BranchDefinition.GTALLOY, "RedStoneAlloy", false, 10815496, 0xE80000){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONEALLOY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)REDALLOY.species, 8);
            tMutation.requireResource("blockRedstoneAlloy");
        }
    }
    ,
    CONDUCTIVEIRON(GT_BranchDefinition.GTALLOY, "ConductiveIron", false, 13544867, 8484465){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CONDUCTIVEIRON), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONEALLOY.species, (IAlleleBeeSpecies)IRON.species, 8);
            tMutation.requireResource("blockConductiveIron");
        }
    }
    ,
    VIBRANTALLOY(GT_BranchDefinition.GTALLOY, "VibrantAlloy", false, 8823085, 12907182){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.VIBRANTALLOY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ENERGETICALLOY.species, 19.getSpecies((byte)0, "Phantasmal"), 6);
            tMutation.requireResource("blockVibrantAlloy");
            tMutation.restrictTemperature(EnumTemperature.HOT, EnumTemperature.HELLISH);
        }
    }
    ,
    ENERGETICALLOY(GT_BranchDefinition.GTALLOY, "EnergeticAlloy", false, 0xFF9933, 16756060){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENERGETICALLOY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONEALLOY.species, 20.getSpecies((byte)0, "Demonic"), 9);
            tMutation.requireResource("blockEnergeticAlloy");
        }
    }
    ,
    ELECTRICALSTEEL(GT_BranchDefinition.GTALLOY, "ElectricalSteel", false, 0x787878, 0xD8D8D8){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ELECTRICALSTEEL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)STEEL.species, 21.getSpecies((byte)0, "Demonic"), 9);
            tMutation.requireResource("blockElectricalSteel");
        }
    }
    ,
    DARKSTEEL(GT_BranchDefinition.GTALLOY, "DarkSteel", false, 0x252525, 0x443B44){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DARKSTEEL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ELECTRICALSTEEL.species, 22.getSpecies((byte)0, "Demonic"), 7);
            tMutation.requireResource("blockDarkSteel");
        }
    }
    ,
    PULSATINGIRON(GT_BranchDefinition.GTALLOY, "PulsatingIron", false, 7197316, 26112){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 7), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PULSATINGIRON), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDALLOY.species, 23.getSpecies((byte)0, "Ended"), 9);
            tMutation.requireResource("blockPulsatingIron");
        }
    }
    ,
    STAINLESSSTEEL(GT_BranchDefinition.GTALLOY, "StainlessSteel", false, 0xC8C8DC, 0x778899){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STAINLESSSTEEL), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CHROME.species, (IAlleleBeeSpecies)STEEL.species, 9);
            tMutation.requireResource("blockStainlessSteel");
        }
    }
    ,
    ENDERIUM(GT_BranchDefinition.GTALLOY, "Enderium", false, 5869703, 3050327){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDERIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)25.getEffect((byte)1, "teleport"));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLATINUM.species, 25.getSpecies((byte)0, "Phantasmal"), 3);
            tMutation.requireResource("blockEnderium");
        }
    }
    ,
    THAUMIUMDUST(GT_BranchDefinition.THAUMIC, "ThaumiumDust", true, 0x7A007A, 0x5C005C){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectExploration);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(26.getSpecies((byte)3, "TCFire"), 26.getSpecies((byte)0, "Edenic"), 10);
            tMutation.requireResource("blockThaumium");
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
        }
    }
    ,
    THAUMIUMSHARD(GT_BranchDefinition.THAUMIC, "ThaumiumShard", true, 0x9966FF, 11372031){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.THAUMIUMDUST), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMIUMSHARD), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.SNOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectGlacial);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMDUST.species, 27.getSpecies((byte)3, "TCWater"), 10);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
        }
    }
    ,
    AMBER(GT_BranchDefinition.THAUMIC, "Amber", true, 0xEE7700, 7818005){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.AMBER), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMDUST.species, (IAlleleBeeSpecies)STICKYRESIN.species, 10);
            tMutation.requireResource("blockAmber");
        }
    }
    ,
    QUICKSILVER(GT_BranchDefinition.THAUMIC, "Quicksilver", true, 0x7A007A, 0x5C005C){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUICKSILVER), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMDUST.species, (IAlleleBeeSpecies)SILVER.species, 10);
        }
    }
    ,
    SALISMUNDUS(GT_BranchDefinition.THAUMIC, "SalisMundus", true, 16231902, 5842306){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectMiasmic);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMDUST.species, (IAlleleBeeSpecies)THAUMIUMSHARD.species, 8);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(192, "Magical Forest"));
        }
    }
    ,
    TAINTED(GT_BranchDefinition.THAUMIC, "Tainted", true, 9456568, 15204607){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 3), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.TAINTED), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)31.getFlowers((byte)1, "rock"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMDUST.species, (IAlleleBeeSpecies)THAUMIUMSHARD.species, 7);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(193, "Tainted Land"));
        }
    }
    ,
    MITHRIL(GT_BranchDefinition.THAUMIC, "Mithril", true, 15787660, 0xFFFFD2){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MITHRIL), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)32.getFlowers((byte)1, "rock"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IO.species, (IAlleleBeeSpecies)PLATINUM.species, 7);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 10);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
        }
    }
    ,
    ASTRALSILVER(GT_BranchDefinition.THAUMIC, "AstralSilver", true, 0xAFEEEE, 0xE6E6FF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ASTRALSILVER), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TOLERANT_FLYER, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.LOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAllele)33.getFlowers((byte)1, "rock"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SILVER.species, (IAlleleBeeSpecies)IRON.species, 3);
            tMutation.requireResource(GregTech_API.sBlockMetal1, 6);
        }
    }
    ,
    THAUMINITE(GT_BranchDefinition.THAUMIC, "Thauminite", true, 3026297, 7700960){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "comb", 1L, 19), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.THAUMINITE), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(34.getSpecies((byte)3, "TCOrder"), (IAlleleBeeSpecies)THAUMIUMDUST.species, 8);
            if (Loader.isModLoaded((String)"thaumicbases")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"thaumicbases", (String)"thauminiteBlock"), 0);
            }
        }
    }
    ,
    SHADOWMETAL(GT_BranchDefinition.THAUMIC, "ShadowMetal", true, 1049378, 1049410){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "comb", 1L, 20), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SHADOWMETAL), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(35.getSpecies((byte)3, "TCChaos"), 35.getSpecies((byte)3, "TCVoid"), 6);
            if (Loader.isModLoaded((String)"TaintedMagic")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"TaintedMagic", (String)"BlockShadowmetal"), 0);
            }
        }
    }
    ,
    DIVIDED(GT_BranchDefinition.THAUMIC, "Unstable", true, 0xF0F0F0, 0xDCDCDC){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("ExtraBees", "honeyComb", 1L, 61), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DIVIDED), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DIAMOND.species, (IAlleleBeeSpecies)IRON.species, 3);
            if (Loader.isModLoaded((String)"ExtraUtilities")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"ExtraUtilities", (String)"decorativeBlock1"), 5);
            }
        }
    }
    ,
    SPARKELING(GT_BranchDefinition.THAUMIC, "NetherStar", true, 0x7A007A, 0xFFFFFF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("MagicBees", "miscResources", 1L, 3), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SPARKELING), Float.valueOf(0.125f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.CAVE_DWELLING, true);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.NETHER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectAggressive);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(37.getSpecies((byte)3, "Withering"), 37.getSpecies((byte)3, "Draconic"), 1);
            tMutation.requireResource(GregTech_API.sBlockGem3, 3);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(9, "END Biome"));
        }
    }
    ,
    REDSTONE(GT_BranchDefinition.GEM, "Redstone", true, 8195855, 0xD11919){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RAREEARTH), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(38.getSpecies((byte)0, "Industrious"), 38.getSpecies((byte)0, "Demonic"), 10);
            tMutation.requireResource("blockRedstone");
        }
    }
    ,
    LAPIS(GT_BranchDefinition.GEM, "Lapis", true, 1656785, 4680922){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(39.getSpecies((byte)0, "Demonic"), 39.getSpecies((byte)0, "Imperial"), 10);
            tMutation.requireResource("blockLapis");
        }
    }
    ,
    CERTUS(GT_BranchDefinition.GEM, "CertusQuartz", true, 5754875, 0xBBEEFF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CERTUS), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(40.getSpecies((byte)0, "Hermitic"), (IAlleleBeeSpecies)LAPIS.species, 10);
            if (Loader.isModLoaded((String)"appliedenergistics2")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockQuartz"), 0);
            }
        }
    }
    ,
    FLUIX(GT_BranchDefinition.GEM, "FluixDust", true, 10712575, 11899391){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FLUIX), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)LAPIS.species, 7);
            if (Loader.isModLoaded((String)"appliedenergistics2")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"appliedenergistics2", (String)"tile.BlockFluix"), 0);
            }
        }
    }
    ,
    RUBY(GT_BranchDefinition.GEM, "Ruby", false, 15073372, 13369426){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.RUBY), Float.valueOf(0.15f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)DIAMOND.species, 5);
            tMutation.requireResource("blockRuby");
        }
    }
    ,
    SAPPHIRE(GT_BranchDefinition.GEM, "Sapphire", true, 13260, 9359){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SAPPHIRE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, (IAlleleBeeSpecies)LAPIS.species, 5);
            tMutation.requireResource(GregTech_API.sBlockGem2, 12);
        }
    }
    ,
    DIAMOND(GT_BranchDefinition.GEM, "Diamond", false, 0xCCFFFF, 0xA3CCCC){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DIAMOND), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, (IAlleleBeeSpecies)COAL.species, 3);
            tMutation.requireResource("blockDiamond");
        }
    }
    ,
    OLIVINE(GT_BranchDefinition.GEM, "Olivine", true, 2395940, 0xCCFFCC){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OLIVINE), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, 45.getSpecies((byte)0, "Ended"), 5);
        }
    }
    ,
    EMERALD(GT_BranchDefinition.GEM, "Emerald", false, 2395940, 3061806){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.EMERALD), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)OLIVINE.species, (IAlleleBeeSpecies)DIAMOND.species, 4);
            tMutation.requireResource("blockEmerald");
        }
    }
    ,
    REDGARNET(GT_BranchDefinition.GEM, "RedGarnet", false, 12405836, 0xECCECE){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDGARNET), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PYROPE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DIAMOND.species, (IAlleleBeeSpecies)RUBY.species, 4);
            tMutation.requireResource("blockGarnetRed");
        }
    }
    ,
    YELLOWGARNET(GT_BranchDefinition.GEM, "YellowGarnet", false, 10724161, 0xEDEDCE){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.YELLOWGARNET), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GROSSULAR), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)EMERALD.species, (IAlleleBeeSpecies)REDGARNET.species, 3);
            tMutation.requireResource("blockGarnetYellow");
        }
    }
    ,
    FIRESTONE(GT_BranchDefinition.GEM, "Firestone", false, 0xC00000, 0xFF0000){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FIRESTONE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)RUBY.species, 4);
            tMutation.requireResource("blockFirestone");
        }
    }
    ,
    COPPER(GT_BranchDefinition.METAL, "Copper", true, 0xFF6600, 15096832){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COPPER), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(50.getSpecies((byte)0, "Majestic"), (IAlleleBeeSpecies)CLAY.species, 13);
            tMutation.requireResource("blockCopper");
        }
    }
    ,
    TIN(GT_BranchDefinition.METAL, "Tin", true, 0xD4D4D4, 0xDDDDDD){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TIN), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CLAY.species, 51.getSpecies((byte)0, "Diligent"), 13);
            tMutation.requireResource("blockTin");
        }
    }
    ,
    LEAD(GT_BranchDefinition.METAL, "Lead", true, 0x666699, 0xA3A3CC){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)COPPER.species, 13);
            tMutation.requireResource("blockLead");
        }
    }
    ,
    IRON(GT_BranchDefinition.METAL, "Iron", true, 14324039, 14589017){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.TIN), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TIN.species, (IAlleleBeeSpecies)COPPER.species, 13);
            tMutation.requireResource("blockIron");
        }
    }
    ,
    STEEL(GT_BranchDefinition.METAL, "Steel", true, 0x808080, 0x999999){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)COAL.species, 10);
            tMutation.requireResource("blockSteel");
            tMutation.restrictTemperature(EnumTemperature.HOT);
        }
    }
    ,
    NICKEL(GT_BranchDefinition.METAL, "Nickel", true, 8750509, 8750509){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.15f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.02f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)COPPER.species, 13);
            tMutation.requireResource("blockNickel");
        }
    }
    ,
    ZINC(GT_BranchDefinition.METAL, "Zinc", true, 15785712, 15917554){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.GALLIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)TIN.species, 13);
            tMutation.requireResource("blockZinc");
        }
    }
    ,
    SILVER(GT_BranchDefinition.METAL, "Silver", true, 12763862, 0xCECEDE){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SULFUR), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LEAD.species, (IAlleleBeeSpecies)TIN.species, 10);
            tMutation.requireResource("blockSilver");
        }
    }
    ,
    GOLD(GT_BranchDefinition.METAL, "Gold", true, 15451699, 15584327){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LEAD.species, (IAlleleBeeSpecies)COPPER.species, 13);
            tMutation.requireResource("blockGold");
            tMutation.restrictTemperature(EnumTemperature.HOT);
        }
    }
    ,
    ARSENIC(GT_BranchDefinition.METAL, "Arsenic", true, 7564370, 2696210){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ARSENIC), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ZINC.species, (IAlleleBeeSpecies)SILVER.species, 10);
            tMutation.requireResource("blockArsenic");
        }
    }
    ,
    ALUMINIUM(GT_BranchDefinition.RAREMETAL, "Aluminium", true, 0xB8B8FF, 0xD6D6FF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.BAUXITE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NICKEL.species, (IAlleleBeeSpecies)ZINC.species, 9);
            tMutation.requireResource("blockAluminium");
        }
    }
    ,
    TITANIUM(GT_BranchDefinition.RAREMETAL, "Titanium", true, 0xCC99FF, 14399743){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TITANIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ALMANDINE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal7, 9);
        }
    }
    ,
    CHROME(GT_BranchDefinition.RAREMETAL, "Chrome", true, 15442411, 15909874){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MAGNESIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TITANIUM.species, (IAlleleBeeSpecies)RUBY.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal2, 3);
        }
    }
    ,
    MANGANESE(GT_BranchDefinition.RAREMETAL, "Manganese", true, 0xD5D5D5, 0xAAAAAA){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MANGANESE), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TITANIUM.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 6);
        }
    }
    ,
    TUNGSTEN(GT_BranchDefinition.RAREMETAL, "Tungsten", false, 6053002, 8224161){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TUNGSTEN), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MOLYBDENUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(64.getSpecies((byte)0, "Heroic"), (IAlleleBeeSpecies)MANGANESE.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal7, 11);
        }
    }
    ,
    PLATINUM(GT_BranchDefinition.RAREMETAL, "Platinum", false, 0xE6E6E6, 0xFFFFCC){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.02f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DIAMOND.species, (IAlleleBeeSpecies)CHROME.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal5, 12);
        }
    }
    ,
    IRIDIUM(GT_BranchDefinition.RAREMETAL, "Iridium", false, 0xDADADA, 13750752){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TUNGSTEN.species, (IAlleleBeeSpecies)PLATINUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal3, 12);
        }
    }
    ,
    OSMIUM(GT_BranchDefinition.RAREMETAL, "Osmium", false, 2829274, 0x8B8B8B){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.OSMIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TUNGSTEN.species, (IAlleleBeeSpecies)PLATINUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal5, 9);
        }
    }
    ,
    LITHIUM(GT_BranchDefinition.RAREMETAL, "Lithium", false, 15741580, 14802175){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALT), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SALTY.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
            tMutation.requireResource("blockLithium");
        }
    }
    ,
    SALTY(GT_BranchDefinition.RAREMETAL, "Salt", true, 15780040, 0xFAFAFA){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SALT), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LITHIUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CLAY.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
            tMutation.requireResource("blockSalt");
        }
    }
    ,
    ELECTROTINE(GT_BranchDefinition.RAREMETAL, "Electrotine", false, 2003199, 3978440){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ELECTROTINE), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)GOLD.species, 5);
            tMutation.requireResource("blockElectrotine");
        }
    }
    ,
    URANIUM(GT_BranchDefinition.RADIOACTIVE, "Uranium", true, 1683225, 1482262){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.URANIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(71.getSpecies((byte)0, "Avenging"), (IAlleleBeeSpecies)PLATINUM.species, 2);
            tMutation.requireResource(GregTech_API.sBlockMetal7, 14);
        }
    }
    ,
    PLUTONIUM(GT_BranchDefinition.RADIOACTIVE, "Plutonium", true, 0x570000, 0x240000){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.PLUTONIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URANIUM.species, (IAlleleBeeSpecies)EMERALD.species, 2);
            tMutation.requireResource(GregTech_API.sBlockMetal5, 13);
        }
    }
    ,
    NAQUADAH(GT_BranchDefinition.RADIOACTIVE, "Naquadah", false, 13056, 9216){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTONIUM.species, (IAlleleBeeSpecies)IRIDIUM.species, 1);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 12);
        }
    }
    ,
    NAQUADRIA(GT_BranchDefinition.RADIOACTIVE, "Naquadria", false, 0, 9216){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.2f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAQUADRIA), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTONIUM.species, (IAlleleBeeSpecies)IRIDIUM.species, 8, 10.0f);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 15);
        }
    }
    ,
    DOB(GT_BranchDefinition.RADIOACTIVE, "DOB", false, 13056, 9216){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.DOB), Float.valueOf(0.75f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NAQUADAH.species, (IAlleleBeeSpecies)THAUMIUMSHARD.species, 1);
            if (Loader.isModLoaded((String)"AdvancedSolarPanel")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"AdvancedSolarPanel", (String)"BlockAdvSolarPanel"), 2);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(9, "END Biome"));
        }
    }
    ,
    THORIUM(GT_BranchDefinition.RADIOACTIVE, "Thorium", false, 20480, 7680){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.THORIUM), Float.valueOf(0.75f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)URANIUM.species, 2).setIsSecret();
            tMutation.requireResource(GregTech_API.sBlockMetal7, 5);
        }
    }
    ,
    LUTETIUM(GT_BranchDefinition.RADIOACTIVE, "Lutetium", false, 0xE6FFE6, 0xFFFFFF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LUTETIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THORIUM.species, 77.getSpecies((byte)1, "rotten"), 1).setIsSecret();
            tMutation.requireResource(GregTech_API.sBlockMetal4, 3);
        }
    }
    ,
    AMERICIUM(GT_BranchDefinition.RADIOACTIVE, "Americium", false, 0xE6E6FF, 0xC8C8C8){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.AMERICUM), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LUTETIUM.species, (IAlleleBeeSpecies)CHROME.species, 3, 4.0f).setIsSecret();
            tMutation.requireResource(GregTech_API.sBlockMetal1, 2);
        }
    }
    ,
    NEUTRONIUM(GT_BranchDefinition.RADIOACTIVE, "Neutronium", false, 0xFFF0F0, 0xFAFAFA){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEUTRONIUM), Float.valueOf(1.0E-4f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.NOCTURNAL, true);
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NAQUADRIA.species, (IAlleleBeeSpecies)AMERICIUM.species, 1, 2.0f).setIsSecret();
            tMutation.requireResource(GregTech_API.sBlockMetal5, 2);
        }
    }
    ,
    NAGA(GT_BranchDefinition.TWILIGHT, "Naga", true, 875021, 2656075){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.02f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.NAGA), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(80.getSpecies((byte)3, "Eldritch"), 80.getSpecies((byte)0, "Imperial"), 8);
            tMutation.restrictHumidity(EnumHumidity.DAMP);
        }
    }
    ,
    LICH(GT_BranchDefinition.TWILIGHT, "Lich", true, 0xC5C5C5, 6053982){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.04f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LICH), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(81.getSpecies((byte)3, "Supernatural"), (IAlleleBeeSpecies)NAGA.species, 7);
            tMutation.restrictHumidity(EnumHumidity.ARID);
        }
    }
    ,
    HYDRA(GT_BranchDefinition.TWILIGHT, "Hydra", true, 8857654, 12063532){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.06f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.HYDRA), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LICH.species, 82.getSpecies((byte)3, "TCFire"), 6);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.BiomeIDMutationCondition(138, "Undergarden"));
        }
    }
    ,
    URGHAST(GT_BranchDefinition.TWILIGHT, "UrGhast", true, 10945564, 8128024){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.08f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.URGHAST), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.FAST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)HYDRA.species, (IAlleleBeeSpecies)THAUMIUMDUST.species, 5);
            if (Loader.isModLoaded((String)"Thaumcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"Thaumcraft", (String)"blockCosmeticSolid"), 4);
            }
            tMutation.restrictTemperature(EnumTemperature.HELLISH);
        }
    }
    ,
    SNOWQUEEN(GT_BranchDefinition.TWILIGHT, "SnowQueen", true, 13639681, 10223640){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SALISMUNDUS), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SNOWQUEEN), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URGHAST.species, (IAlleleBeeSpecies)SALISMUNDUS.species, 4);
            if (Loader.isModLoaded((String)"thaumicbases")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"thaumicbases", (String)"blockSalisMundus"), 0);
            }
            tMutation.restrictTemperature(EnumTemperature.ICY);
        }
    }
    ,
    ENDDUST(GT_BranchDefinition.HEE, "End Dust", true, 13369594, 14973){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDDUST), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(85.getSpecies((byte)0, "Ended"), (IAlleleBeeSpecies)STAINLESSSTEEL.species, 8);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"end_powder_ore"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    ENDIUM(GT_BranchDefinition.HEE, "Endium", true, 0xA0FFFF, 3103340){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDIUM), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_Bees.propolis.getStackForType(PropolisType.Endium), Float.valueOf(0.15f));
            beeSpecies.addSpecialty(GT_Bees.drop.getStackForType(DropType.ENDERGOO), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.NORMAL);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(86.getSpecies((byte)0, "Ended"), (IAlleleBeeSpecies)THAUMIUMDUST.species, 8);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource("blockHeeEndium");
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    STARDUST(GT_BranchDefinition.HEE, "Star Dust", true, 0xFFFF00, 14466579){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.STARDUST), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(87.getSpecies((byte)0, "Ended"), (IAlleleBeeSpecies)ZINC.species, 8);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"stardust_ore"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    ECTOPLASMA(GT_BranchDefinition.HEE, "Ectoplasma", true, 14463205, 3677248){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ECTOPLASMA), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORT);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(88.getSpecies((byte)0, "Ended"), (IAlleleBeeSpecies)ENDDUST.species, 5);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"spooky_log"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    ARCANESHARDS(GT_BranchDefinition.HEE, "Arcane Shards", true, 9441453, 3358082){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ARCANESHARD), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONG);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_1);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)THAUMIUMSHARD.species, (IAlleleBeeSpecies)ENDDUST.species, 5);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"laboratory_floor"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    DRAGONESSENCE(GT_BranchDefinition.HEE, "Dragonessence", true, 16752939, 9510606){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DRAGONESSENCE), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectBeatific);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.BOTH_3);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ECTOPLASMA.species, (IAlleleBeeSpecies)ARCANESHARDS.species, 4);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"essence_altar"), 1);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    FIREESSENCE(GT_BranchDefinition.HEE, "Fireessence", true, 13898296, 16752983){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.FIREESSENSE), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.ELONGATED);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_3);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_3);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)FIRESTONE.species, (IAlleleBeeSpecies)ARCANESHARDS.species, 4);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"essence_altar"), 2);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    ENDERMANHEAD(GT_BranchDefinition.HEE, "Enderman", true, 0x161616, 6422759){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ENDERMAN), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)92.getEffect((byte)1, "teleport"));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_1);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ENDERIUM.species, (IAlleleBeeSpecies)STARDUST.species, 4);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"ender_goo"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    SILVERFISH(GT_BranchDefinition.HEE, "Silverfisch", true, 15598909, 0){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.SILVERFISH), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.LONGER);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)93.getEffect((byte)3, "SlowSpeed"));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ECTOPLASMA.species, (IAlleleBeeSpecies)STARDUST.species, 5);
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"HardcoreEnderExpansion")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"HardcoreEnderExpansion", (String)"ender_goo"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    RUNE(GT_BranchDefinition.HEE, "Rune", true, 14880784, 66777){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 8), Float.valueOf(0.3f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RUNEI), Float.valueOf(0.0025f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.RUNEII), Float.valueOf(0.00125f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAllele)GT_Bees.superLife);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)94.getEffect((byte)3, "SlowSpeed"));
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DRAGONESSENCE.species, (IAlleleBeeSpecies)STARDUST.species, 2).setIsSecret();
            tMutation.restrictHumidity(EnumHumidity.ARID);
            if (Loader.isModLoaded((String)"EnderStorage")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"EnderStorage", (String)"enderChest"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(1, "End"));
        }
    }
    ,
    SPACE(GT_BranchDefinition.SPACE, "Space", true, 13158, 0xC0C0C0){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.02f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(95.getSpecies((byte)0, "Industrious"), 95.getSpecies((byte)0, "Heroic"), 10);
            tMutation.restrictTemperature(EnumTemperature.ICY);
        }
    }
    ,
    METEORICIRON(GT_BranchDefinition.SPACE, "MeteoricIron", true, 3283240, 6566480){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.04f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.METEORICIRON), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SPACE.species, (IAlleleBeeSpecies)IRON.species, 9);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 7);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
        }
    }
    ,
    DESH(GT_BranchDefinition.SPACE, "Desh", false, 0x323232, 0x282828){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.06f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.DESH), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectIgnition);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MARS.species, (IAlleleBeeSpecies)TITANIUM.species, 9);
            tMutation.requireResource(GregTech_API.sBlockMetal2, 12);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(29, "Mars"));
        }
    }
    ,
    LEDOX(GT_BranchDefinition.SPACE, "Ledox", false, 205, 29951){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.LEDOX), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)98.getEffect((byte)1, "freezing"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CALLISTO.species, (IAlleleBeeSpecies)LEAD.species, 7);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Ledox"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(35, "Europa"));
        }
    }
    ,
    CALLISTOICE(GT_BranchDefinition.SPACE, "CallistoIce", false, 29951, 2011647){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.CALLISTOICE), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)99.getEffect((byte)1, "freezing"));
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CALLISTO.species, 99.getSpecies((byte)1, "freezing"), 7);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.CallistoColdIce"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(45, "Callisto"));
        }
    }
    ,
    MYTRYL(GT_BranchDefinition.SPACE, "Mytryl", false, 14329120, 15885316){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MYTRYL), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IO.species, (IAlleleBeeSpecies)MITHRIL.species, 6);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Mytryl"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
        }
    }
    ,
    QUANTIUM(GT_BranchDefinition.SPACE, "Quantium", false, 65280, 53515){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.16f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)VENUS.species, (IAlleleBeeSpecies)OSMIUM.species, 6);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Quantinum"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(39, "Venus"));
        }
    }
    ,
    ORIHARUKON(GT_BranchDefinition.SPACE, "Oriharukon", false, 0x228B22, 6782312){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.26f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.ORIHARUKON), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LEAD.species, (IAlleleBeeSpecies)OBERON.species, 5);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"metalsblock"), 6);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(46, "Oberon"));
        }
    }
    ,
    MYSTERIOUSCRYSTAL(GT_BranchDefinition.SPACE, "MysteriousCrystal", false, 3978097, 1475948){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.42f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.MYSTERIOUSCRYSTAL), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ENCELADUS.species, (IAlleleBeeSpecies)EMERALD.species, 3);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.MysteriousCrystal"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
        }
    }
    ,
    BLACKPLUTONIUM(GT_BranchDefinition.SPACE, "BlackPlutonium", false, 0, 0x323232){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SPACE), Float.valueOf(0.68f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.BLACKPLUTONIUM), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTO.species, (IAlleleBeeSpecies)PLUTONIUM.species, 2);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.BlackPlutonium"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(49, "Pluto"));
        }
    }
    ,
    TRINIUM(GT_BranchDefinition.SPACE, "Trinium", false, 11591910, 13158610){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TRINIUM), Float.valueOf(0.75f));
            beeSpecies.addSpecialty(GT_Bees.combs.getStackForType(CombType.QUANTIUM), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.SPEED, (IAllele)GT_Bees.speedBlinding);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)ENCELADUS.species, (IAlleleBeeSpecies)IRIDIUM.species, 4);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 9);
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
        }
    }
    ,
    MERCURY(GT_BranchDefinition.PLANET, "Mercury", false, 4866099, 11903624){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MERCURY), Float.valueOf(0.5f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, (IAlleleBeeSpecies)TUNGSTEN.species, 25, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"mercuryblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(37, "Mercury"));
        }
    }
    ,
    VENUS(GT_BranchDefinition.PLANET, "Venus", false, 4866099, 11903624){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VENUS), Float.valueOf(0.5f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, (IAlleleBeeSpecies)MITHRIL.species, 25, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"venusblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(39, "Venus"));
        }
    }
    ,
    MOON(GT_BranchDefinition.PLANET, "Moon", false, 0x373735, 0x7E7E78){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MOON), Float.valueOf(0.5f));
            if (Loader.isModLoaded((String)"dreamcraft")) {
                beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MoonStoneDust", 1L, 0), Float.valueOf(0.1f));
            }
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SPACE.species, (IAlleleBeeSpecies)CLAY.species, 25);
            if (Loader.isModLoaded((String)"GalacticraftCore")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalacticraftCore", (String)"tile.moonBlock"), 4);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(28, "Moon"));
        }
    }
    ,
    MARS(GT_BranchDefinition.PLANET, "Mars", false, 2231557, 3806469){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MarsStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MOON.species, (IAlleleBeeSpecies)IRON.species, 20);
            if (Loader.isModLoaded((String)"GalacticraftMars")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalacticraftMars", (String)"tile.mars"), 5);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(29, "Mars"));
        }
    }
    ,
    PHOBOS(GT_BranchDefinition.PLANET, "Phobos", true, 2231557, 8017670){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
            if (Loader.isModLoaded((String)"dreamcraft")) {
                beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PhobosStoneDust", 1L, 0), Float.valueOf(0.1f));
            }
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MARS.species, (IAlleleBeeSpecies)MOON.species, 20);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"phobosblocks"), 2);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(38, "Phobos"));
        }
    }
    ,
    DEIMOS(GT_BranchDefinition.PLANET, "Deimos", true, 2231557, 8008198){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MARS), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.DeimosStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MARS.species, (IAlleleBeeSpecies)SPACE.species, 20);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"deimosblocks"), 1);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(40, "Deimos"));
        }
    }
    ,
    CERES(GT_BranchDefinition.PLANET, "Ceres", true, 3974583, 1995367){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CeresStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MARS.species, (IAlleleBeeSpecies)METEORICIRON.species, 20);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ceresblocks"), 1);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(42, "Ceres"));
        }
    }
    ,
    JUPITER(GT_BranchDefinition.PLANET, "Jupiter", false, 7555886, 13683652){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoIceDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.IoStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaIceDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.GanymedStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MARS.species, (IAlleleBeeSpecies)DESH.species, 15);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Ledox"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteriods"));
        }
    }
    ,
    IO(GT_BranchDefinition.PLANET, "IO", true, 7555886, 15036443){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.IoStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, 114.getSpecies((byte)1, "volcanic"), 15);
            tMutation.restrictTemperature(EnumTemperature.HELLISH);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ioblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(36, "IO"));
        }
    }
    ,
    EUROPA(GT_BranchDefinition.PLANET, "Europa", true, 5866218, 734883){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EuropaIceDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, (IAlleleBeeSpecies)IRON.species, 15);
            tMutation.restrictTemperature(EnumTemperature.ICY);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"europagrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(35, "Europa"));
        }
    }
    ,
    GANYMEDE(GT_BranchDefinition.PLANET, "Ganymede", true, 4004624, 1641479){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.GanymedStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, (IAlleleBeeSpecies)TITANIUM.species, 15);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"ganymedeblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(43, "Ganymede"));
        }
    }
    ,
    CALLISTO(GT_BranchDefinition.PLANET, "Callisto", true, 996157, 885925){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.JUPITER), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CallistoIceDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, 117.getSpecies((byte)1, "artic"), 15);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"callistoblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(45, "Callisto"));
        }
    }
    ,
    SATURN(GT_BranchDefinition.PLANET, "Saturn", false, 13804658, 16302971){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TitanStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)JUPITER.species, (IAlleleBeeSpecies)LEDOX.species, 25, 2.0f);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.Quantinum"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteriods"));
        }
    }
    ,
    ENCELADUS(GT_BranchDefinition.PLANET, "Enceladus", true, 13804658, 1654688){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.EnceladusIceDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SATURN.species, (IAlleleBeeSpecies)CHROME.species, 25, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"enceladusblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(41, "Enceladus"));
        }
    }
    ,
    TITAN(GT_BranchDefinition.PLANET, "Titan", true, 10511387, 8130596){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SATURN), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TitanStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SATURN.species, (IAlleleBeeSpecies)NICKEL.species, 25, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"titanblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(44, "Titan"));
        }
    }
    ,
    URANUS(GT_BranchDefinition.PLANET, "Uranus", false, 7717065, 8706284){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.OberonStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SATURN.species, (IAlleleBeeSpecies)TRINIUM.species, 10);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"metalsblock"), 6);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteroids"));
        }
    }
    ,
    MIRANDA(GT_BranchDefinition.PLANET, "Miranda", true, 7717065, 860444){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MirandaStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URANUS.species, (IAlleleBeeSpecies)TIN.species, 10);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"mirandablocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(86, "Miranda"));
        }
    }
    ,
    OBERON(GT_BranchDefinition.PLANET, "Oberon", true, 4866099, 11903624){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANUS), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.OberonStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URANUS.species, (IAlleleBeeSpecies)IRIDIUM.species, 10);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"oberonblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(46, "Oberon"));
        }
    }
    ,
    NEPTUNE(GT_BranchDefinition.PLANET, "Neptune", false, 3362047, 5729791){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TritonStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URANUS.species, (IAlleleBeeSpecies)ORIHARUKON.species, 7);
            if (Loader.isModLoaded((String)"dreamcraft")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"dreamcraft", (String)"tile.MysteriousCrystal"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(30, "Asteroids"));
        }
    }
    ,
    PROTEUS(GT_BranchDefinition.PLANET, "Proteus", true, 3362047, 5842448){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.ProteusStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NEPTUNE.species, (IAlleleBeeSpecies)COPPER.species, 7);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"proteusblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(47, "Proteus"));
        }
    }
    ,
    TRITON(GT_BranchDefinition.PLANET, "Triton", true, 3362047, 4329752){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NEPTUN), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TritonStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NEPTUNE.species, (IAlleleBeeSpecies)GOLD.species, 7);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tritonblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(48, "Triton"));
        }
    }
    ,
    PLUTO(GT_BranchDefinition.PLANET, "Pluto", false, 3417886, 6901821){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLUTO), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PlutoStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.PlutoIceDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NEPTUNE.species, (IAlleleBeeSpecies)PLUTONIUM.species, 5);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"plutoblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(49, "Pluto"));
        }
    }
    ,
    HAUMEA(GT_BranchDefinition.PLANET, "Haumea", false, 1840147, 3746600){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.HAUMEA), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.HaumeaStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTO.species, (IAlleleBeeSpecies)NAQUADAH.species, 7, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"haumeablocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(83, "Haumea"));
        }
    }
    ,
    MAKEMAKE(GT_BranchDefinition.PLANET, "MakeMake", false, 3151889, 1182215){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MAKEMAKE), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.MakeMakeStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTO.species, (IAlleleBeeSpecies)NAQUADRIA.species, 7, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"makemakegrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(25, "MakeMake"));
        }
    }
    ,
    CENTAURI(GT_BranchDefinition.PLANET, "Centauri", false, 3090964, 11561778){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MAKEMAKE.species, (IAlleleBeeSpecies)DESH.species, 3);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"acentauribbgrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
        }
    }
    ,
    ACENTAURI(GT_BranchDefinition.PLANET, "aCentauri", false, 3090964, 10493460){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CENTAURI), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.CentauriASurfaceDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CENTAURI.species, (IAlleleBeeSpecies)INFINITYCATALYST.species, 3);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"acentauribbgrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(31, "aCentauri"));
        }
    }
    ,
    TCETI(GT_BranchDefinition.PLANET, "tCeti", false, 4596762, 8077615){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MAKEMAKE.species, (IAlleleBeeSpecies)HAUMEA.species, 5, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tcetieblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
        }
    }
    ,
    TCETIE(GT_BranchDefinition.PLANET, "tCetiE", false, 2971163, 790368){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TCETI), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.TCetiEStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TCETI.species, 133.getSpecies((byte)3, "TCWater"), 5, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"tcetieblocks"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(85, "tCeti E"));
        }
    }
    ,
    BARNARDA(GT_BranchDefinition.PLANET, "Barnarda", false, 875021, 15122829){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MAKEMAKE.species, (IAlleleBeeSpecies)THORIUM.species, 3, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
            }
            tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
        }
    }
    ,
    BARNARDAC(GT_BranchDefinition.PLANET, "BarnardaC", false, 875021, 4669194){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)BARNARDA.species, (IAlleleBeeSpecies)AMERICIUM.species, 3, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
                tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(32, "Barnarda C"));
            }
        }
    }
    ,
    BARNARDAE(GT_BranchDefinition.PLANET, "BarnardaE", false, 875021, 4988682){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaEStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)BARNARDA.species, (IAlleleBeeSpecies)DIVIDED.species, 3, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaEgrunt"), 0);
                tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(81, "Barnard E"));
            }
        }
    }
    ,
    BARNARDAF(GT_BranchDefinition.PLANET, "BarnardaF", false, 875021, 1968969){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.BARNARDA), Float.valueOf(0.25f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.BarnardaFStoneDust", 1L, 0), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)BARNARDA.species, (IAlleleBeeSpecies)NEUTRONIUM.species, 3, 2.0f);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"barnardaFgrunt"), 0);
                tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(82, "Barnard F"));
            }
        }
    }
    ,
    VEGA(GT_BranchDefinition.PLANET, "Vega", false, 1712182, 11911390){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.5f));
            beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.COLD);
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)MAKEMAKE.species, (IAlleleBeeSpecies)NAQUADAH.species, 2);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"vegabgrunt"), 0);
                tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(33, "Kuiper Belt"));
            }
        }
    }
    ,
    VEGAB(GT_BranchDefinition.PLANET, "VegaB", false, 1712182, 8512097){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.VEGA), Float.valueOf(0.5f));
            if (Loader.isModLoaded((String)"dreamcraft")) {
                beeSpecies.addSpecialty(GT_ModHandler.getModItem("dreamcraft", "item.VegaBStoneDust", 1L, 0), Float.valueOf(0.1f));
            }
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)VEGA.species, (IAlleleBeeSpecies)NAQUADRIA.species, 2);
            if (Loader.isModLoaded((String)"GalaxySpace")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"GalaxySpace", (String)"vegabgrunt"), 0);
                tMutation.addMutationCondition((IMutationCondition)new GT_Bees.DimensionMutationCondition(84, "VegaB"));
            }
        }
    }
    ,
    COSMICNEUTRONIUM(GT_BranchDefinition.PLANET, "CosmicNeutronium", false, 0x484848, 0x323232){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COSMICNEUTRONIUM), Float.valueOf(0.25f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NEUTRONIUM.species, (IAlleleBeeSpecies)BARNARDAF.species, 7, 10.0f);
            if (Loader.isModLoaded((String)"Avaritia")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"Avaritia", (String)"Resource_Block"), 0);
            }
        }
    }
    ,
    INFINITYCATALYST(GT_BranchDefinition.PLANET, "InfinityCatalyst", false, 0xFFFFFF, 0xFFFFFF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.INFINITYCATALYST), Float.valueOf(5.0E-7f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.EFFECT, (IAllele)141.getEffect((byte)1, "blindness"));
        }

        @Override
        protected void registerMutations() {
            IMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DOB.species, (IAlleleBeeSpecies)COSMICNEUTRONIUM.species, 3, 10.0f).setIsSecret();
            if (Loader.isModLoaded((String)"Avaritia")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"Avaritia", (String)"Resource_Block"), 1);
            }
        }
    }
    ,
    INFINITY(GT_BranchDefinition.PLANET, "Infinity", false, 0xFFFFFF, 0xFFFFFF){

        @Override
        protected void setSpeciesProperties(GT_AlleleBeeSpecies beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.INFINITY), Float.valueOf(5.0E-8f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
            beeSpecies.setHasEffect();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            AlleleHelper.instance.set(template, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTEST);
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)INFINITYCATALYST.species, (IAlleleBeeSpecies)COSMICNEUTRONIUM.species, 1, 100.0f);
            if (Loader.isModLoaded((String)"avaritiaddons")) {
                tMutation.requireResource(GameRegistry.findBlock((String)"avaritiaddons", (String)"InfinityChest"), 0);
            }
        }
    };

    private final GT_BranchDefinition branch;
    private final GT_AlleleBeeSpecies species;
    protected static final byte FORRESTRY = 0;
    protected static final byte EXTRABEES = 1;
    protected static final byte GENDUSTRY = 2;
    protected static final byte MAGICBEES = 3;
    protected static final byte GREGTECH = 4;
    private IAllele[] template;
    private IBeeGenome genome;

    private GT_BeeDefinition(GT_BranchDefinition branch, String binomial, boolean dominant, int primary, int secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = WordUtils.capitalize((String)lowercaseName);
        String uid = "gregtech.bee.species" + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        GT_LanguageManager.addStringLocalization("for.bees.species." + lowercaseName, species, true);
        this.branch = branch;
        this.species = new GT_AlleleBeeSpecies(uid, dominant, name, "GTNH", description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.init();
        }
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    protected static IAlleleBeeEffect getEffect(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.effect." + name;
                break;
            }
            case 2: {
                s = "gendustry.effect." + name;
                break;
            }
            case 3: {
                s = "magicbees.effect" + name;
                break;
            }
            case 4: {
                s = "gregtech.effect" + name;
                break;
            }
            default: {
                s = "forestry.effect" + name;
            }
        }
        return (IAlleleBeeEffect)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleFlowers getFlowers(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.flower." + name;
                break;
            }
            case 2: {
                s = "gendustry.flower." + name;
                break;
            }
            case 3: {
                s = "magicbees.flower" + name;
                break;
            }
            case 4: {
                s = "gregtech.flower" + name;
                break;
            }
            default: {
                s = "forestry.flowers" + name;
            }
        }
        return (IAlleleFlowers)AlleleManager.alleleRegistry.getAllele(s);
    }

    protected static IAlleleBeeSpecies getSpecies(byte modid, String name) {
        String s;
        switch (modid) {
            case 1: {
                s = "extrabees.species." + name;
                break;
            }
            case 2: {
                s = "gendustry.bee." + name;
                break;
            }
            case 3: {
                s = "magicbees.species" + name;
                break;
            }
            case 4: {
                s = "gregtech.species" + name;
                break;
            }
            default: {
                s = "forestry.species" + name;
            }
        }
        Object ret = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele(s);
        if (ret == null) {
            ret = GT_BeeDefinition.NAQUADRIA.species;
        }
        return ret;
    }

    protected abstract void setSpeciesProperties(GT_AlleleBeeSpecies var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return new GT_Bee_Mutation(parent1, parent2, this.getTemplate(), chance, 1.0f);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance, float chancedivider) {
        return new GT_Bee_Mutation(parent1, parent2, this.getTemplate(), chance, chancedivider);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }
}

