/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationCondition;
import forestry.apiculture.genetics.BeeMutation;
import forestry.core.genetics.mutations.Mutation;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import org.apache.commons.lang3.reflect.FieldUtils;

public class GT_Bee_Mutation
extends BeeMutation {
    private float split = 1.0f;

    public GT_Bee_Mutation(IAlleleBeeSpecies bee0, IAlleleBeeSpecies bee1, IAllele[] result, int chance, float split) {
        super(bee0, bee1, result, chance);
        this.split = split;
        BeeManager.beeRoot.registerMutation((IMutation)this);
    }

    public float getBaseChance() {
        return super.getBaseChance() / this.split;
    }

    public float getChance(IBeeHousing housing, IAlleleBeeSpecies allele0, IAlleleBeeSpecies allele1, IBeeGenome genome0, IBeeGenome genome1) {
        int z;
        int y;
        ChunkCoordinates housingCoordinates;
        int x;
        World world = housing != null ? housing.getWorld() : null;
        float processedChance = this.getBasicChance(world, x = (housingCoordinates = housing != null ? housing.getCoordinates() : null) != null ? housingCoordinates.field_71574_a : 0, y = housingCoordinates != null ? housingCoordinates.field_71572_b : 0, z = housingCoordinates != null ? housingCoordinates.field_71573_c : 0, (IAllele)allele0, (IAllele)allele1, (IGenome)genome0, (IGenome)genome1);
        if (processedChance <= 0.0f) {
            return 0.0f;
        }
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = BeeManager.beeRoot.getBeekeepingMode(world).getBeeModifier();
        processedChance *= beeHousingModifier.getMutationModifier(genome0, genome1, processedChance);
        processedChance *= beeModeModifier.getMutationModifier(genome0, genome1, processedChance);
        return processedChance;
    }

    private float getBasicChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        float mutationChance = this.getBaseChance();
        List mutationConditions = null;
        Field f = FieldUtils.getDeclaredField(Mutation.class, (String)"mutationConditions", (boolean)true);
        if (f == null) {
            f = FieldUtils.getField(Mutation.class, (String)"mutationConditions", (boolean)true);
        }
        if (f == null) {
            return mutationChance;
        }
        try {
            mutationConditions = f.get((Object)this) instanceof List ? (List)f.get((Object)this) : null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (mutationConditions != null) {
            for (IMutationCondition mutationCondition : mutationConditions) {
                if ((mutationChance *= mutationCondition.getChance(world, x, y, z, allele0, allele1, genome0, genome1)) != 0.0f) continue;
                return 0.0f;
            }
        }
        return mutationChance;
    }
}

