/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_Plunger_Fluid;
import gregtech.common.items.behaviors.Behaviour_Plunger_Item;
import gregtech.common.tools.GT_Tool;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class GT_Tool_Plunger
extends GT_Tool {
    @Override
    public float getBaseDamage() {
        return 1.25f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 0.25f;
    }

    @Override
    public String getCraftingSound() {
        return GregTech_API.sSoundList.get(101);
    }

    @Override
    public String getEntityHitSound() {
        return GregTech_API.sSoundList.get(101);
    }

    @Override
    public String getBreakingSound() {
        return GregTech_API.sSoundList.get(0);
    }

    @Override
    public String getMiningSound() {
        return GregTech_API.sSoundList.get(101);
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return aBlock.getHarvestLevel((int)aMetaData) != -1 && (tTool == null || tTool.isEmpty() || tTool.equals("plunger"));
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.PLUNGER : null;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mRGBa : GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public void onStatsAddedToTool(GT_MetaGenerated_Tool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behaviour_Plunger_Item(this.getToolDamagePerDropConversion()));
        aItem.addItemBehavior(aID, new Behaviour_Plunger_Fluid(this.getToolDamagePerDropConversion()));
        try {
            Object tObject = GT_Utility.callConstructor("gregtech.common.items.behaviors.Behaviour_Plunger_Essentia", 0, null, false, this.getToolDamagePerDropConversion());
            if (tObject instanceof IItemBehaviour) {
                aItem.addItemBehavior(aID, (IItemBehaviour)tObject);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " got stuck trying to escape through a Pipe while fighting " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

