/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.Textures;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.interfaces.ITexture;
import gregtech.api.objects.GT_CopiedBlockTexture;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class ProcessingPlate
implements IOreRecipeRegistrator {
    public ProcessingPlate() {
        OrePrefixes.plate.add(this);
        OrePrefixes.plateDouble.add(this);
        OrePrefixes.plateTriple.add(this);
        OrePrefixes.plateQuadruple.add(this);
        OrePrefixes.plateQuintuple.add(this);
        OrePrefixes.plateDense.add(this);
        OrePrefixes.plateAlloy.add(this);
        OrePrefixes.itemCasing.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        long aMaterialMass = aMaterial.getMass();
        switch (aPrefix) {
            case plate: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GT_ModHandler.removeRecipe(aStack);
                if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
                    GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Plate.get(0L, new Object[0]), aMaterial.getMolten(144L), GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), 32, 8);
                }
                switch (aMaterial.mName) {
                    case "Iron": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150339_S, 1, 0), null);
                        break;
                    }
                    case "Gold": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150340_R, 1, 0), null);
                        break;
                    }
                    case "Diamond": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150484_ah, 1, 0), null);
                        break;
                    }
                    case "Emerald": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150475_bE, 1, 0), null);
                        break;
                    }
                    case "Lapis": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150368_y, 1, 0), null);
                        break;
                    }
                    case "Coal": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150402_ci, 1, 0), null);
                        break;
                    }
                    case "Redstone": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150451_bX, 1, 0), null);
                        break;
                    }
                    case "Glowstone": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150426_aN, 1, 0), null);
                        break;
                    }
                    case "NetherQuartz": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150371_ca, 1, 0), null);
                        break;
                    }
                    case "Obsidian": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150343_Z, 1, 0), null);
                        break;
                    }
                    case "Stone": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_CopiedBlockTexture(Blocks.field_150348_b, 1, 0), null);
                        break;
                    }
                    case "GraniteBlack": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(Textures.BlockIcons.GRANITE_BLACK_SMOOTH), null);
                        break;
                    }
                    case "GraniteRed": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(Textures.BlockIcons.GRANITE_RED_SMOOTH), null);
                        break;
                    }
                    case "Basalt": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(Textures.BlockIcons.BASALT_SMOOTH), null);
                        break;
                    }
                    case "Marble": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(Textures.BlockIcons.MARBLE_SMOOTH), null);
                        break;
                    }
                    case "Concrete": {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(Textures.BlockIcons.CONCRETE_LIGHT_SMOOTH), null);
                        break;
                    }
                    default: {
                        GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[71], aMaterial.mRGBa, false), null);
                    }
                }
                if (aMaterial.mFuelPower > 0) {
                    GT_Values.RA.addFuel(GT_Utility.copyAmount(1L, aStack), null, aMaterial.mFuelPower, aMaterial.mFuelType);
                }
                GT_Utility.removeSimpleIC2MachineRecipe(GT_Utility.copyAmount(9L, aStack), GT_ModHandler.getCompressorRecipeList(), GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L));
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"hX", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                if (aMaterial == Materials.Paper) {
                    GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.harderrecipes, aStack, true) ? 2L : 3L, aStack), new Object[]{"XXX", Character.valueOf('X'), new ItemStack(Items.field_151120_aE, 1, Short.MAX_VALUE)});
                }
                if (!aMaterial.mUnificatable || aMaterial.mMaterialInto != aMaterial) break;
                if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true)) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h", "X", "X", Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                }
                if (!aMaterial.contains(SubTag.MORTAR_GRINDABLE) || !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.mortar, aMaterial.mName, true)) break;
                GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.dust, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                break;
            }
            case plateDouble: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[72], aMaterial.mRGBa, false), null);
                if (!aNoSmashing) {
                    GT_Values.RA.addBenderRecipe(GT_Utility.copyAmount(2L, aStack), GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L), (int)Math.max(aMaterialMass * 2L, 1L), 96);
                    if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerdoubleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                        Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                        GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), aPlateStack, Character.valueOf('B'), aPlateStack});
                        GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack});
                    }
                    GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 2L, 1L), 96);
                    break;
                }
                GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), ItemList.Circuit_Integrated.getWithDamage(0L, 2L, new Object[0]), Materials.Glue.getFluid(10L), GT_Utility.copyAmount(1L, aStack), 64, 8);
                break;
            }
            case plateTriple: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[73], aMaterial.mRGBa, false), null);
                if (!aNoSmashing) {
                    GT_Values.RA.addBenderRecipe(GT_Utility.copyAmount(3L, aStack), GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L), (int)Math.max(aMaterialMass * 3L, 1L), 96);
                    if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammertripleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                        Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                        GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateDouble.get(aMaterial), Character.valueOf('B'), aPlateStack});
                        GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack});
                    }
                    GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 3L, 1L), 96);
                } else {
                    GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), ItemList.Circuit_Integrated.getWithDamage(0L, 3L, new Object[0]), Materials.Glue.getFluid(20L), GT_Utility.copyAmount(1L, aStack), 96, 8);
                }
                GT_Values.RA.addImplosionRecipe(GT_Utility.copyAmount(1L, aStack), 2, GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L));
                break;
            }
            case plateQuadruple: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[74], aMaterial.mRGBa, false), null);
                if (!aNoWorking) {
                    GT_Values.RA.addCNCRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial, 1L), (int)Math.max(aMaterialMass * 2L, 1L), 30);
                }
                if (!aNoSmashing) {
                    if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquadrupleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                        Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                        GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateTriple.get(aMaterial), Character.valueOf('B'), aPlateStack});
                        GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
                    }
                    GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 4L, 1L), 96);
                    break;
                }
                GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), ItemList.Circuit_Integrated.getWithDamage(0L, 4L, new Object[0]), Materials.Glue.getFluid(30L), GT_Utility.copyAmount(1L, aStack), 128, 8);
                break;
            }
            case plateQuintuple: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[75], aMaterial.mRGBa, false), null);
                if (!aNoSmashing) {
                    if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquintupleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                        Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                        GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateQuadruple.get(aMaterial), Character.valueOf('B'), aPlateStack});
                        GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
                    }
                    GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 5L, 1L), 96);
                    break;
                }
                GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), ItemList.Circuit_Integrated.getWithDamage(0L, 5L, new Object[0]), Materials.Glue.getFluid(40L), GT_Utility.copyAmount(1L, aStack), 160, 8);
                break;
            }
            case plateDense: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                GregTech_API.registerCover(aStack, (ITexture)new GT_RenderedTexture(aMaterial.mIconSet.mTextures[76], aMaterial.mRGBa, false), null);
                if (aNoSmashing) break;
                GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 9L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 9L, 1L), 96);
                break;
            }
            case itemCasing: {
                GT_ModHandler.removeRecipeByOutput(aStack);
                if (aMaterial.mStandardMoltenFluid != null) {
                    GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Casing.get(0L, new Object[0]), aMaterial.getMolten(72L), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), 16, 8);
                }
                if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true)) {
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h X", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                    GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"H X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
                }
                GT_Values.RA.addAlloySmelterRecipe(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 2L), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_Utility.copyAmount(3L, aStack), 128, 15);
                GT_Values.RA.addCutterRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L), null, (int)Math.max(aMaterial.getMass(), 1L), 16);
                GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L), (int)Math.max(aMaterial.getMass(), 1L), 45);
                GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
                break;
            }
            case plateAlloy: {
                switch (aOreDictName) {
                    case "plateAlloyCarbon": {
                        GT_Values.RA.addAssemblerRecipe(GT_ModHandler.getIC2Item("generator", 1L), GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("windMill", 1L), 6400, 8);
                    }
                    case "plateAlloyAdvanced": {
                        GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), new ItemStack(Blocks.field_150359_w, 3, Short.MAX_VALUE), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                        GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Glass, 3L), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                    }
                    case "plateAlloyIridium": {
                        GT_ModHandler.removeRecipeByOutput(aStack);
                    }
                    case "plateIron": 
                    case "plateCopper": 
                    case "plateTin": 
                    case "plateBronze": 
                    case "plateGold": 
                    case "plateSteel ": 
                    case "plateLead": 
                    case "plateAluminium": 
                    case "plateStainlessSteel": 
                    case "plateTitanium": 
                    case "plateTungsten": 
                    case "plateTungstenSteel": 
                    case "plateIridium": 
                    case "plateChrome": 
                    case "plateOsmium": 
                    case "plateNeutronium": {
                        GT_ModHandler.removeRecipeByOutput(aStack);
                    }
                }
                break;
            }
        }
    }
}

