/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_Slot_Holo;
import gregtech.api.gui.GT_Slot_Output;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_Container_BasicMachine
extends GT_Container_BasicTank {
    public boolean mFluidTransfer = false;
    public boolean mItemTransfer = false;
    public boolean mStuttering = false;

    public GT_Container_BasicMachine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.addSlotToContainer(new GT_Slot_Holo((IInventory)this.mTileEntity, 0, 8, 63, false, true, 1));
        this.addSlotToContainer(new GT_Slot_Holo((IInventory)this.mTileEntity, 0, 26, 63, false, true, 1));
        this.addSlotToContainer(new GT_Slot_Render((IInventory)this.mTileEntity, 2, 107, 63));
        int tStartIndex = ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).getInputSlot();
        switch (((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mInputSlotCount) {
            case 0: {
                break;
            }
            case 1: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                break;
            }
            case 2: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                break;
            }
            case 3: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                break;
            }
            case 4: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 34));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 34));
                break;
            }
            case 5: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 34));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 34));
                break;
            }
            case 6: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 16));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 34));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 34));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 34));
                break;
            }
            case 7: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 43));
                break;
            }
            case 8: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 43));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 43));
                break;
            }
            default: {
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 7));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 25));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 17, 43));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 35, 43));
                this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, tStartIndex++, 53, 43));
            }
        }
        tStartIndex = ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).getOutputSlot();
        switch (((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mOutputItems.length) {
            case 0: {
                break;
            }
            case 1: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                break;
            }
            case 2: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 25));
                break;
            }
            case 3: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 25));
                break;
            }
            case 4: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 34));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 34));
                break;
            }
            case 5: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 34));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 34));
                break;
            }
            case 6: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 16));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 34));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 34));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 34));
                break;
            }
            case 7: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 43));
                break;
            }
            case 8: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 43));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 43));
                break;
            }
            default: {
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 7));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 25));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 107, 43));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 125, 43));
                this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, tStartIndex++, 143, 43));
            }
        }
        this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, 1, 80, 63));
        this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, 3, 125, 63));
        this.addSlotToContainer(new GT_Slot_Render((IInventory)this.mTileEntity, tStartIndex++, 53, 63));
    }

    @Override
    public ItemStack slotClick(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        GT_MetaTileEntity_BasicMachine machine = (GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity();
        if (machine == null) {
            return null;
        }
        switch (aSlotIndex) {
            case 0: {
                machine.mFluidTransfer = !machine.mFluidTransfer;
                return null;
            }
            case 1: {
                if (this.mTileEntity.getMetaTileEntity() == null) {
                    return null;
                }
                machine.mItemTransfer = !machine.mItemTransfer;
                return null;
            }
            case 2: {
                if (aMouseclick > 1) {
                    return null;
                }
                ItemStack tResultStack = this.pickupFluid(machine.getDrainableStack(), aPlayer, aMouseclick == 0);
                if (machine.getDrainableStack() != null && machine.getDrainableStack().amount == 0) {
                    machine.setDrainableStack(null);
                }
                return tResultStack;
            }
        }
        if (aSlotIndex == 5 + machine.mInputSlotCount + machine.mOutputItems.length) {
            if (aMouseclick > 1) {
                return null;
            }
            ItemStack tStackHeld = aPlayer.inventory.getItemStack();
            ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
            if (tStackSizedOne == null || tStackHeld.stackSize == 0) {
                return null;
            }
            FluidStack tInputFluid = machine.getFillableStack();
            FluidStack tFluidHeld = GT_Utility.getFluidForFilledItem(tStackSizedOne, true);
            if (tFluidHeld != null && tFluidHeld.amount <= 0) {
                tFluidHeld = null;
            }
            if (tInputFluid == null) {
                if (tFluidHeld == null) {
                    return null;
                }
                return this.fillFluid(machine, aPlayer, tFluidHeld, aMouseclick == 0);
            }
            if (tFluidHeld != null && tInputFluid.amount < machine.getCapacity()) {
                return this.fillFluid(machine, aPlayer, tFluidHeld, aMouseclick == 0);
            }
            ItemStack tResultStack = this.pickupFluid(tInputFluid, aPlayer, aMouseclick == 0);
            if (tInputFluid.amount == 0) {
                machine.setFillableStack(null);
            }
            return tResultStack;
        }
        return super.slotClick(aSlotIndex, aMouseclick, aShifthold, aPlayer);
    }

    private ItemStack pickupFluid(FluidStack aTankStack, EntityPlayer aPlayer, boolean aProcessFullStack) {
        IFluidContainerItem tContainerItem;
        int tFilledAmount;
        if (aTankStack == null) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.inventory.getItemStack();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null || tStackHeld.stackSize == 0) {
            return null;
        }
        int tOriginalFluidAmount = aTankStack.amount;
        ItemStack tFilled = GT_Utility.fillFluidContainer(aTankStack, tStackSizedOne, true, false);
        if (tFilled == null && tStackSizedOne.getItem() instanceof IFluidContainerItem && (tFilledAmount = (tContainerItem = (IFluidContainerItem)tStackSizedOne.getItem()).fill(tStackSizedOne, aTankStack, true)) > 0) {
            tFilled = tStackSizedOne;
            aTankStack.amount -= tFilledAmount;
        }
        if (tFilled != null) {
            if (aProcessFullStack) {
                int tFilledAmount2 = tOriginalFluidAmount - aTankStack.amount;
                int tAdditionalParallel = Math.min(tStackHeld.stackSize - 1, aTankStack.amount / tFilledAmount2);
                aTankStack.amount -= tFilledAmount2 * tAdditionalParallel;
                tFilled.stackSize += tAdditionalParallel;
            }
            this.replaceCursorItemStack(aPlayer, tFilled);
        }
        return tFilled;
    }

    private ItemStack fillFluid(GT_MetaTileEntity_BasicMachine aMachine, EntityPlayer aPlayer, FluidStack aFluidHeld, boolean aProcessFullStack) {
        int tParallel;
        IFluidContainerItem container;
        FluidStack tDrained;
        if (aMachine.getFillableStack() != null && !aMachine.getFillableStack().isFluidEqual(aFluidHeld)) {
            return null;
        }
        ItemStack tStackHeld = aPlayer.inventory.getItemStack();
        ItemStack tStackSizedOne = GT_Utility.copyAmount(1L, tStackHeld);
        if (tStackSizedOne == null) {
            return null;
        }
        int tFreeSpace = aMachine.getCapacity() - (aMachine.getFillableStack() != null ? aMachine.getFillableStack().amount : 0);
        if (tFreeSpace <= 0) {
            return null;
        }
        ItemStack tStackEmptied = null;
        int tAmountTaken = 0;
        if (tFreeSpace >= aFluidHeld.amount) {
            tStackEmptied = GT_Utility.getContainerForFilledItem(tStackSizedOne, false);
            tAmountTaken = aFluidHeld.amount;
        }
        if (tStackEmptied == null && tStackSizedOne.getItem() instanceof IFluidContainerItem && (tDrained = (container = (IFluidContainerItem)tStackSizedOne.getItem()).drain(tStackSizedOne, tFreeSpace, true)) != null && tDrained.amount > 0) {
            tStackEmptied = tStackSizedOne;
            tAmountTaken = tDrained.amount;
        }
        if (tStackEmptied == null) {
            return null;
        }
        int n = tParallel = aProcessFullStack ? Math.min(tFreeSpace / tAmountTaken, tStackHeld.stackSize) : 1;
        if (aMachine.getFillableStack() == null) {
            FluidStack tNewFillableStack = aFluidHeld.copy();
            tNewFillableStack.amount = tAmountTaken * tParallel;
            aMachine.setFillableStack(tNewFillableStack);
        } else {
            aMachine.getFillableStack().amount += tAmountTaken * tParallel;
        }
        tStackEmptied.stackSize = tParallel;
        this.replaceCursorItemStack(aPlayer, tStackEmptied);
        return tStackEmptied;
    }

    private void replaceCursorItemStack(EntityPlayer aPlayer, ItemStack tStackResult) {
        int tStackResultMaxStackSize = tStackResult.getMaxStackSize();
        while (tStackResult.stackSize > tStackResultMaxStackSize) {
            aPlayer.inventory.getItemStack().stackSize -= tStackResultMaxStackSize;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult.splitStack(tStackResultMaxStackSize));
        }
        if (aPlayer.inventory.getItemStack().stackSize == tStackResult.stackSize) {
            aPlayer.inventory.setItemStack(tStackResult);
        } else {
            ItemStack tStackHeld = aPlayer.inventory.getItemStack();
            tStackHeld.stackSize -= tStackResult.stackSize;
            GT_Utility.addItemToPlayerInventory(aPlayer, tStackResult);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.mTileEntity.isClientSide() || this.mTileEntity.getMetaTileEntity() == null) {
            return;
        }
        this.mFluidTransfer = ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mFluidTransfer;
        this.mItemTransfer = ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mItemTransfer;
        this.mStuttering = ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mStuttering;
        for (Object crafter : this.crafters) {
            ICrafting var1 = (ICrafting)crafter;
            var1.sendProgressBarUpdate((Container)this, 102, this.mFluidTransfer ? 1 : 0);
            var1.sendProgressBarUpdate((Container)this, 103, this.mItemTransfer ? 1 : 0);
            var1.sendProgressBarUpdate((Container)this, 104, this.mStuttering ? 1 : 0);
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting par1ICrafting) {
        super.addCraftingToCrafters(par1ICrafting);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int par1, int par2) {
        super.updateProgressBar(par1, par2);
        switch (par1) {
            case 102: {
                this.mFluidTransfer = par2 != 0;
                break;
            }
            case 103: {
                this.mItemTransfer = par2 != 0;
                break;
            }
            case 104: {
                this.mStuttering = par2 != 0;
            }
        }
    }

    @Override
    public int getSlotStartIndex() {
        return 3;
    }

    @Override
    public int getShiftClickStartIndex() {
        return 3;
    }

    @Override
    public int getSlotCount() {
        return this.getShiftClickSlotCount() + ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mOutputItems.length + 2;
    }

    @Override
    public int getShiftClickSlotCount() {
        return ((GT_MetaTileEntity_BasicMachine)this.mTileEntity.getMetaTileEntity()).mInputSlotCount;
    }
}

