/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;

public class GT_EnergyArmor_Item
extends ItemArmor
implements ISpecialArmor {
    public static Map jumpChargeMap = new ConcurrentHashMap();
    public int mCharge;
    public int mTransfer;
    public int mTier;
    public int mDamageEnergyCost;
    public int mSpecials;
    public boolean mChargeProvider;
    public double mArmorAbsorbtionPercentage;

    public GT_EnergyArmor_Item(int aID, String aUnlocalized, String aEnglish, int aCharge, int aTransfer, int aTier, int aDamageEnergyCost, int aSpecials, double aArmorAbsorbtionPercentage, boolean aChargeProvider, int aType, int aArmorIndex) {
        super(ItemArmor.ArmorMaterial.DIAMOND, aArmorIndex, aType);
        this.setMaxStackSize(1);
        this.setMaxDamage(100);
        this.setNoRepair();
        this.setUnlocalizedName(aUnlocalized);
        GT_LanguageManager.addStringLocalization(this.getUnlocalizedName() + ".name", aEnglish);
        this.mCharge = Math.max(1, aCharge);
        this.mTransfer = Math.max(1, aTransfer);
        this.mTier = Math.max(1, aTier);
        this.mSpecials = aSpecials;
        this.mChargeProvider = aChargeProvider;
        this.mDamageEnergyCost = Math.max(0, aDamageEnergyCost);
        this.mArmorAbsorbtionPercentage = aArmorAbsorbtionPercentage;
        this.setCreativeTab(GregTech_API.TAB_GREGTECH);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void setCharge(ItemStack aStack) {
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.setInteger("charge", 1000000000);
        aStack.setTagCompound(tNBT);
    }

    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        ItemStack tStack = aPlayer.inventory.armorInventory[3 - this.armorType];
        if (tStack != null) {
            for (int i = 0; i < 9; ++i) {
                if (aPlayer.inventory.mainInventory[i] != aStack) continue;
                aPlayer.inventory.armorInventory[3 - this.armorType] = aPlayer.inventory.mainInventory[i];
                aPlayer.inventory.mainInventory[i] = tStack;
                return tStack;
            }
        }
        return super.onItemRightClick(aStack, aWorld, aPlayer);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.itemIcon = aIconRegister.registerIcon("gregtech:" + this.getUnlocalizedName());
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        aList.add("Tier: " + this.mTier);
        if ((this.mSpecials & 1) != 0) {
            aList.add("Rebreather");
        }
        if ((this.mSpecials & 2) != 0) {
            aList.add("Inertia Damper");
        }
        if ((this.mSpecials & 4) != 0) {
            aList.add("Food Replicator");
        }
        if ((this.mSpecials & 8) != 0) {
            aList.add("Medicine Module");
        }
        if ((this.mSpecials & 0x10) != 0) {
            aList.add("Lamp");
        }
        if ((this.mSpecials & 0x20) != 0) {
            aList.add("Solarpanel");
        }
        if ((this.mSpecials & 0x40) != 0) {
            aList.add("Extinguisher Module");
        }
        if ((this.mSpecials & 0x80) != 0) {
            aList.add("Jump Booster");
        }
        if ((this.mSpecials & 0x100) != 0) {
            aList.add("Speed Booster");
        }
        if ((this.mSpecials & 0x200) != 0) {
            aList.add("Invisibility Field");
        }
        if ((this.mSpecials & 0x400) != 0) {
            aList.add("Infinite Charge");
        }
    }

    public void onArmorTick(World aWorld, EntityPlayer aPlayer, ItemStack aStack) {
        if (this.mSpecials == 0) {
            return;
        }
        if (!aPlayer.worldObj.isRemote && (this.mSpecials & 1) != 0) {
            int var4 = aPlayer.getAir();
            if (GT_ModHandler.canUseElectricItem(aStack, 1000) && var4 < 50) {
                aPlayer.setAir(var4 + 250);
                GT_ModHandler.useElectricItem(aStack, 1000, aPlayer);
            }
        }
        if (!aPlayer.worldObj.isRemote && (this.mSpecials & 4) != 0 && GT_ModHandler.canUseElectricItem(aStack, 50000) && aPlayer.getFoodStats().needFood()) {
            aPlayer.getFoodStats().addStats(1, 0.0f);
            GT_ModHandler.useElectricItem(aStack, 50000, aPlayer);
        }
        if ((this.mSpecials & 8) != 0) {
            if (GT_ModHandler.canUseElectricItem(aStack, 10000) && aPlayer.isPotionActive(Potion.poison)) {
                GT_Utility.removePotion((EntityLivingBase)aPlayer, Potion.poison.id);
                GT_ModHandler.useElectricItem(aStack, 10000, aPlayer);
            }
            if (GT_ModHandler.canUseElectricItem(aStack, 100000) && aPlayer.isPotionActive(Potion.wither)) {
                GT_Utility.removePotion((EntityLivingBase)aPlayer, Potion.wither.id);
                GT_ModHandler.useElectricItem(aStack, 100000, aPlayer);
            }
        }
        if ((this.mSpecials & 0x40) != 0) {
            aPlayer.setFire(0);
        }
        if (!aPlayer.worldObj.isRemote && (this.mSpecials & 0x80) != 0) {
            float var6;
            float f = var6 = jumpChargeMap.containsKey(aPlayer) ? ((Float)jumpChargeMap.get(aPlayer)).floatValue() : 1.0f;
            if (GT_ModHandler.canUseElectricItem(aStack, 1000) && aPlayer.onGround && var6 < 1.0f) {
                var6 = 1.0f;
                GT_ModHandler.useElectricItem(aStack, 1000, aPlayer);
            }
            if (aPlayer.motionY >= 0.0 && var6 > 0.0f && !aPlayer.isInWater()) {
                if (GT_ModHandler.getJumpKeyDown(aPlayer) && GT_ModHandler.getBoostKeyDown(aPlayer)) {
                    if (var6 == 1.0f) {
                        aPlayer.motionX *= 3.5;
                        aPlayer.motionZ *= 3.5;
                    }
                    aPlayer.motionY += (double)(var6 * 0.3f);
                    var6 = (float)((double)var6 * 0.75);
                } else if (var6 < 1.0f) {
                    var6 = 0.0f;
                }
            }
            jumpChargeMap.put(aPlayer, Float.valueOf(var6));
        }
        if ((this.mSpecials & 0x100) != 0 && GT_ModHandler.canUseElectricItem(aStack, 100) && aPlayer.isSprinting() && (aPlayer.onGround && Math.abs(aPlayer.motionX) + Math.abs(aPlayer.motionZ) > (double)0.1f || aPlayer.isInWater())) {
            GT_ModHandler.useElectricItem(aStack, 100, aPlayer);
            float var7 = 0.22f;
            if (aPlayer.isInWater()) {
                GT_ModHandler.useElectricItem(aStack, 100, aPlayer);
                var7 = 0.1f;
                if (aPlayer.motionY > 0.0) {
                    aPlayer.motionY += (double)0.1f;
                }
            }
            if (var7 > 0.0f) {
                aPlayer.moveFlying(0.0f, 1.0f, var7);
            }
        }
        if ((this.mSpecials & 0x200) != 0 && GT_ModHandler.canUseElectricItem(aStack, 10000)) {
            GT_ModHandler.useElectricItem(aStack, 10000, aPlayer);
            aPlayer.addPotionEffect(new PotionEffect(Potion.invisibility.getId(), 25, 1, true));
        }
        if (!aPlayer.worldObj.isRemote && (this.mSpecials & 0x30) != 0) {
            ItemStack tTargetChargeItem = aStack;
            ItemStack tTargetDechargeItem = aStack;
            if (GT_ModHandler.chargeElectricItem(tTargetChargeItem, 1, Integer.MAX_VALUE, true, true) < 1) {
                tTargetChargeItem = aPlayer.inventory.armorInventory[2];
            }
            if (GT_ModHandler.dischargeElectricItem(tTargetDechargeItem, 10, Integer.MAX_VALUE, true, true, true) < 10) {
                tTargetDechargeItem = aPlayer.inventory.armorInventory[2];
            }
            if (tTargetChargeItem == null || !GT_ModHandler.isElectricItem(tTargetChargeItem)) {
                tTargetChargeItem = null;
            }
            if (aPlayer.worldObj.isDaytime() && aPlayer.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)aPlayer.posX), MathHelper.floor_double((double)(aPlayer.posY + 1.0)), MathHelper.floor_double((double)aPlayer.posZ)) && (this.mSpecials & 0x20) != 0 && tTargetChargeItem != null) {
                GT_ModHandler.chargeElectricItem(tTargetChargeItem, 20, Integer.MAX_VALUE, true, false);
            }
        }
    }

    public boolean getShareTag() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item aItem, CreativeTabs var2, List var3) {
        ItemStack tCharged = new ItemStack((Item)this, 1);
        ItemStack tUncharged = new ItemStack((Item)this, 1, this.getMaxDamage());
        GT_ModHandler.chargeElectricItem(tCharged, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false);
        var3.add(tCharged);
        var3.add(tUncharged);
    }

    public boolean canProvideEnergy(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mChargeProvider;
    }

    public Item getChargedItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public Item getEmptyItem(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this;
    }

    public int getMaxCharge(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mCharge;
    }

    public int getTier(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTier;
    }

    public int getTransferLimit(ItemStack aStack) {
        if ((this.mSpecials & 0x400) != 0) {
            GT_EnergyArmor_Item.setCharge(aStack);
        }
        return this.mTransfer;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack itemstack1, ItemStack itemstack2) {
        return false;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public void onEntityLivingFallEvent(LivingFallEvent var1) {
        if (!var1.entity.worldObj.isRemote && var1.entity instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1.entity;
            for (int i = 0; i < 4; ++i) {
                int var4;
                int var5;
                ItemStack var3 = var2.inventory.armorInventory[i];
                if (var3 == null || var3.getItem() != this || (this.mSpecials & 2) == 0 || (var5 = this.mDamageEnergyCost * (var4 = (int)var1.distance - 3) / 4) > GT_ModHandler.dischargeElectricItem(var3, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true)) continue;
                GT_ModHandler.dischargeElectricItem(var3, var5, Integer.MAX_VALUE, true, false, true);
                var1.setCanceled(true);
                break;
            }
        }
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase var1, ItemStack var2, DamageSource var3, double var4, int var6) {
        return new ISpecialArmor.ArmorProperties(var3 == DamageSource.fall && (this.mSpecials & 2) != 0 ? 10 : 0, this.getBaseAbsorptionRatio() * this.mArmorAbsorbtionPercentage, this.mDamageEnergyCost > 0 ? 25 * GT_ModHandler.dischargeElectricItem(var2, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true) / this.mDamageEnergyCost : 0);
    }

    public int getArmorDisplay(EntityPlayer var1, ItemStack var2, int var3) {
        return (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.mArmorAbsorbtionPercentage);
    }

    public void damageArmor(EntityLivingBase var1, ItemStack var2, DamageSource var3, int var4, int var5) {
        GT_ModHandler.dischargeElectricItem(var2, var4 * this.mDamageEnergyCost, Integer.MAX_VALUE, true, false, true);
    }

    private double getBaseAbsorptionRatio() {
        if (this.mArmorAbsorbtionPercentage <= 0.0) {
            return 0.0;
        }
        switch (this.armorType) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }
}

