/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_1by1;
import gregtech.api.gui.GT_Container_2by2;
import gregtech.api.gui.GT_Container_3by3;
import gregtech.api.gui.GT_Container_4by4;
import gregtech.api.gui.GT_GUIContainer_1by1;
import gregtech.api.gui.GT_GUIContainer_2by2;
import gregtech.api.gui.GT_GUIContainer_3by3;
import gregtech.api.gui.GT_GUIContainer_4by4;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class GT_MetaTileEntity_BasicBatteryBuffer
extends GT_MetaTileEntity_TieredMachineBlock {
    public boolean mCharge = false;
    public boolean mDecharge = false;
    public int mBatteryCount = 0;
    public int mChargeableCount = 0;
    private long count = 0L;
    private long mStored = 0L;
    private long mMax = 0L;

    public GT_MetaTileEntity_BasicBatteryBuffer(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_BasicBatteryBuffer(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicBatteryBuffer(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = this.mInventory.length + " Slots";
        return desc;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[2][17][];
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1]};
            rTextures[1][i + 1] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i + 1], this.mInventory.length == 16 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_POWER[this.mTier] : (this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mTier] : Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier])};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide == aFacing ? 1 : 0][aColorIndex + 1];
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BasicBatteryBuffer(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mInventory.length);
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L * (long)this.mInventory.length;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return (long)this.mChargeableCount * 2L;
    }

    @Override
    public long maxAmperesOut() {
        return this.mBatteryCount;
    }

    @Override
    public int rechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int dechargerSlotStartIndex() {
        return 0;
    }

    @Override
    public int rechargerSlotCount() {
        return this.mCharge ? this.mInventory.length : 0;
    }

    @Override
    public int dechargerSlotCount() {
        return this.mDecharge ? this.mInventory.length : 0;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mInventory.length) {
            case 1: {
                return new GT_Container_1by1(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 4: {
                return new GT_Container_2by2(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 9: {
                return new GT_Container_3by3(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 16: {
                return new GT_Container_4by4(aPlayerInventory, aBaseMetaTileEntity);
            }
        }
        return new GT_Container_1by1(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mInventory.length) {
            case 1: {
                return new GT_GUIContainer_1by1(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
            }
            case 4: {
                return new GT_GUIContainer_2by2(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
            }
            case 9: {
                return new GT_GUIContainer_3by3(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
            }
            case 16: {
                return new GT_GUIContainer_4by4(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
            }
        }
        return new GT_GUIContainer_1by1(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mBatteryCount = 0;
            this.mChargeableCount = 0;
            for (ItemStack tStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem(tStack, this.mTier)) continue;
                if (GT_ModHandler.isChargerItem(tStack)) {
                    ++this.mBatteryCount;
                }
                ++this.mChargeableCount;
            }
        }
        ++this.count;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        String name;
        return GT_ModHandler.isElectricItem(aStack) && aStack.getUnlocalizedName().startsWith("gt.metaitem.01.") && ((name = aStack.getUnlocalizedName()).equals("gt.metaitem.01.32510") || name.equals("gt.metaitem.01.32511") || name.equals("gt.metaitem.01.32520") || name.equals("gt.metaitem.01.32521") || name.equals("gt.metaitem.01.32530") || name.equals("gt.metaitem.01.32531")) && ElectricItem.manager.getCharge(aStack) == 0.0;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (!GT_Utility.isStackValid(aStack)) {
            return false;
        }
        return this.mInventory[aIndex] == null && GT_ModHandler.isElectricItem(aStack, this.mTier);
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    public long[] getStoredEnergy() {
        boolean scaleOverflow = false;
        boolean storedOverflow = false;
        long tScale = this.getBaseMetaTileEntity().getEUCapacity();
        long tStored = this.getBaseMetaTileEntity().getStoredEU();
        long tStep = 0L;
        if (this.mInventory != null) {
            for (ItemStack aStack : this.mInventory) {
                if (!GT_ModHandler.isElectricItem(aStack)) continue;
                if (aStack.getItem() instanceof GT_MetaBase_Item) {
                    Long[] stats = ((GT_MetaBase_Item)aStack.getItem()).getElectricStats(aStack);
                    if (stats == null) continue;
                    if (stats[0] > 0x3FFFFFFFFFFFFFFFL) {
                        scaleOverflow = true;
                    }
                    tScale += stats[0].longValue();
                    tStep = ((GT_MetaBase_Item)aStack.getItem()).getRealCharge(aStack);
                    if (tStep > 0x3FFFFFFFFFFFFFFFL) {
                        storedOverflow = true;
                    }
                    tStored += tStep;
                    continue;
                }
                if (!(aStack.getItem() instanceof IElectricItem)) continue;
                tStored += (long)ElectricItem.manager.getCharge(aStack);
                tScale += (long)((IElectricItem)aStack.getItem()).getMaxCharge(aStack);
            }
        }
        if (scaleOverflow) {
            tScale = Long.MAX_VALUE;
        }
        if (storedOverflow) {
            tStored = Long.MAX_VALUE;
        }
        return new long[]{tStored, tScale};
    }

    @Override
    public String[] getInfoData() {
        if (this.mMax == 0L || this.count > 20L) {
            long[] tmp = this.getStoredEnergy();
            this.mStored = tmp[0];
            this.mMax = tmp[1];
            this.count = 0L;
        }
        return new String[]{EnumChatFormatting.BLUE + this.getLocalName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mStored) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMax) + EnumChatFormatting.RESET + " EU", "Average input:", GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getAverageElectricInput()) + " EU/t", "Average output:", GT_Utility.formatNumbers(this.getBaseMetaTileEntity().getAverageElectricOutput()) + " EU/t"};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }
}

