/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GT_MetaTileEntity_BasicGenerator
extends GT_MetaTileEntity_BasicTank {
    public GT_MetaTileEntity_BasicGenerator(int aID, String aName, String aNameRegional, int aTier, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide(aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "Fuel Efficiency: " + this.getEfficiency() + "%";
        return desc;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    @Override
    public boolean isFacingValid(byte aSide) {
        return aSide > 1;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 2;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? GT_Values.V[this.mTier] : 0L;
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 40L + this.getMinimumStoredEU());
    }

    @Override
    public boolean doesFillContainers() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean doesEmptyContainers() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean canTankBeFilled() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean canTankBeEmptied() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFuelValue(aFluid) > 0;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            long tFuelValue;
            if (this.mFluid == null) {
                if (aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + this.getMinimumStoredEU()) {
                    this.mInventory[this.getStackDisplaySlot()] = null;
                } else {
                    if (this.mInventory[this.getStackDisplaySlot()] == null) {
                        this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.fire, 1);
                    }
                    this.mInventory[this.getStackDisplaySlot()].setStackDisplayName("Draining internal buffer: " + (aBaseMetaTileEntity.getUniversalEnergyStored() - this.getMinimumStoredEU()) + " EU");
                }
            } else {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                long tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0L && tConsumed > 0L && (long)this.mFluid.amount >= tConsumed && (tFluidAmountToUse = Math.min((long)this.mFluid.amount / tConsumed, (this.maxEUStore() - aBaseMetaTileEntity.getUniversalEnergyStored()) / tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * tFuelValue, true)) {
                    GT_Pollution.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollution());
                    this.mFluid.amount = (int)((long)this.mFluid.amount - tFluidAmountToUse * tConsumed);
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && (GT_Utility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true) != null || this.solidFuelOverride(this.mInventory[this.getInputSlot()])) && (tFuelValue = (long)this.getFuelValue(this.mInventory[this.getInputSlot()])) > 0L) {
                ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                    aBaseMetaTileEntity.increaseStoredEnergyUnits(tFuelValue, true);
                    aBaseMetaTileEntity.decrStackSize(this.getInputSlot(), 1);
                    GT_Pollution.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollution());
                }
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public boolean solidFuelOverride(ItemStack stack) {
        ItemData association = GT_OreDictUnificator.getAssociation(stack);
        return association != null ? !(OrePrefixes.cell.equals((Object)association.mPrefix) || OrePrefixes.cellMolten.equals((Object)association.mPrefix) || OrePrefixes.cellPlasma.equals((Object)association.mPrefix) || GT_Utility.areStacksEqual(ItemList.VOLUMETRIC_FLASK.get(1L, new Object[0]), stack, true)) : stack != null && stack.getItem() != null && !(stack.getItem() instanceof IFluidContainerItem) && !(stack.getItem() instanceof IFluidHandler) && !stack.getItem().getUnlocalizedName().contains("bucket");
    }

    public abstract int getPollution();

    public abstract GT_Recipe.GT_Recipe_Map getRecipes();

    public abstract int getEfficiency();

    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return 1;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || this.getRecipes() == null) {
            return 0;
        }
        Collection<GT_Recipe> tRecipeList = this.getRecipes().mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tLiquid = GT_Utility.getFluidForFilledItem(tFuel.getRepresentativeInput(0), true);
                if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                long val = (long)tFuel.mSpecialValue * (long)this.getEfficiency() * (long)this.consumedFluidPerOperation(tLiquid) / 100L;
                if (val > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Integer LOOPBACK!");
                }
                return (int)val;
            }
        }
        return 0;
    }

    public int getFuelValue(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack) || this.getRecipes() == null) {
            return 0;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, aStack);
        if (tFuel != null) {
            long val = (long)tFuel.mSpecialValue * 10L * (long)this.getEfficiency();
            if (val > Integer.MAX_VALUE) {
                throw new ArithmeticException("Integer LOOPBACK!");
            }
            return (int)val;
        }
        return 0;
    }

    public ItemStack getEmptyContainer(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack) || this.getRecipes() == null) {
            return null;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, aStack);
        if (tFuel != null) {
            return GT_Utility.copy(tFuel.getOutput(0));
        }
        return GT_Utility.getContainerItem(aStack, true);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && (this.getFuelValue(aStack) > 0 || this.getFuelValue(GT_Utility.getFluidForFilledItem(aStack, true)) > 0);
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    @Override
    public int getTankPressure() {
        return -100;
    }
}

