/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_2by2;
import gregtech.api.gui.GT_Container_MaintenanceHatch;
import gregtech.api.gui.GT_GUIContainer_2by2;
import gregtech.api.gui.GT_GUIContainer_MaintenanceHatch;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_Hatch_Maintenance
extends GT_MetaTileEntity_Hatch {
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mAuto;

    public GT_MetaTileEntity_Hatch_Maintenance(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "For maintaining Multiblocks", new ITexture[0]);
        this.mAuto = false;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(int aID, String aName, String aNameRegional, int aTier, boolean aAuto) {
        super(aID, aName, aNameRegional, aTier, 4, "For automatically maintaining Multiblocks", new ITexture[0]);
        this.mAuto = aAuto;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(String aName, int aTier, String aDescription, ITexture[][][] aTextures, boolean aAuto) {
        super(aName, aTier, aAuto ? 4 : 1, aDescription, aTextures);
        this.mAuto = aAuto;
    }

    public GT_MetaTileEntity_Hatch_Maintenance(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, boolean aAuto) {
        super(aName, aTier, aAuto ? 4 : 1, aDescription, aTextures);
        this.mAuto = aAuto;
    }

    @Override
    public String[] getDescription() {
        if (this.mAuto) {
            String[] desc = new String[this.mDescriptionArray.length + 3];
            System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
            desc[this.mDescriptionArray.length] = "4 Ducttape, 2 Lubricant Cells";
            desc[this.mDescriptionArray.length + 1] = "4 Steel Screws, 2 Adv Circuits";
            desc[this.mDescriptionArray.length + 2] = "For each autorepair";
            return desc;
        }
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "Cannot be shared between Multiblocks!";
        return desc;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_IDLE_GLOW).glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MAINTENANCE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        if (this.mAuto) {
            return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_AUTOMAINTENANCE_GLOW).glow().build()};
        }
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_MAINTENANCE), TextureFactory.of(Textures.BlockIcons.OVERLAY_DUCTTAPE)};
    }

    @Override
    public void initDefaultModes(NBTTagCompound aNBT) {
        this.getBaseMetaTileEntity().setActive(true);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity.getMetaTileID() == 111) {
            return new GT_MetaTileEntity_Hatch_Maintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, true);
        }
        return new GT_MetaTileEntity_Hatch_Maintenance(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, false);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
            aBaseMetaTileEntity.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mAuto) {
            return new GT_Container_2by2(aPlayerInventory, aBaseMetaTileEntity);
        }
        return new GT_Container_MaintenanceHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mAuto) {
            return new GT_GUIContainer_2by2(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
        }
        return new GT_GUIContainer_MaintenanceHatch(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].stackSize > 0) continue;
            this.mInventory[i] = null;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mAuto && aTick % 100L == 0L) {
            aBaseMetaTileEntity.setActive(!this.isRecipeInputEqual(false));
        }
    }

    public boolean autoMaintainance() {
        return this.isRecipeInputEqual(true);
    }

    public boolean isRecipeInputEqual(boolean aDecreaseStacksizeBySuccess) {
        int amt;
        ItemStack[] mInputs;
        for (ItemStack tStack : mInputs = new ItemStack[]{ItemList.Duct_Tape.get(4L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.cell, Materials.Lubricant, 2L), GT_OreDictUnificator.get(OrePrefixes.screw, Materials.Steel, 4L), GT_OreDictUnificator.get(OrePrefixes.circuit, Materials.Advanced, 2L)}) {
            if (tStack == null) continue;
            amt = tStack.stackSize;
            boolean temp = true;
            ItemStack[] itemStackArray = this.mInventory;
            int n = itemStackArray.length;
            for (int i = 0; i < n; ++i) {
                ItemStack aStack = itemStackArray[i];
                if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true) || (amt -= aStack.stackSize) >= 1) continue;
                temp = false;
                break;
            }
            if (!temp) continue;
            return false;
        }
        if (aDecreaseStacksizeBySuccess) {
            block2: for (ItemStack tStack : mInputs) {
                if (tStack == null) continue;
                amt = tStack.stackSize;
                for (ItemStack aStack : this.mInventory) {
                    if (!GT_Utility.areUnificationsEqual(aStack, tStack, true) && !GT_Utility.areUnificationsEqual(GT_OreDictUnificator.get(false, aStack), tStack, true)) continue;
                    if (aStack.stackSize < amt) {
                        amt -= aStack.stackSize;
                        aStack.stackSize = 0;
                        continue;
                    }
                    aStack.stackSize -= amt;
                    amt = 0;
                    continue block2;
                }
            }
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mScrewdriver = true;
            this.mSoftHammer = true;
            this.mSolderingTool = true;
            this.mWrench = true;
            this.updateSlots();
        }
        return true;
    }

    public void onToolClick(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aStack == null || aPlayer == null) {
            return;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sWrenchList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mWrench = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sScrewdriverList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mScrewdriver = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSoftHammerList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mSoftHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sHardHammerList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mHardHammer = true;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sCrowbarList) && GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer)) {
            this.mCrowbar = true;
        }
        if (GT_ModHandler.useSolderingIron(aStack, aPlayer)) {
            this.mSolderingTool = true;
        }
        if (GT_OreDictUnificator.isItemStackInstanceOf(aStack, "craftingDuctTape")) {
            this.mSolderingTool = true;
            this.mCrowbar = true;
            this.mHardHammer = true;
            this.mSoftHammer = true;
            this.mScrewdriver = true;
            this.mWrench = true;
            this.getBaseMetaTileEntity().setActive(false);
            --aStack.stackSize;
        }
        if (this.mSolderingTool && aPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP tPlayer = (EntityPlayerMP)aPlayer;
            try {
                GT_Mod.achievements.issueAchievement((EntityPlayer)tPlayer, "maintainance");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return this.mAuto && GT_Mod.gregtechproxy.mAMHInteraction;
    }
}

