/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IChunkLoader;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class GT_ChunkManager
implements ForgeChunkManager.OrderedLoadingCallback,
ForgeChunkManager.PlayerOrderedLoadingCallback {
    private Map<TileEntity, ForgeChunkManager.Ticket> registeredTickets = new HashMap<TileEntity, ForgeChunkManager.Ticket>();
    public static GT_ChunkManager instance = new GT_ChunkManager();

    public static void init() {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)GT_Mod.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
    }

    public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
        ArrayList<ForgeChunkManager.Ticket> validTickets = new ArrayList<ForgeChunkManager.Ticket>();
        if (GT_Values.alwaysReloadChunkloaders) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                TileEntity tile;
                int x = ticket.getModData().getInteger("OwnerX");
                int y = ticket.getModData().getInteger("OwnerY");
                int z = ticket.getModData().getInteger("OwnerZ");
                if (y <= 0 || (tile = world.getTileEntity(x, y, z)) == null || !(tile instanceof IGregTechTileEntity) || !((IGregTechTileEntity)tile).isAllowedToWork()) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
                if (this.registeredTickets.containsKey(tile)) continue;
                this.registeredTickets.put(tile, ticket);
                if (((IGregTechTileEntity)tile).getMetaTileEntity() instanceof IChunkLoader) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)((IChunkLoader)((Object)((IGregTechTileEntity)tile).getMetaTileEntity())).getActiveChunk());
                }
                validTickets.add(ticket);
            }
        }
        return validTickets;
    }

    public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
        return ArrayListMultimap.create();
    }

    public static boolean requestPlayerChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ, String player) {
        if (!GT_Values.enableChunkloaders) {
            return false;
        }
        if (!GT_Values.alwaysReloadChunkloaders && chunkXZ == null) {
            return false;
        }
        if (GT_Values.debugChunkloaders && chunkXZ != null) {
            GT_Log.out.println("GT_ChunkManager: Chunk request: (" + chunkXZ.chunkXPos + ", " + chunkXZ.chunkZPos + ")");
        }
        if (GT_ChunkManager.instance.registeredTickets.containsKey(owner)) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)GT_ChunkManager.instance.registeredTickets.get(owner), (ChunkCoordIntPair)chunkXZ);
        } else {
            ForgeChunkManager.Ticket ticket = null;
            ticket = player != "" ? ForgeChunkManager.requestPlayerTicket((Object)GT_Mod.instance, (String)player, (World)owner.getWorldObj(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL) : ForgeChunkManager.requestTicket((Object)GT_Mod.instance, (World)owner.getWorldObj(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                if (GT_Values.debugChunkloaders) {
                    GT_Log.out.println("GT_ChunkManager: ForgeChunkManager.requestTicket failed");
                }
                return false;
            }
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket issued for machine at: (" + owner.xCoord + ", " + owner.yCoord + ", " + owner.zCoord + ")");
            }
            NBTTagCompound tag = ticket.getModData();
            tag.setInteger("OwnerX", owner.xCoord);
            tag.setInteger("OwnerY", owner.yCoord);
            tag.setInteger("OwnerZ", owner.zCoord);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
            if (GT_Values.alwaysReloadChunkloaders) {
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(owner.xCoord >> 4, owner.zCoord >> 4));
            }
            GT_ChunkManager.instance.registeredTickets.put(owner, ticket);
        }
        return true;
    }

    public static boolean requestChunkLoad(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        return GT_ChunkManager.requestPlayerChunkLoad(owner, chunkXZ, "");
    }

    public static void releaseChunk(TileEntity owner, ChunkCoordIntPair chunkXZ) {
        if (!GT_Values.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GT_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunkXZ.chunkXPos + ", " + chunkXZ.chunkZPos + ")");
            }
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunkXZ);
        }
    }

    public static void releaseTicket(TileEntity owner) {
        if (!GT_Values.enableChunkloaders) {
            return;
        }
        ForgeChunkManager.Ticket ticket = GT_ChunkManager.instance.registeredTickets.get(owner);
        if (ticket != null) {
            if (GT_Values.debugChunkloaders) {
                GT_Log.out.println("GT_ChunkManager: ticket released by machine at: (" + owner.xCoord + ", " + owner.yCoord + ", " + owner.zCoord + ")");
                for (ChunkCoordIntPair chunk : ticket.getChunkList()) {
                    GT_Log.out.println("GT_ChunkManager: Chunk release: (" + chunk.chunkXPos + ", " + chunk.chunkZPos + ")");
                }
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            GT_ChunkManager.instance.registeredTickets.remove(owner);
        }
    }

    public static void printTickets() {
        GT_Log.out.println("GT_ChunkManager: Start forced chunks dump:");
        GT_ChunkManager.instance.registeredTickets.forEach((machine, ticket) -> {
            GT_Log.out.print("GT_ChunkManager: Chunks forced by the machine at (" + machine.xCoord + ", " + machine.yCoord + ", " + machine.zCoord + ")");
            if (ticket.isPlayerTicket()) {
                GT_Log.out.print(" Owner: " + ticket.getPlayerName());
            }
            GT_Log.out.print(" :");
            for (ChunkCoordIntPair c : ticket.getChunkList()) {
                GT_Log.out.print("(");
                GT_Log.out.print(c.chunkXPos);
                GT_Log.out.print(", ");
                GT_Log.out.print(c.chunkZPos);
                GT_Log.out.print("), ");
            }
        });
        GT_Log.out.println("GT_ChunkManager: End forced chunks dump:");
    }
}

