/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.interfaces.internal.IGT_CraftingRecipe;
import gregtech.api.objects.ReverseShapelessRecipe;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GT_Shapeless_Recipe
extends ShapelessOreRecipe
implements IGT_CraftingRecipe {
    public final boolean mRemovableByGT;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public GT_Shapeless_Recipe(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        if (aDismantleAble) {
            new ReverseShapelessRecipe(aResult, aRecipe);
        }
    }

    public boolean matches(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            for (int i = 0; i < aGrid.getSizeInventory(); ++i) {
                if (aGrid.getStackInSlot(i) == null) continue;
                if (tStack != null && (tStack.hasTagCompound() != aGrid.getStackInSlot(i).hasTagCompound() || tStack.hasTagCompound() && !tStack.getTagCompound().equals((Object)aGrid.getStackInSlot(i).getTagCompound()))) {
                    return false;
                }
                tStack = aGrid.getStackInSlot(i);
            }
        }
        return super.matches(aGrid, aWorld);
    }

    public ItemStack getCraftingResult(InventoryCrafting aGrid) {
        ItemStack rStack = super.getCraftingResult(aGrid);
        if (rStack != null) {
            int i;
            GT_Utility.updateItemStack(rStack);
            if (this.mKeepingNBT) {
                for (i = 0; i < aGrid.getSizeInventory(); ++i) {
                    if (aGrid.getStackInSlot(i) == null || !aGrid.getStackInSlot(i).hasTagCompound()) continue;
                    rStack.setTagCompound((NBTTagCompound)aGrid.getStackInSlot(i).getTagCompound().copy());
                    break;
                }
            }
            if (GT_ModHandler.isElectricItem(rStack)) {
                GT_ModHandler.dischargeElectricItem(rStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, false, true);
                int tCharge = 0;
                for (int i2 = 0; i2 < aGrid.getSizeInventory(); ++i2) {
                    tCharge += GT_ModHandler.dischargeElectricItem(aGrid.getStackInSlot(i2), Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
                }
                if (tCharge > 0) {
                    GT_ModHandler.chargeElectricItem(rStack, tCharge, Integer.MAX_VALUE, true, false);
                }
            }
            for (i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                GT_Utility.ItemNBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], EnchantmentHelper.getEnchantmentLevel((int)this.mEnchantmentsAdded[i].effectId, (ItemStack)rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            GT_Utility.updateItemStack(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovable() {
        return this.mRemovableByGT;
    }
}

