/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.net.GT_Packet;
import gregtech.api.net.GT_Packet_Block_Event;
import gregtech.api.net.GT_Packet_Pollution;
import gregtech.api.net.GT_Packet_Sound;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.net.GT_Packet_TileEntityCover;
import gregtech.api.net.GT_Packet_TileEntityCoverGUI;
import gregtech.api.net.IGT_NetworkHandler;
import gregtech.common.blocks.GT_Packet_Ores;
import gregtech.common.net.MessageSetFlaskCapacity;
import gregtech.common.net.MessageUpdateFluidDisplayItem;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@ChannelHandler.Sharable
public class GT_Network
extends MessageToMessageCodec<FMLProxyPacket, GT_Packet>
implements IGT_NetworkHandler {
    private final EnumMap<Side, FMLEmbeddedChannel> mChannel = NetworkRegistry.INSTANCE.newChannel("GregTech", new ChannelHandler[]{this, new HandlerShared()});
    private final GT_Packet[] mSubChannels = new GT_Packet[]{new GT_Packet_TileEntity(), new GT_Packet_Sound(), new GT_Packet_Block_Event(), new GT_Packet_Ores(), new GT_Packet_Pollution(), new MessageSetFlaskCapacity(), new GT_Packet_TileEntityCover(), new GT_Packet_TileEntityCoverGUI(), new MessageUpdateFluidDisplayItem()};

    protected void encode(ChannelHandlerContext aContext, GT_Packet aPacket, List<Object> aOutput) throws Exception {
        ByteBuf tBuf = Unpooled.buffer().writeByte((int)aPacket.getPacketID());
        aPacket.encode(tBuf);
        aOutput.add(new FMLProxyPacket(tBuf, (String)aContext.channel().attr(NetworkRegistry.FML_CHANNEL).get()));
    }

    protected void decode(ChannelHandlerContext aContext, FMLProxyPacket aPacket, List<Object> aOutput) throws Exception {
        ByteArrayDataInput aData = ByteStreams.newDataInput((byte[])aPacket.payload().array());
        aOutput.add(this.mSubChannels[aData.readByte()].decode(aData));
    }

    @Override
    public void sendToPlayer(GT_Packet aPacket, EntityPlayerMP aPlayer) {
        if (aPacket == null) {
            GT_Mod.GT_FML_LOGGER.info("packet null");
            return;
        }
        if (aPlayer == null) {
            GT_Mod.GT_FML_LOGGER.info("player null");
            return;
        }
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPlayer);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToAllAround(GT_Packet aPacket, NetworkRegistry.TargetPoint aPosition) {
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.mChannel.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)aPosition);
        this.mChannel.get(Side.SERVER).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendToServer(GT_Packet aPacket) {
        this.mChannel.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.mChannel.get(Side.CLIENT).writeAndFlush((Object)aPacket);
    }

    @Override
    public void sendPacketToAllPlayersInRange(World aWorld, GT_Packet aPacket, int aX, int aZ) {
        if (!aWorld.isRemote) {
            for (Object tObject : aWorld.playerEntities) {
                if (!(tObject instanceof EntityPlayerMP)) break;
                EntityPlayerMP tPlayer = (EntityPlayerMP)tObject;
                Chunk tChunk = aWorld.getChunkFromBlockCoords(aX, aZ);
                if (!tPlayer.getServerForPlayer().getPlayerManager().isPlayerWatchingChunk(tPlayer, tChunk.xPosition, tChunk.zPosition)) continue;
                this.sendToPlayer(aPacket, tPlayer);
            }
        }
    }

    @ChannelHandler.Sharable
    static final class HandlerShared
    extends SimpleChannelInboundHandler<GT_Packet> {
        HandlerShared() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, GT_Packet aPacket) {
            EntityPlayer aPlayer = GT_Values.GT.getThePlayer();
            aPacket.process((IBlockAccess)(aPlayer == null ? null : GT_Values.GT.getThePlayer().worldObj));
        }
    }
}

