/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_None;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class Behaviour_Sonictron
extends Behaviour_None {
    public static final IItemBehaviour<GT_MetaBase_Item> INSTANCE = new Behaviour_Sonictron();

    public static int getCurrentIndex(ItemStack aStack) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = new NBTTagCompound();
        }
        return tNBTTagCompound.getInteger("mCurrentIndex");
    }

    public static int getTickTimer(ItemStack aStack) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = new NBTTagCompound();
        }
        return tNBTTagCompound.getInteger("mTickTimer");
    }

    public static NBTTagCompound setCurrentIndex(ItemStack aStack, int aIndex) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = new NBTTagCompound();
        }
        tNBTTagCompound.setInteger("mCurrentIndex", aIndex);
        return tNBTTagCompound;
    }

    public static NBTTagCompound setTickTimer(ItemStack aStack, int aTime) {
        NBTTagCompound tNBTTagCompound = aStack.getTagCompound();
        if (tNBTTagCompound == null) {
            tNBTTagCompound = new NBTTagCompound();
        }
        tNBTTagCompound.setInteger("mTickTimer", aTime);
        return tNBTTagCompound;
    }

    public static ItemStack[] getNBTInventory(ItemStack aStack) {
        ItemStack[] tInventory = new ItemStack[64];
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            return tInventory;
        }
        NBTTagList tNBT_ItemList = tNBT.getTagList("Inventory", 10);
        for (int i = 0; i < tNBT_ItemList.tagCount(); ++i) {
            NBTTagCompound tag = tNBT_ItemList.getCompoundTagAt(i);
            byte slot = tag.getByte("Slot");
            if (slot < 0 || slot >= tInventory.length) continue;
            tInventory[slot] = GT_Utility.loadItem(tag);
        }
        return tInventory;
    }

    public static NBTTagCompound setNBTInventory(ItemStack aStack, ItemStack[] aInventory) {
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        NBTTagList tNBT_ItemList = new NBTTagList();
        for (int i = 0; i < aInventory.length; ++i) {
            ItemStack stack = aInventory[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.setByte("Slot", (byte)i);
            stack.writeToNBT(tag);
            tNBT_ItemList.appendTag((NBTBase)tag);
        }
        tNBT.setTag("Inventory", (NBTBase)tNBT_ItemList);
        aStack.setTagCompound(tNBT);
        return tNBT;
    }

    public static void copyInventory(ItemStack[] aInventory, ItemStack[] aNewContent, int aIndexlength) {
        for (int i = 0; i < aIndexlength; ++i) {
            aInventory[i] = aNewContent[i] == null ? null : GT_Utility.copy(aNewContent[i]);
        }
    }

    @Override
    public boolean onItemUseFirst(GT_MetaBase_Item aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ) {
        Behaviour_Sonictron.setCurrentIndex(aStack, -1);
        return false;
    }

    @Override
    public ItemStack onItemRightClick(GT_MetaBase_Item aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        Behaviour_Sonictron.setCurrentIndex(aStack, 0);
        return aStack;
    }

    @Override
    public void onUpdate(GT_MetaBase_Item aItem, ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        int tTickTimer = Behaviour_Sonictron.getTickTimer(aStack);
        int tCurrentIndex = Behaviour_Sonictron.getCurrentIndex(aStack);
        if (tTickTimer++ % 2 == 0 && tCurrentIndex > -1) {
            ItemStack[] tInventory = Behaviour_Sonictron.getNBTInventory(aStack);
            GT_Values.GT.doSonictronSound(tInventory[tCurrentIndex], aPlayer.worldObj, aPlayer.posX, aPlayer.posY, aPlayer.posZ);
            if (++tCurrentIndex > 63) {
                tCurrentIndex = -1;
            }
        }
        Behaviour_Sonictron.setTickTimer(aStack, tTickTimer);
        Behaviour_Sonictron.setCurrentIndex(aStack, tCurrentIndex);
    }
}

