/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import java.util.Collection;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class GT_CapeRenderer
extends RenderPlayer {
    private final ResourceLocation[] mCapes = new ResourceLocation[]{new ResourceLocation("gregtech:textures/BrainTechCape.png"), new ResourceLocation("gregtech:textures/GregTechCape.png"), new ResourceLocation("gregtech:textures/MrBrainCape.png"), new ResourceLocation("gregtech:textures/GregoriusCape.png"), new ResourceLocation("gregtech:textures/DonorCape.png"), new ResourceLocation("gregtech:textures/DevCape.png"), new ResourceLocation("gregtech:textures/TecCape.png")};
    private final Collection<String> mCapeList;

    public GT_CapeRenderer(Collection<String> aCapeList) {
        this.mCapeList = aCapeList;
        this.setRenderManager(RenderManager.instance);
    }

    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        block17: {
            AbstractClientPlayer aPlayer = (AbstractClientPlayer)aEvent.entityPlayer;
            if (GT_Utility.getFullInvisibility((EntityPlayer)aPlayer)) {
                aEvent.setCanceled(true);
                return;
            }
            float aPartialTicks = aEvent.partialRenderTick;
            if (aPlayer.isInvisible()) {
                return;
            }
            if (GT_Utility.getPotion((EntityLivingBase)aPlayer, Potion.invisibility.id)) {
                return;
            }
            try {
                ResourceLocation tResource = null;
                if (aPlayer.getDisplayName().equalsIgnoreCase("Friedi4321")) {
                    tResource = this.mCapes[0];
                }
                if (this.mCapeList.contains(aPlayer.getDisplayName().toLowerCase())) {
                    tResource = this.mCapes[1];
                }
                if (aPlayer.getDisplayName().equalsIgnoreCase("Mr_Brain")) {
                    tResource = this.mCapes[2];
                }
                if (aPlayer.getDisplayName().equalsIgnoreCase("GregoriusT")) {
                    tResource = this.mCapes[3];
                }
                if (this.mCapeList.contains(aPlayer.getDisplayName().toLowerCase() + ":capedonor")) {
                    tResource = this.mCapes[4];
                }
                if (this.mCapeList.contains(aPlayer.getDisplayName().toLowerCase() + ":capedev")) {
                    tResource = this.mCapes[5];
                }
                if (this.mCapeList.contains(aPlayer.getDisplayName().toLowerCase() + ":capetec")) {
                    tResource = this.mCapes[6];
                }
                if (tResource != null && !aPlayer.getHideCape()) {
                    this.bindTexture(tResource);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                    double d0 = aPlayer.field_71091_bM + (aPlayer.field_71094_bP - aPlayer.field_71091_bM) * (double)aPartialTicks - (aPlayer.prevPosX + (aPlayer.posX - aPlayer.prevPosX) * (double)aPartialTicks);
                    double d1 = aPlayer.field_71096_bN + (aPlayer.field_71095_bQ - aPlayer.field_71096_bN) * (double)aPartialTicks - (aPlayer.prevPosY + (aPlayer.posY - aPlayer.prevPosY) * (double)aPartialTicks);
                    double d2 = aPlayer.field_71097_bO + (aPlayer.field_71085_bR - aPlayer.field_71097_bO) * (double)aPartialTicks - (aPlayer.prevPosZ + (aPlayer.posZ - aPlayer.prevPosZ) * (double)aPartialTicks);
                    float f6 = aPlayer.prevRenderYawOffset + (aPlayer.renderYawOffset - aPlayer.prevRenderYawOffset) * aPartialTicks;
                    double d3 = MathHelper.sin((float)(f6 * 3.141593f / 180.0f));
                    double d4 = -MathHelper.cos((float)(f6 * 3.141593f / 180.0f));
                    float f7 = (float)d1 * 10.0f;
                    float f8 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                    float f9 = (float)(d0 * d4 - d2 * d3) * 100.0f;
                    if (f7 < -6.0f) {
                        f7 = -6.0f;
                    }
                    if (f7 > 32.0f) {
                        f7 = 32.0f;
                    }
                    if (f8 < 0.0f) {
                        f8 = 0.0f;
                    }
                    float f10 = aPlayer.prevCameraYaw + (aPlayer.cameraYaw - aPlayer.prevCameraYaw) * aPartialTicks;
                    f7 += MathHelper.sin((float)((aPlayer.prevDistanceWalkedModified + (aPlayer.distanceWalkedModified - aPlayer.prevDistanceWalkedModified) * aPartialTicks) * 6.0f)) * 32.0f * f10;
                    if (aPlayer.isSneaking()) {
                        f7 += 25.0f;
                    }
                    GL11.glRotatef((float)(6.0f + f8 / 2.0f + f7), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)(f9 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(-f9 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    ((ModelBiped)this.mainModel).renderCloak(0.0625f);
                    GL11.glPopMatrix();
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block17;
                e.printStackTrace(GT_Log.err);
            }
        }
    }
}

