/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.boilers;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_Boiler;
import gregtech.common.gui.GT_GUIContainer_Boiler;
import gregtech.common.tileentities.boilers.GT_MetaTileEntity_Boiler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Boiler_Solar
extends GT_MetaTileEntity_Boiler {
    public static final String LPS_FMT = "%s L/s";
    private static final String localizedDescFormat = GT_LanguageManager.addStringLocalization("gt.blockmachines.boiler.solar.desc.format", "Steam Power by the Sun%nProduces %sL of Steam per second%nCalcifies over time, reducing Steam output to %sL/s%nBreak and replace to descale");
    protected final Config mConfig;
    protected int basicTemperatureMod = 5;
    private int mRunTimeTicks = 0;

    public GT_MetaTileEntity_Boiler_Solar(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, new String[0], new ITexture[0]);
        this.mConfig = this.createConfig();
    }

    public GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.mConfig = this.createConfig();
    }

    public GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.mConfig = this.createConfig();
    }

    protected GT_MetaTileEntity_Boiler_Solar(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, Config aConfig) {
        super(aName, aTier, aDescription, aTextures);
        this.mConfig = aConfig;
    }

    protected Config createConfig() {
        return new Config((Object)((Object)ConfigCategories.machineconfig) + ".boiler.solar.bronze", 1080000, 40, 120, 45);
    }

    @Deprecated
    public int getBasicOutput() {
        return (int)((float)this.getMaxOutputPerSecond() * 1.25f);
    }

    public int getMaxOutputPerSecond() {
        return this.mConfig.getMaxOutputPerSecond();
    }

    @Deprecated
    public int getCalcificationOutput() {
        return (int)((float)this.getProductionPerSecond() * 1.25f);
    }

    @Override
    public String[] getDescription() {
        return String.format(localizedDescFormat, GT_Utility.formatNumbers(this.getMaxOutputPerSecond()), GT_Utility.formatNumbers(this.getMinOutputPerSecond())).split("\\R");
    }

    public int getMinOutputPerSecond() {
        return this.mConfig.getMinOutputPerSecond();
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[4][17][];
        for (int color = -1; color < 16; ++color) {
            int i = color + 1;
            short[] colorModulation = Dyes.getModulation(color, Dyes._NULL.mRGBa);
            rTextures[0][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_BOTTOM, colorModulation)};
            rTextures[1][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_TOP, colorModulation), TextureFactory.of(Textures.BlockIcons.BOILER_SOLAR)};
            rTextures[2][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, colorModulation)};
            rTextures[3][i] = new ITexture[]{TextureFactory.of(Textures.BlockIcons.MACHINE_BRONZEBRICKS_SIDE, colorModulation), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE)};
        }
        return rTextures;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_Boiler(aPlayerInventory, aBaseMetaTileEntity, this.getCapacity());
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_Boiler(aPlayerInventory, aBaseMetaTileEntity, "SolarBoiler.png", this.getCapacity());
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        int i = aColorIndex + 1;
        if (aSide >= 2) {
            if (aSide != aFacing) {
                return this.mTextures[2][i];
            }
            return this.mTextures[3][i];
        }
        return this.mTextures[aSide][i];
    }

    @Override
    public int maxProgresstime() {
        return 500;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.setInteger("mRunTime", this.mRunTimeTicks);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mRunTimeTicks = aNBT.getInteger("mRunTime");
    }

    @Override
    protected void produceSteam(int aAmount) {
        super.produceSteam(aAmount);
        this.mRunTimeTicks = this.mRunTimeTicks >= 0 && this.mRunTimeTicks < 0x7FFFFFF5 ? (this.mRunTimeTicks += 10) : Integer.MAX_VALUE;
    }

    @Override
    protected void pushSteamToInventories(IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.mSteam == null || this.mSteam.amount == 0) {
            return;
        }
        this.pushSteamToSide(aBaseMetaTileEntity, aBaseMetaTileEntity.getFrontFacing());
    }

    @Override
    protected int getPollution() {
        return 0;
    }

    @Override
    public int getProductionPerSecond() {
        if (this.mTemperature < 100) {
            return 0;
        }
        if (this.mRunTimeTicks > this.mConfig.getCalcificationTicks()) {
            return Math.max(this.mConfig.getMinOutputPerSecond(), this.mConfig.getMaxOutputPerSecond() - this.mConfig.getMaxOutputPerSecond() * (this.mRunTimeTicks - this.mConfig.getCalcificationTicks()) / this.mConfig.getCalcificationTicks());
        }
        return this.mConfig.getMaxOutputPerSecond();
    }

    @Override
    protected int getMaxTemperature() {
        return 500;
    }

    @Override
    protected int getEnergyConsumption() {
        return this.basicTemperatureMod;
    }

    @Override
    protected int getCooldownInterval() {
        return this.mConfig.getCoolDownTicks() / this.basicTemperatureMod;
    }

    @Override
    protected int getHeatUpAmount() {
        return this.basicTemperatureMod;
    }

    @Override
    protected void updateFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        boolean weatherClear;
        World world = aBaseMetaTileEntity.getWorld();
        if (aTick % 240L != 0L || world.isThundering()) {
            return;
        }
        if (!aBaseMetaTileEntity.getSkyAtSide((byte)ForgeDirection.UP.ordinal())) {
            return;
        }
        boolean bl = weatherClear = !world.isRaining() || aBaseMetaTileEntity.getBiome().rainfall == 0.0f;
        if (!weatherClear && world.skylightSubtracted >= 4) {
            return;
        }
        this.mProcessingEnergy = weatherClear ? (world.isDaytime() ? (this.mProcessingEnergy += 8 * this.basicTemperatureMod) : (this.mProcessingEnergy += this.basicTemperatureMod)) : (this.mProcessingEnergy += this.basicTemperatureMod);
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return String.format("Heat Capacity: " + EnumChatFormatting.GREEN + "%s %%" + EnumChatFormatting.RESET + "    Hot time: " + EnumChatFormatting.RED + "%s s" + EnumChatFormatting.RESET + "%nMin output: " + EnumChatFormatting.RED + LPS_FMT + EnumChatFormatting.RESET + "    Max output: " + EnumChatFormatting.RED + LPS_FMT + EnumChatFormatting.RESET + "%nCurrent Output: " + EnumChatFormatting.YELLOW + LPS_FMT + EnumChatFormatting.RESET, GT_Utility.formatNumbers(this.getHeatCapacityPercent()), GT_Utility.formatNumbers(this.getHotTimeSeconds()), GT_Utility.formatNumbers(this.getMinOutputPerSecond()), GT_Utility.formatNumbers(this.getMaxOutputPerSecond()), GT_Utility.formatNumbers(this.getProductionPerSecond())).split("\\R");
    }

    public int getHeatCapacityPercent() {
        return this.mTemperature * 100 / this.maxProgresstime();
    }

    public int getHotTimeSeconds() {
        return this.mRunTimeTicks / 20;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Boiler_Solar(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mConfig);
    }

    protected static class Config {
        private final int calcificationTicks;
        private final int minOutputPerSecond;
        private final int maxOutputPerSecond;
        private final int coolDownTicks;

        public Config(String aCategory, int aDefaultCalcificationTicks, int aDefaultMinOutputPerSecond, int aDefaultMaxOutputPerSecond, int aDefaultCoolDownTicks) {
            this.calcificationTicks = this.get(aCategory, "CalcificationTicks", aDefaultCalcificationTicks, "Number of run-time ticks before boiler starts calcification.", "100% calcification and minimal output will be reached at 2 times this.");
            this.minOutputPerSecond = this.get(aCategory, "MinOutputPerSecond", aDefaultMinOutputPerSecond, new String[0]);
            this.maxOutputPerSecond = this.get(aCategory, "MaxOutputPerSecond", aDefaultMaxOutputPerSecond, new String[0]);
            this.coolDownTicks = this.get(aCategory, "CoolDownTicks", aDefaultCoolDownTicks, "Number of ticks it takes to lose 1\u00b0C.");
        }

        protected int get(String aCategory, String aKey, int aDefaultValue, String ... aComments) {
            StringBuilder tCommentBuilder = new StringBuilder();
            for (String tComment : aComments) {
                tCommentBuilder.append(tComment).append('\n');
            }
            tCommentBuilder.append("Default: ").append(aDefaultValue);
            return GregTech_API.sMachineFile.mConfig.get(aCategory, aKey, aDefaultValue, tCommentBuilder.toString()).getInt();
        }

        public int getCalcificationTicks() {
            return this.calcificationTicks;
        }

        public int getMinOutputPerSecond() {
            return this.minOutputPerSecond;
        }

        public int getMaxOutputPerSecond() {
            return this.maxOutputPerSecond;
        }

        public int getCoolDownTicks() {
            return this.coolDownTicks;
        }
    }
}

