/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_GUIContainer_BasicTank;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Pump
extends GT_MetaTileEntity_Hatch {
    private static final ItemStack MINING_PIPE = GT_ModHandler.getIC2Item("miningPipe", 0L);
    private static final Block MINING_PIPE_BLOCK = GT_Utility.getBlockFromStack(MINING_PIPE);
    private static final Block MINING_PIPE_TIP_BLOCK = GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 0L));
    public ArrayDeque<ChunkPosition> mPumpList = new ArrayDeque();
    public boolean wasPumping = false;
    public int mPumpTimer = 0;
    public int mPumpCountBelow = 0;
    public Block mPrimaryPumpedBlock = null;
    public Block mSecondaryPumpedBlock = null;
    private int radiusConfig = GT_MetaTileEntity_Pump.getMaxDistanceForTier(this.mTier);
    private boolean mRetractDone = false;
    private FakePlayer mFakePlayer = null;

    public static int getMaxDistanceForTier(int aTier) {
        return 10 * (int)Math.pow(1.6, aTier);
    }

    public static long getEuUsagePerTier(int aTier) {
        return 16L * (long)Math.pow(4.0, aTier);
    }

    public GT_MetaTileEntity_Pump(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"The best way to empty Oceans! Outputs on top", GT_MetaTileEntity_Pump.getEuUsagePerTier(aTier) + " EU/operation, " + GT_Utility.safeInt(8L / (long)Math.pow(2.0, aTier)) + " sec per bucket, no stuttering", "Maximum pumping area: " + (GT_MetaTileEntity_Pump.getMaxDistanceForTier(aTier) * 2 + 1) + "x" + (GT_MetaTileEntity_Pump.getMaxDistanceForTier(aTier) * 2 + 1), "Use Screwdriver to regulate pumping area", "Disable itself upon hitting rocks", "Disable the bottom pump to retract the pipe!"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Pump(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        boolean wasPumping;
        boolean bl = wasPumping = this.wasPumping || !this.mPumpList.isEmpty();
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: NBT:Save - WasPumping - " + wasPumping + " blocks (" + this.mPrimaryPumpedBlock + ", " + this.mSecondaryPumpedBlock + ")");
        }
        super.saveNBTData(aNBT);
        aNBT.setString("mPumpedBlock1", this.mPrimaryPumpedBlock == null ? "" : Block.blockRegistry.getNameForObject((Object)this.mPrimaryPumpedBlock));
        aNBT.setString("mPumpedBlock2", this.mSecondaryPumpedBlock == null ? "" : Block.blockRegistry.getNameForObject((Object)this.mSecondaryPumpedBlock));
        aNBT.setBoolean("wasPumping", wasPumping);
        aNBT.setInteger("radiusConfig", this.radiusConfig);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.wasPumping = aNBT.getBoolean("wasPumping");
        if (aNBT.hasKey("radiusConfig")) {
            this.radiusConfig = aNBT.getInteger("radiusConfig");
        }
        this.mPrimaryPumpedBlock = Block.getBlockFromName((String)aNBT.getString("mPumpedBlock1"));
        this.mSecondaryPumpedBlock = Block.getBlockFromName((String)aNBT.getString("mPumpedBlock2"));
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: NBT:Load - WasPumping - " + this.wasPumping + "(" + aNBT.getString("mPumpedBlock1") + ") " + this.mPrimaryPumpedBlock);
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.setInteger("radiusConfig", this.radiusConfig);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        int max = this.getMaxPumpableDistance();
        if (aPlayer.isSneaking()) {
            if (this.radiusConfig >= 0) {
                --this.radiusConfig;
            }
            if (this.radiusConfig < 0) {
                this.radiusConfig = max;
            }
        } else {
            if (this.radiusConfig <= max) {
                ++this.radiusConfig;
            }
            if (this.radiusConfig > max) {
                this.radiusConfig = 0;
            }
        }
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.translateToLocal((String)"GT5U.machines.workareaset") + " " + (this.radiusConfig * 2 + 1) + "x" + (this.radiusConfig * 2 + 1));
        this.clearQueue(false);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicTank(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicTank(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            int tFilledAmount;
            FluidStack tDrained;
            IFluidHandler tTank;
            IGregTechTileEntity tTileEntity;
            --this.mPumpTimer;
            if (this.getBaseMetaTileEntity() instanceof BaseTileEntity) {
                ((BaseTileEntity)((Object)this.getBaseMetaTileEntity())).ignoreUnloadedChunks = false;
            }
            this.doTickProfilingInThisTick = true;
            this.mPumpCountBelow = 0;
            for (int i = 1; i < 21 && (tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance((byte)0, i)) != null && tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Pump; ++i) {
                this.getBaseMetaTileEntity().setActive(tTileEntity.isActive());
                ++this.mPumpCountBelow;
                --((GT_MetaTileEntity_Pump)tTileEntity.getMetaTileEntity()).mPumpTimer;
            }
            if (GT_Values.debugBlockPump && this.mPumpCountBelow != 0) {
                GT_Log.out.println("PUMP: Detected " + this.mPumpCountBelow + " pumps below this pump.");
            }
            if (this.mPumpCountBelow <= 0) {
                if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                    this.mRetractDone = false;
                    if (this.getBaseMetaTileEntity().isUniversalEnergyStored(this.getEuUsagePerAction()) && (this.mFluid == null || this.mFluid.amount + 1000 <= this.getCapacity())) {
                        boolean tMovedOneDown = false;
                        if (this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 100L == 0L) {
                            if (!this.wasPumping) {
                                tMovedOneDown = this.moveOneDown();
                                if (!tMovedOneDown) {
                                    if (this.canMoveDown(this.getBaseMetaTileEntity().getXCoord(), Math.max(this.getYOfPumpHead() - 1, 1), this.getBaseMetaTileEntity().getZCoord())) {
                                        if (GT_Values.debugBlockPump) {
                                            GT_Log.out.println("PUMP: No pipe left. Idle for a little longer.");
                                        }
                                        this.mPumpTimer = 160;
                                    } else {
                                        this.getBaseMetaTileEntity().disableWorking();
                                        if (GT_Values.debugBlockPump) {
                                            GT_Log.out.println("PUMP: Can't move. Retracting in next few ticks");
                                        }
                                    }
                                } else if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Moved down");
                                }
                            } else if (GT_Values.debugBlockPump) {
                                GT_Log.out.println("PUMP: Was pumping, didn't move down");
                            }
                        }
                        int x = this.getBaseMetaTileEntity().getXCoord();
                        int z = this.getBaseMetaTileEntity().getZCoord();
                        if (!this.hasValidFluid()) {
                            int y = this.getYOfPumpHead();
                            if (GT_Values.debugBlockPump && this.mPrimaryPumpedBlock != null) {
                                GT_Log.out.println("PUMP: Had an invalid pump block. Trying to find a fluid at Y: " + y + " Previous blocks 1: " + this.mPrimaryPumpedBlock + " 2: " + this.mSecondaryPumpedBlock);
                            }
                            this.checkForFluidToPump(x, y - 1, z);
                            this.checkForFluidToPump(x, y, z + 1);
                            this.checkForFluidToPump(x, y, z - 1);
                            this.checkForFluidToPump(x + 1, y, z);
                            this.checkForFluidToPump(x - 1, y, z);
                            this.clearQueue(false);
                            if (this.hasValidFluid()) {
                                this.wasPumping = true;
                            }
                        } else if (this.getYOfPumpHead() < this.getBaseMetaTileEntity().getYCoord()) {
                            if (tMovedOneDown || this.wasPumping || this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 200L == 100L || this.getBaseMetaTileEntity().getTimer() % 72000L == 100L) {
                                if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Rebuilding pump list - Size " + this.mPumpList.size() + " WasPumping: " + this.wasPumping + " Timer " + this.getBaseMetaTileEntity().getTimer());
                                }
                                int yPump = this.getBaseMetaTileEntity().getYCoord() - 1;
                                int yHead = this.getYOfPumpHead();
                                this.rebuildPumpQueue(x, yPump, z, yHead);
                                if (GT_Values.debugBlockPump) {
                                    GT_Log.out.println("PUMP: Rebuilt pump list - Size " + this.mPumpList.size());
                                }
                            }
                            if (!tMovedOneDown && this.mPumpTimer <= 0) {
                                while (!this.mPumpList.isEmpty()) {
                                    ChunkPosition pos = this.mPumpList.pollLast();
                                    if (!this.consumeFluid(pos.chunkPosX, pos.chunkPosY, pos.chunkPosZ)) continue;
                                    break;
                                }
                                this.mPumpTimer = GT_Utility.safeInt(160L / (long)Math.pow(2.0, this.mTier));
                                this.mPumpTimer = this.mPumpTimer == 0 ? 1 : this.mPumpTimer;
                            }
                        } else {
                            this.clearQueue(false);
                        }
                    } else if (GT_Values.debugBlockPump) {
                        GT_Log.out.println("PUMP: Not enough energy? Free space?");
                    }
                } else if (!this.mRetractDone && aTick % 5L == 0L && (this.mInventory[0] == null || this.mInventory[0].stackSize == 0 || GT_Utility.areStacksEqual(this.mInventory[0], MINING_PIPE) && this.mInventory[0].stackSize < this.mInventory[0].getMaxStackSize())) {
                    int tHeadY = this.getYOfPumpHead();
                    if (tHeadY < this.getBaseMetaTileEntity().getYCoord()) {
                        int tXCoord = this.getBaseMetaTileEntity().getXCoord();
                        int tZCoord = this.getBaseMetaTileEntity().getZCoord();
                        this.getBaseMetaTileEntity().getWorld().setBlockToAir(tXCoord, tHeadY, tZCoord);
                        if (tHeadY < this.getBaseMetaTileEntity().getYCoord() - 1) {
                            this.getBaseMetaTileEntity().getWorld().setBlock(tXCoord, tHeadY + 1, tZCoord, MINING_PIPE_TIP_BLOCK);
                        }
                        if (this.mInventory[0] == null) {
                            ItemStack copy = MINING_PIPE.copy();
                            copy.stackSize = 1;
                            this.setInventorySlotContents(0, copy);
                        } else {
                            ++this.mInventory[0].stackSize;
                        }
                        if (GT_Values.debugBlockPump) {
                            GT_Log.out.println("PUMP: Retracted one pipe");
                        }
                    } else {
                        this.mRetractDone = true;
                        if (GT_Values.debugBlockPump) {
                            GT_Log.out.println("PUMP: Retract done");
                        }
                    }
                }
                this.getBaseMetaTileEntity().setActive(!this.mPumpList.isEmpty());
            }
            if (this.mFluid != null && aTick % 20L == 0L && (tTank = aBaseMetaTileEntity.getITankContainerAtSide((byte)1)) != null && (tDrained = this.drain(1000, false)) != null && (tFilledAmount = tTank.fill(ForgeDirection.DOWN, tDrained, false)) > 0) {
                tTank.fill(ForgeDirection.DOWN, this.drain(tFilledAmount, true), true);
            }
        }
    }

    private int getMaxPumpableDistance() {
        return GT_MetaTileEntity_Pump.getMaxDistanceForTier(this.mTier);
    }

    private long getEuUsagePerAction() {
        return GT_MetaTileEntity_Pump.getEuUsagePerTier(this.mTier);
    }

    private boolean hasValidFluid() {
        return !GT_Utility.isBlockInvalid(this.mPrimaryPumpedBlock) && !GT_Utility.isBlockInvalid(this.mSecondaryPumpedBlock);
    }

    private boolean moveOneDown() {
        int z;
        if (this.mInventory[0] == null || this.mInventory[0].stackSize < 1 || !GT_Utility.areStacksEqual(this.mInventory[0], MINING_PIPE)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: No mining pipes");
            }
            return false;
        }
        int yHead = this.getYOfPumpHead();
        if (yHead <= 1) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: At bottom");
            }
            return false;
        }
        int x = this.getBaseMetaTileEntity().getXCoord();
        if (!this.consumeFluid(x, yHead - 1, z = this.getBaseMetaTileEntity().getZCoord()) && !this.getBaseMetaTileEntity().getBlock(x, yHead - 1, z).isAir((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), x, yHead - 1, z)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: Did not consume fluid, or non-airblock found");
            }
            return false;
        }
        if (!GT_Utility.setBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), x, yHead - 1, z, MINING_PIPE_TIP_BLOCK, 0, false)) {
            if (GT_Values.debugBlockPump) {
                GT_Log.out.println("PUMP: Could not set block below to new tip");
            }
            return false;
        }
        if (yHead != this.getBaseMetaTileEntity().getYCoord()) {
            this.getBaseMetaTileEntity().getWorld().setBlock(x, yHead, z, MINING_PIPE_BLOCK);
        }
        this.getBaseMetaTileEntity().decrStackSize(0, 1);
        if (GT_Values.debugBlockPump) {
            GT_Log.out.println("PUMP: Using 1 pipe");
        }
        return true;
    }

    private int getYOfPumpHead() {
        int y = this.getBaseMetaTileEntity().getYCoord() - 1;
        int x = this.getBaseMetaTileEntity().getXCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        while (y > 0) {
            Block curBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
            if (curBlock == MINING_PIPE_BLOCK) {
                --y;
                continue;
            }
            if (curBlock != MINING_PIPE_TIP_BLOCK) break;
            Block nextBlock = this.getBaseMetaTileEntity().getBlock(x, y - 1, z);
            if (nextBlock == MINING_PIPE_BLOCK || nextBlock == MINING_PIPE_TIP_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().setBlock(x, y, z, MINING_PIPE_BLOCK);
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Hit pipes already in place, trying to merge");
                }
            }
            --y;
        }
        if (this.getBaseMetaTileEntity().getBlock(x, y, z) != MINING_PIPE_TIP_BLOCK) {
            if (y != this.getBaseMetaTileEntity().getYCoord() - 1 && this.getBaseMetaTileEntity().getBlock(x, y + 1, z) == MINING_PIPE_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().setBlock(x, y + 1, z, MINING_PIPE_TIP_BLOCK);
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Did not find a tip at bottom, setting last pipe as tip");
                }
            }
            return y + 1;
        }
        return y;
    }

    private void clearQueue(boolean checkPumping) {
        this.wasPumping = checkPumping ? !this.mPumpList.isEmpty() : false;
        this.mPumpList.clear();
    }

    private void rebuildPumpQueue(int aX, int yStart, int aZ, int yEnd) {
        int mDist = this.radiusConfig;
        this.doTickProfilingInThisTick = false;
        ArrayDeque<ChunkPosition> fluidsToSearch = new ArrayDeque<ChunkPosition>();
        ArrayDeque<ChunkPosition> fluidsFound = new ArrayDeque<ChunkPosition>();
        HashSet<ChunkPosition> checked = new HashSet<ChunkPosition>();
        this.clearQueue(false);
        for (int aY = yStart; this.mPumpList.isEmpty() && aY >= yEnd; --aY) {
            fluidsToSearch.add(new ChunkPosition(aX, aY, aZ));
            while (!fluidsToSearch.isEmpty()) {
                for (ChunkPosition tPos : fluidsToSearch) {
                    if (tPos.chunkPosX < aX + mDist) {
                        this.queueFluid(tPos.chunkPosX + 1, tPos.chunkPosY, tPos.chunkPosZ, fluidsFound, checked);
                    }
                    if (tPos.chunkPosX > aX - mDist) {
                        this.queueFluid(tPos.chunkPosX - 1, tPos.chunkPosY, tPos.chunkPosZ, fluidsFound, checked);
                    }
                    if (tPos.chunkPosZ < aZ + mDist) {
                        this.queueFluid(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ + 1, fluidsFound, checked);
                    }
                    if (tPos.chunkPosZ > aZ - mDist) {
                        this.queueFluid(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ - 1, fluidsFound, checked);
                    }
                    this.queueFluid(tPos.chunkPosX, tPos.chunkPosY + 1, tPos.chunkPosZ, this.mPumpList, checked);
                }
                this.mPumpList.addAll(fluidsFound);
                fluidsToSearch = fluidsFound;
                fluidsFound = new ArrayDeque();
            }
            this.mPumpList.remove(new ChunkPosition(aX, aY, aZ));
        }
    }

    private boolean queueFluid(int aX, int aY, int aZ, ArrayDeque<ChunkPosition> fluidsFound, Set<ChunkPosition> checked) {
        Block aBlock;
        ChunkPosition tCoordinate = new ChunkPosition(aX, aY, aZ);
        if (checked.add(tCoordinate) && !fluidsFound.contains(tCoordinate) && (this.mPrimaryPumpedBlock == (aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ)) || this.mSecondaryPumpedBlock == aBlock)) {
            fluidsFound.addFirst(tCoordinate);
            return true;
        }
        return false;
    }

    private void checkForFluidToPump(int aX, int aY, int aZ) {
        if (this.hasValidFluid()) {
            return;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (GT_Utility.isBlockValid(aBlock)) {
            if (aBlock == Blocks.water || aBlock == Blocks.flowing_water) {
                this.mPrimaryPumpedBlock = Blocks.water;
                this.mSecondaryPumpedBlock = Blocks.flowing_water;
                return;
            }
            if (aBlock == Blocks.lava || aBlock == Blocks.flowing_lava) {
                this.mPrimaryPumpedBlock = Blocks.lava;
                this.mSecondaryPumpedBlock = Blocks.flowing_lava;
                return;
            }
            if (aBlock instanceof IFluidBlock) {
                this.mPrimaryPumpedBlock = aBlock;
                this.mSecondaryPumpedBlock = aBlock;
                return;
            }
        }
        this.mPrimaryPumpedBlock = null;
        this.mSecondaryPumpedBlock = null;
    }

    private boolean canMoveDown(int aX, int aY, int aZ) {
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        return GT_Utility.isBlockValid(aBlock) && (aBlock == Blocks.water || aBlock == Blocks.flowing_water || aBlock == Blocks.lava || aBlock == Blocks.flowing_lava || aBlock instanceof IFluidBlock || aBlock.isAir((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ));
    }

    private boolean consumeFluid(int aX, int aY, int aZ) {
        if (!GT_Utility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (GT_Utility.isBlockValid(aBlock) && (this.mPrimaryPumpedBlock == aBlock || this.mSecondaryPumpedBlock == aBlock)) {
            boolean isWaterOrLava;
            boolean bl = isWaterOrLava = this.mPrimaryPumpedBlock == Blocks.water || this.mPrimaryPumpedBlock == Blocks.lava;
            if (isWaterOrLava && this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ) != 0) {
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Water/Lava - Not a source block");
                }
            } else if (this.mFluid == null) {
                this.mFluid = this.mPrimaryPumpedBlock == Blocks.water ? GT_ModHandler.getWater(1000L) : (this.mPrimaryPumpedBlock == Blocks.lava ? GT_ModHandler.getLava(1000L) : ((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, true));
            } else if (GT_ModHandler.isWater(this.mFluid) || GT_ModHandler.isLava(this.mFluid) || this.mFluid.isFluidEqual(((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, false))) {
                if (!isWaterOrLava) {
                    this.getBaseMetaTileEntity().getWorld().setBlockToAir(aX, aY, aZ);
                }
                this.mFluid.amount += 1000;
            } else {
                if (GT_Values.debugBlockPump) {
                    GT_Log.out.println("PUMP: Couldn't consume " + aBlock);
                }
                return false;
            }
            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.getEuUsagePerAction(), true);
            this.getBaseMetaTileEntity().getWorld().setBlock(aX, aY, aZ, Blocks.air, 0, 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        aList.addAll(Arrays.asList(EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.machines.blocks"), "Primary pumping fluid:   " + (this.mPrimaryPumpedBlock != null ? this.mPrimaryPumpedBlock.getLocalizedName() : "None"), "Secondary pumping fluid: " + (this.mSecondaryPumpedBlock != null ? this.mSecondaryPumpedBlock.getLocalizedName() : "None"), "Pumps below: " + this.mPumpCountBelow, "Queue size: " + this.mPumpList.size(), "Pump head at Y: " + this.getYOfPumpHead(), "Pump timer: " + this.mPumpTimer, "Meta Entity Timer: " + this.getBaseMetaTileEntity().getTimer()));
        return aList;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 16000 * this.mTier;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide == 0 || aSide == 1 ? TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT) : TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GT_Utility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.setWorld(aBaseTile.getWorld());
        this.mFakePlayer.setPosition((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.machines.blocks")};
    }
}

