/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.common.tools.GT_Tool_Saw;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Chainsaw_LV
extends GT_Tool_Saw {
    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 2.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return GregTech_API.sSoundList.get(104);
    }

    @Override
    public String getEntityHitSound() {
        return GregTech_API.sSoundList.get(105);
    }

    @Override
    public String getBreakingSound() {
        return GregTech_API.sSoundList.get(0);
    }

    @Override
    public String getMiningSound() {
        return GregTech_API.sSoundList.get(104);
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean isChainsaw() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        try {
            GT_Mod.achievements.issueAchievement(aPlayer, "brrrr");
            GT_Mod.achievements.issueAchievement(aPlayer, "buildChainsaw");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rAmount = 0;
        if (aBlock.getMaterial() == Material.leaves && aBlock instanceof IShearable) {
            aPlayer.worldObj.setBlock(aX, aY, aZ, aBlock, (int)aMetaData, 0);
            if (((IShearable)aBlock).isShearable(aStack, (IBlockAccess)aPlayer.worldObj, aX, aY, aZ)) {
                ArrayList tDrops = ((IShearable)aBlock).onSheared(aStack, (IBlockAccess)aPlayer.worldObj, aX, aY, aZ, aFortune);
                aDrops.clear();
            }
            aPlayer.worldObj.setBlock(aX, aY, aZ, Blocks.air, 0, 0);
        } else if ((aBlock.getMaterial() == Material.ice || aBlock.getMaterial() == Material.packedIce) && aDrops.isEmpty()) {
            aDrops.add(new ItemStack(aBlock, 1, (int)aMetaData));
            aPlayer.worldObj.setBlockToAir(aX, aY, aZ);
            aEvent.dropChance = 1.0f;
            return 1;
        }
        if (GregTech_API.sTimber && !aPlayer.isSneaking() && OrePrefixes.log.contains(new ItemStack(aBlock, 1, (int)aMetaData))) {
            int tH = aPlayer.worldObj.getHeight();
            for (int tY = aY + 1; tY < tH && aPlayer.worldObj.getBlock(aX, tY, aZ) == aBlock && aPlayer.worldObj.func_147480_a(aX, tY, aZ, true); ++tY) {
                ++rAmount;
            }
        }
        return rAmount;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        if (aBlock.isWood((IBlockAccess)aPlayer.worldObj, aX, aY, aZ) && OrePrefixes.log.contains(new ItemStack(aBlock, 1, (int)aMetaData))) {
            float rAmount = 1.0f;
            float tIncrement = 1.0f;
            if (GregTech_API.sTimber && !aPlayer.isSneaking()) {
                int tH = aPlayer.worldObj.getHeight();
                for (int tY = aY + 1; tY < tH && aPlayer.worldObj.getBlock(aX, tY, aZ) == aBlock; ++tY) {
                    rAmount += (tIncrement += 0.1f);
                }
            }
            return 2.0f * aDefault / rAmount;
        }
        return aBlock.getMaterial() == Material.leaves || aBlock.getMaterial() == Material.vine || aBlock.getMaterial() == Material.plants || aBlock.getMaterial() == Material.gourd ? aDefault / 4.0f : aDefault;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.toolHeadChainsaw.mTextureIndex] : Textures.ItemIcons.POWER_UNIT_LV;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mRGBa : GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.getCommandSenderName() + EnumChatFormatting.WHITE + " was massacred by " + EnumChatFormatting.GREEN + aPlayer.getCommandSenderName() + EnumChatFormatting.WHITE);
    }
}

