/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.event.FMLInterModComms;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_GUIContainer_FusionReactor;
import gregtech.common.gui.GT_GUIContainer_PrimitiveBlastFurnace;
import gregtech.nei.NEI_GT_Config;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_NEI_DefaultHandler
extends TemplateRecipeHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;
    protected final GT_Recipe.GT_Recipe_Map mRecipeMap;

    public GT_NEI_DefaultHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        this.mRecipeMap = aRecipeMap;
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(65, 13, 36, 18), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_GT_Config.sIsAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)GT_Values.GT, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("gregtech@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.getMinecraft().fontRenderer.drawString(aString, aX, aY, aColor);
    }

    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_DefaultHandler(this.mRecipeMap);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (GT_Recipe tRecipe : this.getSortedRecipes()) {
                if (tRecipe.mHidden) continue;
                this.arecipes.add(new CachedDefaultRecipe(tRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem(aResult, true)) != null) {
            tResults.add(GT_Utility.getFluidDisplayStack(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tResults.add(GT_Utility.copy(tData.filledContainer));
            }
        }
        block2: for (GT_Recipe tRecipe : this.getSortedRecipes()) {
            if (tRecipe.mHidden) continue;
            CachedDefaultRecipe tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tResults) {
                if (!tNEIRecipe.contains(tNEIRecipe.mOutputs, tStack)) continue;
                this.arecipes.add(tNEIRecipe);
                continue block2;
            }
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem(aInput, true)) != null) {
            tInputs.add(GT_Utility.getFluidDisplayStack(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tInputs.add(GT_Utility.copy(tData.filledContainer));
            }
        }
        block2: for (GT_Recipe tRecipe : this.getSortedRecipes()) {
            if (tRecipe.mHidden) continue;
            CachedDefaultRecipe tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tInputs) {
                if (!tNEIRecipe.contains(tNEIRecipe.mInputs, tStack)) continue;
                this.arecipes.add(tNEIRecipe);
                continue block2;
            }
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)78);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add(this.trans("150", "Chance: ") + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || tStack.item.stackSize != 0) break;
                currenttip.add(this.trans("151", "Does not get consumed in the process"));
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        block9: {
            String[] recipeDesc;
            block7: {
                int tSpecial;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block8: {
                                    int tEUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
                                    int tDuration = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
                                    recipeDesc = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.getNeiDesc();
                                    if (recipeDesc != null) break block7;
                                    if (tEUt != 0) {
                                        GT_NEI_DefaultHandler.drawText(10, 73, this.trans("152", "Total: ") + (long)tDuration * (long)tEUt + " EU", -16777216);
                                        GT_NEI_DefaultHandler.drawText(10, 83, this.trans("153", "Usage: ") + tEUt + " EU/t", -16777216);
                                        if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                                            byte tier = GT_Utility.getTier(tEUt / this.mRecipeMap.mAmperage);
                                            if (tier < 0 || tier >= 16) {
                                                GT_NEI_DefaultHandler.drawText(10, 93, this.trans("154", "Voltage: ") + tEUt / this.mRecipeMap.mAmperage + " EU", -65536);
                                            } else {
                                                GT_NEI_DefaultHandler.drawText(10, 93, this.trans("154", "Voltage: ") + tEUt / this.mRecipeMap.mAmperage + " EU (" + GT_Values.VN[tier] + ")", -16777216);
                                            }
                                            GT_NEI_DefaultHandler.drawText(10, 103, this.trans("155", "Amperage: ") + this.mRecipeMap.mAmperage, -16777216);
                                        } else {
                                            GT_NEI_DefaultHandler.drawText(10, 93, this.trans("156", "Voltage: unspecified"), -16777216);
                                            GT_NEI_DefaultHandler.drawText(10, 103, this.trans("157", "Amperage: unspecified"), -16777216);
                                        }
                                    }
                                    if (tDuration > 0) {
                                        GT_NEI_DefaultHandler.drawText(10, 113, this.trans("158", "Time: ") + String.format("%.2f " + this.trans("161", " secs"), Float.valueOf(0.05f * (float)tDuration)), -16777216);
                                    }
                                    if ((tSpecial = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue) != -100 || !GT_Mod.gregtechproxy.mLowGravProcessing) break block8;
                                    GT_NEI_DefaultHandler.drawText(10, 123, this.trans("159", "Needs Low Gravity"), -16777216);
                                    break block9;
                                }
                                if (tSpecial != -200 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block10;
                                GT_NEI_DefaultHandler.drawText(10, 123, this.trans("160", "Needs Cleanroom"), -16777216);
                                break block9;
                            }
                            if (tSpecial != -201) break block11;
                            GT_NEI_DefaultHandler.drawText(10, 123, this.trans("206", "Scan for Assembly Line"), -16777216);
                            break block9;
                        }
                        if (tSpecial != -300 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block12;
                        GT_NEI_DefaultHandler.drawText(10, 123, this.trans("160", "Needs Cleanroom & LowGrav"), -16777216);
                        break block9;
                    }
                    if (tSpecial != -400) break block13;
                    GT_NEI_DefaultHandler.drawText(10, 123, this.trans("216", "Deprecated Recipe"), -16777216);
                    break block9;
                }
                if (!GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePre) && !GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePost)) break block9;
                GT_NEI_DefaultHandler.drawText(10, 123, this.mRecipeMap.mNEISpecialValuePre + tSpecial * this.mRecipeMap.mNEISpecialValueMultiplier + this.mRecipeMap.mNEISpecialValuePost, -16777216);
                break block9;
            }
            int i = 0;
            for (String descLine : recipeDesc) {
                GT_NEI_DefaultHandler.drawText(10, 73 + 10 * i, descLine, -16777216);
                ++i;
            }
        }
    }

    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            ArrayList<PositionedStack> maybeOut;
            ArrayList<PositionedStack> maybeIn;
            super((TemplateRecipeHandler)GT_NEI_DefaultHandler.this);
            this.mRecipe = aRecipe;
            try {
                maybeIn = aRecipe.getInputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeIn = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid InputPositionedStacks " + aRecipe.toString());
                npe.printStackTrace(GT_Log.err);
            }
            try {
                maybeOut = aRecipe.getOutputPositionedStacks();
            }
            catch (NullPointerException npe) {
                maybeOut = null;
                GT_Log.err.println("CachedDefaultRecipe - Invalid OutputPositionedStacks " + aRecipe.toString());
                npe.printStackTrace(GT_Log.err);
            }
            if (maybeIn != null && maybeOut != null) {
                this.mInputs = maybeIn;
                this.mOutputs = maybeOut;
                return;
            }
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            int tStartIndex = 0;
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualInputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 5));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 23));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 23));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getRepresentativeInput(tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, -4));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 14));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 12, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 30, 32));
                    }
                    if (aRecipe.getRepresentativeInput(++tStartIndex) != null) {
                        this.mInputs.add(new FixedPositionedStack(aRecipe.getRepresentativeInput(tStartIndex), 48, 32));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 120, 52));
            }
            tStartIndex = 0;
            switch (GT_NEI_DefaultHandler.this.mRecipeMap.mUsualOutputCount) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 2: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 3: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 4: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 5: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 6: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 5, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 23, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 7: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                case 8: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                    break;
                }
                default: {
                    if (aRecipe.getOutput(tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, -4, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 14, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 102, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 120, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    if (aRecipe.getOutput(++tStartIndex) != null) {
                        this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(tStartIndex), 138, 32, aRecipe.getOutputChance(tStartIndex)));
                    }
                    ++tStartIndex;
                }
            }
            if (aRecipe.mFluidInputs.length > 0 && aRecipe.mFluidInputs[0] != null && aRecipe.mFluidInputs[0].getFluid() != null) {
                this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[0], true), 48, 52));
                if (aRecipe.mFluidInputs.length > 1 && aRecipe.mFluidInputs[1] != null && aRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[1], true), 30, 52));
                }
            }
            if (aRecipe.mFluidOutputs.length > 1) {
                if (aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 120, 5));
                }
                if (aRecipe.mFluidOutputs[1] != null && aRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[1], true), 138, 5));
                }
                if (aRecipe.mFluidOutputs.length > 2 && aRecipe.mFluidOutputs[2] != null && aRecipe.mFluidOutputs[2].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[2], true), 102, 23));
                }
                if (aRecipe.mFluidOutputs.length > 3 && aRecipe.mFluidOutputs[3] != null && aRecipe.mFluidOutputs[3].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[3], true), 120, 23));
                }
                if (aRecipe.mFluidOutputs.length > 4 && aRecipe.mFluidOutputs[4] != null && aRecipe.mFluidOutputs[4].getFluid() != null) {
                    this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[4], true), 138, 23));
                }
            } else if (aRecipe.mFluidOutputs.length > 0 && aRecipe.mFluidOutputs[0] != null && aRecipe.mFluidOutputs[0].getFluid() != null) {
                this.mOutputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidOutputs[0], true), 102, 52));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GT_NEI_DefaultHandler.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public static class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated = false;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(GT_OreDictUnificator.getNonUnifiedStacks(object), x, y, true);
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (tStack.getItemDamage() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.getItem());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount(tStack.stackSize, stack));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.getItem(), tStack.stackSize);
                    base.stackTagCompound = tStack.stackTagCompound;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copy(tStack));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.fire)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            if (this.canHandle(gui)) {
                if (button == 0) {
                    return this.transferRect(gui, false);
                }
                if (button == 1) {
                    return this.transferRect(gui, true);
                }
            }
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return gui instanceof GT_GUIContainer_BasicMachine && GT_Utility.isStringValid(((GT_GUIContainer_BasicMachine)gui).mNEI) || gui instanceof GT_GUIContainer_FusionReactor && GT_Utility.isStringValid(((GT_GUIContainer_FusionReactor)gui).mNEI) || gui instanceof GT_GUIContainer_PrimitiveBlastFurnace && GT_Utility.isStringValid(((GT_GUIContainer_PrimitiveBlastFurnace)gui).mNEI);
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            if (this.canHandle(gui) && currenttip.isEmpty()) {
                if (gui instanceof GT_GUIContainer_BasicMachine && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_BasicMachine)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_BasicMachine)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]))) {
                    currenttip.add("Recipes");
                } else if (gui instanceof GT_GUIContainer_FusionReactor && new Rectangle(145, 0, 24, 24).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_FusionReactor)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_FusionReactor)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]))) {
                    currenttip.add("Recipes");
                } else if (gui instanceof GT_GUIContainer_PrimitiveBlastFurnace && new Rectangle(51, 10, 24, 24).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_PrimitiveBlastFurnace)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_PrimitiveBlastFurnace)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1]))) {
                    currenttip.add("Recipes");
                }
            }
            return currenttip;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            if (gui instanceof GT_GUIContainer_BasicMachine) {
                return this.canHandle(gui) && new Rectangle(65, 13, 36, 18).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_BasicMachine)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_BasicMachine)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((GT_GUIContainer_BasicMachine)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((GT_GUIContainer_BasicMachine)gui).mNEI, (Object[])new Object[0]));
            }
            if (gui instanceof GT_GUIContainer_FusionReactor) {
                return this.canHandle(gui) && new Rectangle(145, 0, 24, 24).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_FusionReactor)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_FusionReactor)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((GT_GUIContainer_FusionReactor)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((GT_GUIContainer_FusionReactor)gui).mNEI, (Object[])new Object[0]));
            }
            if (gui instanceof GT_GUIContainer_PrimitiveBlastFurnace) {
                return this.canHandle(gui) && new Rectangle(51, 10, 24, 24).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_PrimitiveBlastFurnace)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_PrimitiveBlastFurnace)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((GT_GUIContainer_PrimitiveBlastFurnace)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((GT_GUIContainer_PrimitiveBlastFurnace)gui).mNEI, (Object[])new Object[0]));
            }
            return false;
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

