/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.LightingHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

class GT_RenderedTexture
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;

    GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mRGBa = aRGBa;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST.ordinal(), this.mRGBa);
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.EAST.ordinal(), 0xFFFFFF);
            aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST.ordinal(), this.mRGBa);
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.WEST.ordinal(), 0xFFFFFF);
            aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP.ordinal(), this.mRGBa);
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.UP.ordinal(), 0xFFFFFF);
            aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon aIcon = this.mIconContainer.getIcon();
        float minU = aIcon.func_94214_a((1.0 - aRenderer.field_147861_i) * 16.0);
        float maxU = aIcon.func_94214_a((1.0 - aRenderer.field_147859_h) * 16.0);
        float minV = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
        float maxV = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            minU = 16.0f - aIcon.func_94212_f();
            maxU = 16.0f - aIcon.func_94209_e();
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            minV = aIcon.func_94206_g();
            maxV = aIcon.func_94210_h();
        }
        double minX = (double)aX + aRenderer.field_147859_h;
        double maxX = (double)aX + aRenderer.field_147861_i;
        double minY = (double)aY + aRenderer.field_147855_j;
        double minZ = (double)aZ + aRenderer.field_147851_l;
        double maxZ = (double)aZ + aRenderer.field_147853_m;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN.ordinal(), this.mRGBa);
        if (aRenderer.field_147863_w) {
            tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
            tessellator.func_78380_c(aRenderer.field_147864_al);
            tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
            tessellator.func_78380_c(aRenderer.field_147874_am);
            tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
            tessellator.func_78380_c(aRenderer.field_147876_an);
            tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
            tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
            tessellator.func_78380_c(aRenderer.field_147870_ao);
        } else {
            tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
        }
        tessellator.func_78374_a(maxX, minY, maxZ, (double)minU, (double)maxV);
        if (this.mIconContainer.getOverlayIcon() != null) {
            minU = aIcon.func_94214_a((1.0 - aRenderer.field_147861_i) * 16.0);
            maxU = aIcon.func_94214_a((1.0 - aRenderer.field_147859_h) * 16.0);
            minV = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
            maxV = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
            if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
                minU = 16.0f - aIcon.func_94212_f();
                maxU = 16.0f - aIcon.func_94209_e();
            }
            if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
                minV = aIcon.func_94206_g();
                maxV = aIcon.func_94210_h();
            }
            minX = (float)aX + (float)aRenderer.field_147859_h;
            maxX = (float)aX + (float)aRenderer.field_147861_i;
            minY = (float)aY + (float)aRenderer.field_147855_j;
            minZ = (float)aZ + (float)aRenderer.field_147851_l;
            maxZ = (float)aZ + (float)aRenderer.field_147853_m;
            lighting.setupColor(ForgeDirection.DOWN.ordinal(), 0xFFFFFF);
            if (aRenderer.field_147863_w) {
                tessellator.func_78386_a(aRenderer.field_147872_ap, aRenderer.field_147846_at, aRenderer.field_147854_ax);
                tessellator.func_78380_c(aRenderer.field_147864_al);
                tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
                tessellator.func_78386_a(aRenderer.field_147852_aq, aRenderer.field_147860_au, aRenderer.field_147841_ay);
                tessellator.func_78380_c(aRenderer.field_147874_am);
                tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
                tessellator.func_78386_a(aRenderer.field_147850_ar, aRenderer.field_147858_av, aRenderer.field_147839_az);
                tessellator.func_78380_c(aRenderer.field_147876_an);
                tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
                tessellator.func_78386_a(aRenderer.field_147848_as, aRenderer.field_147856_aw, aRenderer.field_147833_aA);
                tessellator.func_78380_c(aRenderer.field_147870_ao);
            } else {
                tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
                tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
                tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
            }
            tessellator.func_78374_a(maxX, minY, maxZ, (double)minU, (double)maxV);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH.ordinal(), this.mRGBa);
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.SOUTH.ordinal(), 0xFFFFFF);
            aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        aRenderer.field_152631_f = true;
        LightingHelper lighting = new LightingHelper(aRenderer);
        lighting.setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH.ordinal(), this.mRGBa);
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.NORTH.ordinal(), 0xFFFFFF);
            aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

