/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Buffer;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_ItemDistributor;
import gregtech.common.gui.GT_GUIContainer_ItemDistributor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_ItemDistributor
extends GT_MetaTileEntity_Buffer {
    private byte[] itemsPerSide = new byte[6];
    private byte currentSide = 0;
    private byte currentSideItemCount = 0;

    public GT_MetaTileEntity_ItemDistributor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 28, new String[]{"Distributes Items between different Machine Sides", "Default Items per Machine Side: 0", "Use Screwdriver to increase/decrease Items per Side", "Consumes 1EU per moved Item"});
    }

    public GT_MetaTileEntity_ItemDistributor(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aInvSlotCount, aDescription);
    }

    public GT_MetaTileEntity_ItemDistributor(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    public GT_MetaTileEntity_ItemDistributor(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ItemDistributor(this.mName, (int)this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length - 1; ++i) {
            for (int j = i + 1; j < this.mInventory.length - 1; ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual(this.mInventory[i], this.mInventory[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), j, i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_ItemDistributor(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public ITexture getOverlayIcon() {
        return TextureFactory.of(TextureFactory.of(Textures.BlockIcons.AUTOMATION_ITEMDISTRIBUTOR), TextureFactory.builder().addIcon(Textures.BlockIcons.AUTOMATION_ITEMDISTRIBUTOR_GLOW).glow().build());
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_ItemDistributor(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return this.mTextures[0][aColorIndex + 1];
        }
        return this.mTextures[1][aColorIndex + 1];
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] returnTextures = new ITexture[2][17][];
        ITexture baseIcon = this.getOverlayIcon();
        ITexture pipeIcon = TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT);
        for (int i = 0; i < 17; ++i) {
            returnTextures[0][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], baseIcon};
            returnTextures[1][i] = new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][i], pipeIcon, baseIcon};
        }
        return returnTextures;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().getFrontFacing() == aSide || this.itemsPerSide[aSide] == 0;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return this.getBaseMetaTileEntity().getFrontFacing() != aSide && this.itemsPerSide[aSide] > 0;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < this.mInventory.length - 1;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.itemsPerSide = aNBT.func_74770_j("mItemsPerSide");
        if (this.itemsPerSide.length != 6) {
            this.itemsPerSide = new byte[6];
        }
        this.currentSide = aNBT.func_74771_c("mCurrentSide");
        this.currentSideItemCount = aNBT.func_74771_c("mCurrentSideItemCount");
    }

    @Override
    protected void moveItems(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        this.fillStacksIntoFirstSlots();
        TileEntity adjacentTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(this.currentSide);
        int inspectedSides = 0;
        while (this.itemsPerSide[this.currentSide] == 0) {
            this.currentSide = (byte)((this.currentSide + 1) % 6);
            this.currentSideItemCount = 0;
            adjacentTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(this.currentSide);
            if (++inspectedSides != 6) continue;
            return;
        }
        byte movedItems = GT_Utility.moveOneItemStack(aBaseMetaTileEntity, adjacentTileEntity, this.currentSide, GT_Utility.getOppositeSide(this.currentSide), null, false, (byte)64, (byte)1, (byte)(this.itemsPerSide[this.currentSide] - this.currentSideItemCount), (byte)1);
        this.currentSideItemCount = (byte)(this.currentSideItemCount + movedItems);
        if (this.currentSideItemCount >= this.itemsPerSide[this.currentSide]) {
            this.currentSide = (byte)((this.currentSide + 1) % 6);
            this.currentSideItemCount = 0;
        }
        if (movedItems > 0 || aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.mSuccess = 50;
        }
        this.fillStacksIntoFirstSlots();
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        byte by = aSide;
        this.itemsPerSide[by] = (byte)(this.itemsPerSide[by] + (aPlayer.func_70093_af() ? -1 : 1));
        this.itemsPerSide[aSide] = (byte)((this.itemsPerSide[aSide] + 128) % 128);
        GT_Utility.sendChatToPlayer(aPlayer, this.trans("211", "Items per side: ") + this.itemsPerSide[aSide]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74773_a("mItemsPerSide", this.itemsPerSide);
        aNBT.func_74774_a("mCurrentSide", this.currentSide);
        aNBT.func_74774_a("mCurrentSideItemCount", this.currentSideItemCount);
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        aNBT.func_74773_a("mItemsPerSide", this.itemsPerSide);
    }
}

