/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_MetaTileEntity_Disassembler
extends GT_MetaTileEntity_BasicMachine {
    private static final ItemStack[][] alwaysReplace = new ItemStack[][]{{new ItemStack(Blocks.field_150447_bR, 1, Short.MAX_VALUE)}, {new ItemStack((Block)Blocks.field_150486_ae)}};
    private static final Object[][] OreDictionaryOverride = new Object[][]{{"plankWood", "stoneCobble", "gemDiamond", "logWood", "stickWood", "treeSapling"}, {new ItemStack(Blocks.field_150344_f), new ItemStack(Blocks.field_150347_e), new ItemStack(Items.field_151045_i), new ItemStack(Blocks.field_150364_r), new ItemStack(Items.field_151055_y), new ItemStack(Blocks.field_150345_g)}};
    private static final ArrayListMultimap<GT_ItemStack, ItemStack> outputHardOverrides = ArrayListMultimap.create();
    private static final Set<GT_ItemStack> blackList;

    public GT_MetaTileEntity_Disassembler(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Disassembles Machines up to " + GT_Values.TIER_COLORS[aTier] + GT_Values.VOLTAGE_NAMES[aTier], "Can also disassemble most assembler recipes!"}, 1, 9, "Disassembler.png", "", TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER_ACTIVE), TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_DISASSEMBLER), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISASSEMBLER_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER_ACTIVE_GLOW).glow().build()), TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_DISASSEMBLER), TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE), TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_DISASSEMBLER));
    }

    public GT_MetaTileEntity_Disassembler(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 9, aGUIName, aNEIName);
    }

    public GT_MetaTileEntity_Disassembler(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 9, aGUIName, aNEIName);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Disassembler(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public static ArrayListMultimap<GT_ItemStack, ItemStack> getOutputHardOverrides() {
        return outputHardOverrides;
    }

    public static Set<GT_ItemStack> getBlackList() {
        return blackList;
    }

    private boolean compareToUnpacker(ItemStack is) {
        return null != GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes.findRecipe(null, true, true, Long.MAX_VALUE, null, is);
    }

    @Override
    public int checkRecipe() {
        ItemStack is = this.getInputAt(0);
        if (GT_Utility.isStackInvalid(is)) {
            return 0;
        }
        if (is.func_77973_b() instanceof GT_MetaGenerated_Tool || blackList.contains(new GT_ItemStack(is)) || this.compareToUnpacker(is)) {
            return 0;
        }
        if (this.checkTier(is)) {
            return 1;
        }
        Integer handleHardOverride = this.handleHardOverride(is);
        if (handleHardOverride != null) {
            return handleHardOverride;
        }
        return this.process();
    }

    private Integer handleHardOverride(ItemStack is) {
        Set stacks = outputHardOverrides.keySet();
        for (GT_ItemStack stack : stacks) {
            ItemStack in = is.func_77946_l();
            in.field_77994_a = 1;
            if (!stack.isStackEqual(in) || stack.mStackSize > is.field_77994_a) continue;
            return this.setOutputsAndTime(outputHardOverrides.get((Object)stack).toArray(new ItemStack[0]), stack.mStackSize) ? 2 : 0;
        }
        return null;
    }

    private boolean checkTier(ItemStack is) {
        ItemStack comp = new ItemStack(GregTech_API.sBlockMachines);
        if (is.func_77973_b() == comp.func_77973_b()) {
            IMetaTileEntity iMetaTileEntity = GregTech_API.METATILEENTITIES[is.func_77960_j()];
            return iMetaTileEntity instanceof GT_MetaTileEntity_TieredMachineBlock && ((GT_MetaTileEntity_TieredMachineBlock)iMetaTileEntity).mTier > this.mTier;
        }
        return false;
    }

    private int process() {
        int statusCode = this.checkRecipeMap();
        if (statusCode != 0) {
            return statusCode;
        }
        return this.onTheFlyGeneration();
    }

    private int onTheFlyGeneration() {
        Collection<DissassembleReference> recipes = this.findRecipeFromMachine();
        if (recipes.isEmpty()) {
            return 0;
        }
        DissassembleReference recipe = GT_MetaTileEntity_Disassembler.ensureDowncasting(recipes);
        this.removeInvalidStacks(recipe);
        return this.setOutputsAndTime(recipe.inputs, recipe.stackSize) ? 2 : 1;
    }

    private void removeInvalidStacks(DissassembleReference recipe) {
        for (int i = 0; i < recipe.inputs.length; ++i) {
            if (!GT_Utility.isStackInvalid(recipe.inputs[i]) && recipe.inputs[i].field_77994_a >= 1) continue;
            recipe.inputs[i] = null;
        }
        recipe.inputs = GT_Utility.getArrayListWithoutNulls(recipe.inputs).toArray(new ItemStack[0]);
    }

    private int checkRecipeMap() {
        GT_Recipe gt_recipe = GT_Recipe.GT_Recipe_Map.sDisassemblerRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, this.maxEUInput(), null, this.getAllInputs());
        if (gt_recipe == null) {
            return 0;
        }
        if (gt_recipe.isRecipeInputEqual(false, null, this.getAllInputs())) {
            return this.setOutputsAndTime(gt_recipe.mOutputs, gt_recipe.mInputs[0].field_77994_a) ? 2 : 1;
        }
        return 1;
    }

    private boolean setOutputsAndTime(ItemStack[] inputs, int stackSize) {
        if (this.getInputAt((int)0).field_77994_a >= stackSize) {
            this.getInputAt((int)0).field_77994_a -= stackSize;
        } else {
            return false;
        }
        System.arraycopy(inputs, 0, this.mOutputItems, 0, inputs.length);
        this.calculateOverclockedNess(30, 600);
        return true;
    }

    private static DissassembleReference ensureDowncasting(Collection<? extends DissassembleReference> recipes) {
        ItemStack[] inputs = recipes.stream().findFirst().orElseThrow((Supplier<NullPointerException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/NullPointerException;)()).inputs;
        ItemStack[] output = new ItemStack[inputs.length];
        List recipesColl = null;
        if (recipes.size() > 1) {
            recipesColl = recipes.stream().skip(1L).map(x -> x.recipe).collect(Collectors.toList());
        }
        GT_MetaTileEntity_Disassembler.handleRecipeTransformation(inputs, output, recipesColl);
        return new DissassembleReference(recipes.stream().mapToInt(x -> x.stackSize).min().orElseThrow(NumberFormatException::new), output, null);
    }

    private static void handleRecipeTransformation(ItemStack[] inputs, ItemStack[] output, List<? extends GT_Recipe> recipesColl) {
        int inputsLength = inputs.length;
        for (int i = 0; i < inputsLength; ++i) {
            Set inputsStacks = null;
            if (recipesColl != null) {
                inputsStacks = recipesColl.stream().map(x -> x.mInputs).collect(Collectors.toSet());
            }
            GT_MetaTileEntity_Disassembler.handleRecipeTransformationInternal(inputs, output, inputsStacks, i);
        }
        GT_MetaTileEntity_Disassembler.addOthersAndHandleAlwaysReplace(inputs, output);
    }

    public static void handleRecipeTransformation(ItemStack[] inputs, ItemStack[] output, Set<ItemStack[]> inputsStacks) {
        int inputsLength = inputs.length;
        for (int i = 0; i < inputsLength; ++i) {
            GT_MetaTileEntity_Disassembler.handleRecipeTransformationInternal(inputs, output, inputsStacks, i);
        }
        GT_MetaTileEntity_Disassembler.addOthersAndHandleAlwaysReplace(inputs, output);
    }

    private static void handleRecipeTransformationInternal(ItemStack[] inputs, ItemStack[] output, Set<ItemStack[]> inputsStacks, int i) {
        ItemStack input = inputs[i];
        ItemData data = GT_OreDictUnificator.getItemData(input);
        if (data == null || data.mMaterial == null || data.mMaterial.mMaterial == null || data.mPrefix == null) {
            output[i] = input;
            return;
        }
        GT_MetaTileEntity_Disassembler.handleReplacement(inputsStacks, data, output, input, i);
    }

    private static void addOthersAndHandleAlwaysReplace(ItemStack[] inputs, ItemStack[] output) {
        for (int i = 0; i < inputs.length; ++i) {
            if (output[i] == null) {
                output[i] = inputs[i];
            }
            if (GT_Utility.areStacksEqual(output[i], inputs[i])) {
                output[i].field_77994_a = Math.min(output[i].field_77994_a, inputs[i].field_77994_a);
            }
            ItemStack[] itemStacks = alwaysReplace[0];
            for (int j = 0; j < itemStacks.length; ++j) {
                ItemStack x = itemStacks[j];
                if (!GT_Utility.areStacksEqual(x, output[i], true)) continue;
                output[i] = alwaysReplace[1][j];
                break;
            }
            output[i] = GT_MetaTileEntity_Disassembler.handleUnification(output[i]);
        }
    }

    private static ItemStack handleUnification(ItemStack stack) {
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            for (int i = 0; i < OreDictionaryOverride[0].length; ++i) {
                if (!OreDictionary.getOreName((int)oreID).equals(OreDictionaryOverride[0][i])) continue;
                ItemStack ret = ((ItemStack)OreDictionaryOverride[1][i]).func_77946_l();
                ret.field_77994_a = stack.field_77994_a;
                return ret;
            }
        }
        return GT_OreDictUnificator.get(stack);
    }

    private static void handleReplacement(Set<ItemStack[]> inputsStacks, ItemData data, ItemStack[] output, ItemStack input, int i) {
        AtomicReference toRpl = new AtomicReference();
        Materials first = data.mMaterial.mMaterial;
        if (inputsStacks != null) {
            GT_MetaTileEntity_Disassembler.handleInputStacks(inputsStacks, toRpl, data, first, i);
        }
        if (toRpl.get() == null) {
            GT_MetaTileEntity_Disassembler.handleBetterMaterialsVersions(data, toRpl);
        }
        if (toRpl.get() != null) {
            output[i] = GT_OreDictUnificator.get(data.mPrefix, toRpl.get(), (long)input.field_77994_a);
            return;
        }
        if (data.mPrefix == OrePrefixes.circuit) {
            GT_MetaTileEntity_Disassembler.handleCircuits(first, output, input, i);
        }
    }

    private static void handleInputStacks(Set<ItemStack[]> inputsStacks, AtomicReference<? super Materials> toRpl, ItemData data, Materials first, int i) {
        int finalIndex = i;
        inputsStacks.forEach(stackArray -> {
            ItemData dataAgainst = GT_OreDictUnificator.getItemData(stackArray[finalIndex]);
            if (dataAgainst == null || dataAgainst.mMaterial == null || dataAgainst.mMaterial.mMaterial == null || dataAgainst.mPrefix == null || dataAgainst.mPrefix != data.mPrefix) {
                return;
            }
            GT_MetaTileEntity_Disassembler.handleDifferentMaterialsOnRecipes(first, dataAgainst.mMaterial.mMaterial, toRpl);
            GT_MetaTileEntity_Disassembler.handleAnyMaterials(first, toRpl);
        });
    }

    private static void handleAnyMaterials(Materials first, AtomicReference<? super Materials> toRpl) {
        if (first.mOreReRegistrations.stream().anyMatch(y -> y.equals(Materials.AnyIron))) {
            toRpl.set(Materials.Iron);
        } else if (first.mOreReRegistrations.stream().anyMatch(y -> y.equals(Materials.AnyCopper))) {
            toRpl.set(Materials.Copper);
        } else if (first.mOreReRegistrations.stream().anyMatch(y -> y.equals(Materials.AnyRubber))) {
            toRpl.set(Materials.Rubber);
        } else if (first.mOreReRegistrations.stream().anyMatch(y -> y.equals(Materials.AnyBronze))) {
            toRpl.set(Materials.Bronze);
        } else if (first.mOreReRegistrations.stream().anyMatch(y -> y.equals(Materials.AnySyntheticRubber))) {
            toRpl.set(Materials.Rubber);
        }
    }

    private static void handleDifferentMaterialsOnRecipes(Materials first, Materials second, AtomicReference<? super Materials> toRpl) {
        if (!first.equals(second)) {
            if (first.equals(Materials.Aluminium) && second.equals(Materials.Iron)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Steel) && second.equals(Materials.Iron)) {
                toRpl.set(second);
            } else if (first.equals(Materials.WroughtIron) && second.equals(Materials.Iron)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Aluminium) && second.equals(Materials.WroughtIron)) {
                toRpl.set(Materials.Iron);
            } else if (first.equals(Materials.Aluminium) && second.equals(Materials.Steel)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Polytetrafluoroethylene) && second.equals(Materials.Plastic)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Polybenzimidazole) && second.equals(Materials.Plastic)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Polystyrene) && second.equals(Materials.Plastic)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Silicone) && second.equals(Materials.Plastic)) {
                toRpl.set(second);
            } else if (first.equals(Materials.NetherQuartz) || first.equals(Materials.CertusQuartz) && second.equals(Materials.Quartzite)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Plastic) && second.equals(Materials.Wood)) {
                toRpl.set(second);
            } else if (first.equals(Materials.Diamond) && second.equals(Materials.Glass)) {
                toRpl.set(second);
            }
        }
    }

    private static void handleBetterMaterialsVersions(ItemData data, AtomicReference<? super Materials> toRpl) {
        if (Materials.SteelMagnetic.equals(data.mMaterial.mMaterial)) {
            toRpl.set(Materials.Steel);
        } else if (Materials.IronMagnetic.equals(data.mMaterial.mMaterial)) {
            toRpl.set(Materials.Iron);
        } else if (Materials.NeodymiumMagnetic.equals(data.mMaterial.mMaterial)) {
            toRpl.set(Materials.Neodymium);
        } else if (Materials.SamariumMagnetic.equals(data.mMaterial.mMaterial)) {
            toRpl.set(Materials.Samarium);
        } else if (Materials.AnnealedCopper.equals(data.mMaterial.mMaterial)) {
            toRpl.set(Materials.Copper);
        }
    }

    private static void handleCircuits(Materials first, ItemStack[] output, ItemStack input, int i) {
        if (first.equals(Materials.Primitive)) {
            output[i] = ItemList.NandChip.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Basic)) {
            output[i] = ItemList.Circuit_Microprocessor.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Good)) {
            output[i] = ItemList.Circuit_Good.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Advanced)) {
            output[i] = ItemList.Circuit_Advanced.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Data)) {
            output[i] = ItemList.Circuit_Data.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Master)) {
            output[i] = ItemList.Circuit_Master.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Ultimate)) {
            output[i] = ItemList.Circuit_Quantummainframe.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Superconductor)) {
            output[i] = ItemList.Circuit_Crystalmainframe.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Infinite)) {
            output[i] = ItemList.Circuit_Wetwaremainframe.get(input.field_77994_a, new Object[0]);
        } else if (first.equals(Materials.Bio)) {
            output[i] = ItemList.Circuit_Biomainframe.get(input.field_77994_a, new Object[0]);
        }
    }

    private Collection<DissassembleReference> findRecipeFromMachine() {
        ItemStack is = this.getInputAt(0);
        if (GT_Utility.isStackInvalid(is)) {
            return Collections.emptySet();
        }
        AtomicInteger stacksize = new AtomicInteger();
        List<DissassembleReference> possibleRecipes = GT_Recipe.GT_Recipe_Map.sAssemblerRecipes.mRecipeList.stream().filter(x -> Arrays.stream(x.mOutputs).anyMatch(y -> {
            boolean isDone;
            ItemStack out = is.func_77946_l();
            out.field_77994_a = y.field_77994_a;
            boolean bl = isDone = GT_Utility.areStacksEqual(y, out, true) && y.field_77994_a <= is.field_77994_a;
            if (isDone) {
                stacksize.set(y.field_77994_a);
            }
            return isDone;
        })).map(x -> new DissassembleReference(stacksize.get(), x.mInputs, (GT_Recipe)x)).collect(Collectors.toList());
        if (possibleRecipes.size() == 1) {
            return possibleRecipes;
        }
        return possibleRecipes.stream().sorted(Comparator.comparingDouble(GT_MetaTileEntity_Disassembler::getCheaperInputs)).collect(Collectors.toList());
    }

    private static double getCheaperInputs(DissassembleReference x) {
        double fluidInputValueRaw = Arrays.stream(x.recipe.mFluidInputs).flatMapToInt(f -> IntStream.of(f.amount)).sum();
        fluidInputValueRaw = fluidInputValueRaw > 0.0 ? fluidInputValueRaw : 144.0;
        double inputValue = (double)Arrays.stream(x.inputs).flatMapToInt(f -> IntStream.of(f.field_77994_a)).sum() + fluidInputValueRaw / 144.0;
        double fluidOutputValueRaw = Arrays.stream(x.recipe.mFluidOutputs).flatMapToInt(f -> IntStream.of(f.amount)).sum();
        fluidOutputValueRaw = fluidOutputValueRaw > 0.0 ? fluidOutputValueRaw : 144.0;
        double outputValue = (double)Arrays.stream(x.recipe.mOutputs).flatMapToInt(f -> IntStream.of(f.field_77994_a)).sum() + fluidOutputValueRaw / 144.0;
        return inputValue / outputValue;
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, aSide, aStack) && aStack.func_77978_p() != null && aStack.func_77978_p().func_74775_l("GT.CraftingComponents") != null;
    }

    static {
        outputHardOverrides.put((Object)new GT_ItemStack(new ItemStack(Blocks.field_150478_aa, 6)), (Object)new ItemStack(Items.field_151055_y));
        blackList = new HashSet<GT_ItemStack>();
        blackList.add(new GT_ItemStack(ItemList.Casing_Coil_Superconductor.get(1L, new Object[0])));
    }

    static class DissassembleReference {
        final int stackSize;
        ItemStack[] inputs;
        final GT_Recipe recipe;

        public DissassembleReference(int stackSize, ItemStack[] inputs, GT_Recipe recipe) {
            this.stackSize = stackSize;
            this.inputs = inputs;
            this.recipe = recipe;
        }
    }
}

