/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.BitSet;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_OilCracker
extends GT_MetaTileEntity_MultiBlockBase {
    private ForgeDirection orientation;
    private int controllerX;
    private int controllerZ;
    private static final byte CASING_INDEX = 49;
    private HeatingCoilLevel heatLevel;

    public GT_MetaTileEntity_OilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilCracker(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Cracker").addInfo("Controller block for the Oil Cracking Unit").addInfo("Thermally cracks heavy hydrocarbons into lighter fractions").addInfo("More efficient than the Chemical Reactor").addInfo("Place the appropriate circuit in the controller").addSeparator().beginStructureBlock(5, 3, 3, true).addController("Front center").addCasingInfo("Clean Stainless Steel Machine Casing", 18).addOtherStructurePart("2 Rings of 8 Coils", "Each side of the controller").addInfo("Gets 5% energy cost reduction per coil tier").addEnergyHatch("Any casing").addMaintenanceHatch("Any casing").addInputHatch("Steam/Hydrogen, Any middle ring casing").addInputHatch("Any left/right side casing").addOutputHatch("Any left/right side casing").addStructureInfo("Input/Output Hatches must be on opposite sides!").toolTipFinisher("Gregtech");
        if (!Keyboard.isKeyDown((int)42)) {
            return tt.getInformation();
        }
        return tt.getStructureInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_OIL_CRACKER_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][49]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OilCrackingUnit.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tInputList = this.getStoredFluids();
        FluidStack[] tFluidInputs = tInputList.toArray(new FluidStack[0]);
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCrakingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluidInputs, this.mInventory[1]);
        if (tRecipe == null) {
            return false;
        }
        if (tRecipe.isRecipeInputEqual(true, tFluidInputs, this.mInventory[1])) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.mEUt = tRecipe.mEUt;
            this.mMaxProgresstime = tRecipe.mDuration;
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
            this.mEUt = (int)((double)this.mEUt * Math.pow(0.95, this.heatLevel.getTier()));
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            return true;
        }
        return false;
    }

    private boolean coilsNotPresent(IGregTechTileEntity aBaseMetaTileEntity, int x, int y, int z) {
        Block coil = aBaseMetaTileEntity.getBlockOffset(x, y, z);
        if (!(coil instanceof IHeatingCoil)) {
            return true;
        }
        IHeatingCoil heatingCoil = (IHeatingCoil)coil;
        byte meta = aBaseMetaTileEntity.getMetaIDOffset(x, y, z);
        HeatingCoilLevel heatLevel = heatingCoil.getCoilHeat(meta);
        if (heatLevel == HeatingCoilLevel.None) {
            return true;
        }
        if (this.heatLevel == HeatingCoilLevel.None) {
            this.heatLevel = heatLevel;
        }
        return this.heatLevel != heatLevel;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.heatLevel = HeatingCoilLevel.None;
        this.orientation = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing());
        this.controllerX = aBaseMetaTileEntity.getXCoord();
        this.controllerZ = aBaseMetaTileEntity.getZCoord();
        int xDir = this.orientation.offsetX;
        int zDir = this.orientation.offsetZ;
        MutableInt amount = new MutableInt(0);
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        BitSet flags = new BitSet(4);
        for (int depth = -1; depth < 2; ++depth) {
            for (int height = -1; height < 2; ++height) {
                for (int slice = -2; slice < 3; ++slice) {
                    if (!(xDir == 0 ? this.isStructureBroken(xDir, zDir, slice, height, depth, aBaseMetaTileEntity, amount, flags) : this.isStructureBroken(xDir, zDir, depth, height, slice, aBaseMetaTileEntity, amount, flags))) continue;
                    return false;
                }
            }
        }
        if (this.checkInputOutputBroken(flags)) {
            return false;
        }
        return amount.intValue() >= 18;
    }

    private boolean checkInputOutputBroken(BitSet flags) {
        if (flags.get(0) && flags.get(2)) {
            return true;
        }
        if (flags.get(1) && flags.get(3)) {
            return true;
        }
        if (flags.get(1) && flags.get(2)) {
            return true;
        }
        return flags.get(2) && flags.get(3);
    }

    private boolean isStructureBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, MutableInt amount, BitSet flags) {
        if (b == 0 && c == 0 && (a == -1 || a == 0 || a == 1)) {
            return false;
        }
        if (a == 1 || a == -1) {
            return this.coilsNotPresent(aBaseMetaTileEntity, xDir + a, b, c + zDir);
        }
        if (a == 2 || a == -2) {
            return this.checkEndsBroken(xDir, zDir, a, b, c, aBaseMetaTileEntity, amount, flags);
        }
        if (a == 0) {
            return this.checkMiddleBroken(xDir, zDir, a, b, c, aBaseMetaTileEntity, amount);
        }
        return false;
    }

    private boolean checkEndsBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, MutableInt amount, BitSet flags) {
        IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + c, b, a + zDir);
        if (this.addInputToMachineList(tTileEntity, 49)) {
            if (a == -2) {
                flags.set(0);
            } else {
                flags.set(1);
            }
        } else if (this.addOutputToMachineList(tTileEntity, 49)) {
            if (a == -2) {
                flags.set(2);
            } else {
                flags.set(3);
            }
        } else if (!this.addEnergyInputToMachineList(tTileEntity, 49) && !this.addMaintenanceToMachineList(tTileEntity, 49)) {
            if (aBaseMetaTileEntity.getBlockOffset(xDir + c, b, a + zDir) != GregTech_API.sBlockCasings4) {
                return true;
            }
            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + c, b, a + zDir) != 1) {
                return true;
            }
            amount.increment();
        }
        return false;
    }

    private boolean checkMiddleBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, MutableInt amount) {
        IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + c, b, a + zDir);
        if (this.addMaintenanceToMachineList(tTileEntity, 49)) {
            return false;
        }
        if (this.addInputToMachineList(tTileEntity, 49)) {
            return false;
        }
        if (this.addEnergyInputToMachineList(tTileEntity, 49)) {
            return false;
        }
        if (xDir + c == 0 && b == 0 && a + zDir == 0) {
            return false;
        }
        if (aBaseMetaTileEntity.getBlockOffset(xDir + c, b, a + zDir) != GregTech_API.sBlockCasings4) {
            return true;
        }
        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + c, b, a + zDir) != 1) {
            return true;
        }
        amount.increment();
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OilCracker(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; xPos += xDir != 0 ? 1 : 2) {
            for (int yPos = tY - 1; yPos <= tY + 1; ++yPos) {
                for (int zPos = tZ - 1; zPos <= tZ + 1; zPos += xDir != 0 ? 2 : 1) {
                    byte tUsedMeta;
                    if (yPos == tY && (xPos == tX || zPos == tZ) || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, yPos, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, yPos, zPos) != GregTech_API.sBlockCasings1) continue;
                    aBaseMetaTileEntity.getWorld().func_147465_d(xPos, yPos, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
                }
            }
        }
    }

    @Override
    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_OilCracker.isValidMetaTileEntity(tHatch) || tHatch.getFillableStack() == null) continue;
            FluidStack tStack = tHatch.getFillableStack();
            if (tStack.isFluidEqual(GT_ModHandler.getSteam(1000L)) || tStack.isFluidEqual(Materials.Hydrogen.getGas(1000L))) {
                if (!this.isHatchInMiddleRing(tHatch)) continue;
                rList.add(tStack);
                continue;
            }
            if (this.isHatchInMiddleRing(tHatch)) continue;
            rList.add(tStack);
        }
        return rList;
    }

    private boolean isHatchInMiddleRing(GT_MetaTileEntity_Hatch_Input inputHatch) {
        if (this.orientation == ForgeDirection.NORTH || this.orientation == ForgeDirection.SOUTH) {
            return inputHatch.getBaseMetaTileEntity().getXCoord() == this.controllerX;
        }
        return inputHatch.getBaseMetaTileEntity().getZCoord() == this.controllerZ;
    }
}

