/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import cpw.mods.fml.common.Loader;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.Tier;
import gregtech.api.gui.GT_Container_BasicMachine;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import ic2.core.Ic2Items;
import java.util.Locale;
import java.util.Random;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GT_MetaTileEntity_BasicMachine_GT_Recipe
extends GT_MetaTileEntity_BasicMachine {
    private final GT_Recipe.GT_Recipe_Map mRecipes;
    private final int mTankCapacity;
    private final int mSpecialEffect;
    private final String mSound;
    private final boolean mSharedTank;
    private final boolean mRequiresFluidForFiltering;
    private final byte mGUIParameterA;
    private final byte mGUIParameterB;

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(int aID, String aName, String aNameRegional, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aGUIParameterA, int aGUIParameterB, String aGUIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect, String aOverlays, Object[] aRecipe) {
        super(aID, aName, aNameRegional, aTier, aRecipes.mAmperage, aDescription, aInputSlots, aOutputSlots, aGUIName, aRecipes.mNEIName, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_TOP_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/" + aOverlays.toLowerCase(Locale.ENGLISH) + "/OVERLAY_BOTTOM_GLOW")).glow().build()));
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSound = aSound;
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
        if (aRecipe != null) {
            for (int i = 3; i < aRecipe.length; ++i) {
                if (aRecipe[i] == X.CIRCUIT) {
                    aRecipe[i] = Tier.ELECTRIC[this.mTier].mManagingObject;
                    continue;
                }
                if (aRecipe[i] == X.BETTER_CIRCUIT) {
                    aRecipe[i] = Tier.ELECTRIC[this.mTier].mBetterManagingObject;
                    continue;
                }
                if (aRecipe[i] == X.HULL) {
                    aRecipe[i] = Tier.ELECTRIC[this.mTier].mHullObject;
                    continue;
                }
                if (aRecipe[i] == X.WIRE) {
                    aRecipe[i] = Tier.ELECTRIC[this.mTier].mConductingObject;
                    continue;
                }
                if (aRecipe[i] == X.WIRE4) {
                    aRecipe[i] = Tier.ELECTRIC[this.mTier].mLargerConductingObject;
                    continue;
                }
                if (aRecipe[i] == X.GLASS) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            aRecipe[i] = new ItemStack(Blocks.glass, 1, Short.MAX_VALUE);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            if (Loader.isModLoaded((String)"bartworks")) {
                                aRecipe[i] = "blockGlass" + GT_Values.VN[aTier];
                                break;
                            }
                        }
                        default: {
                            if (Loader.isModLoaded((String)"bartworks")) {
                                aRecipe[i] = "blockGlass" + GT_Values.VN[8];
                                break;
                            }
                            aRecipe[i] = Ic2Items.reinforcedGlass;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.PLATE) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.Steel);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.Aluminium);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.StainlessSteel);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.Titanium);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.TungstenSteel);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.HSSG);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.HSSE);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.plate.get(Materials.Neutronium);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.PIPE) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.Bronze);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.Steel);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.StainlessSteel);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.Titanium);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.TungstenSteel);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.pipeSmall.get(Materials.Ultimate);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.pipeMedium.get(Materials.Ultimate);
                            break;
                        }
                        case 8: {
                            aRecipe[i] = OrePrefixes.pipeLarge.get(Materials.Ultimate);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.pipeHuge.get(Materials.Ultimate);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.COIL_HEATING) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.Cupronickel);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.Kanthal);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.Nichrome);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.TungstenSteel);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.HSSG);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.Naquadah);
                            break;
                        }
                        case 8: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.NaquadahAlloy);
                            break;
                        }
                        case 9: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.COIL_HEATING_DOUBLE) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.Cupronickel);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.Kanthal);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.Nichrome);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.TungstenSteel);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.HSSG);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.Naquadah);
                            break;
                        }
                        case 8: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.NaquadahAlloy);
                            break;
                        }
                        case 9: {
                            aRecipe[i] = OrePrefixes.wireGt08.get(Materials.NaquadahAlloy);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.wireGt16.get(Materials.NaquadahAlloy);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.STICK_DISTILLATION) {
                    switch (this.mTier) {
                        default: 
                    }
                    aRecipe[i] = OrePrefixes.stick.get(Materials.Blaze);
                    continue;
                }
                if (aRecipe[i] == X.STICK_MAGNETIC) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.IronMagnetic);
                            break;
                        }
                        case 2: 
                        case 3: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.SteelMagnetic);
                            break;
                        }
                        case 4: 
                        case 5: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.NeodymiumMagnetic);
                            break;
                        }
                        case 6: 
                        case 7: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.SamariumMagnetic);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.stickLong.get(Materials.SamariumMagnetic);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.STICK_ELECTROMAGNETIC) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.AnyIron);
                            break;
                        }
                        case 2: 
                        case 3: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.Steel);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.Neodymium);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.stick.get(Materials.VanadiumGallium);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.COIL_ELECTRIC) {
                    switch (this.mTier) {
                        case 0: {
                            aRecipe[i] = OrePrefixes.wireGt01.get(Materials.Lead);
                            break;
                        }
                        case 1: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.Tin);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.wireGt02.get(Materials.AnyCopper);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.AnyCopper);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.wireGt08.get(Materials.AnnealedCopper);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.wireGt16.get(Materials.AnnealedCopper);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.wireGt04.get(Materials.YttriumBariumCuprate);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.wireGt08.get(Materials.Iridium);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.wireGt16.get(Materials.Osmium);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.ROBOT_ARM) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Robot_Arm_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Robot_Arm_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Robot_Arm_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Robot_Arm_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Robot_Arm_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Robot_Arm_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Robot_Arm_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Robot_Arm_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Robot_Arm_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Robot_Arm_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.PUMP) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Electric_Pump_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Electric_Pump_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Electric_Pump_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Electric_Pump_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Electric_Pump_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Electric_Pump_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Electric_Pump_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Electric_Pump_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Electric_Pump_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Electric_Pump_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.ROTOR) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Tin);
                            break;
                        }
                        case 2: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Bronze);
                            break;
                        }
                        case 3: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Steel);
                            break;
                        }
                        case 4: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.StainlessSteel);
                            break;
                        }
                        case 5: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.TungstenSteel);
                            break;
                        }
                        case 6: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Chrome);
                            break;
                        }
                        case 7: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Iridium);
                            break;
                        }
                        default: {
                            aRecipe[i] = OrePrefixes.rotor.get(Materials.Osmium);
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.MOTOR) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Electric_Motor_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Electric_Motor_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Electric_Motor_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Electric_Motor_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Electric_Motor_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Electric_Motor_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Electric_Motor_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Electric_Motor_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Electric_Motor_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Electric_Motor_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.PISTON) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Electric_Piston_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Electric_Piston_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Electric_Piston_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Electric_Piston_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Electric_Piston_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Electric_Piston_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Electric_Piston_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Electric_Piston_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Electric_Piston_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Electric_Piston_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.CONVEYOR) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Conveyor_Module_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Conveyor_Module_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Conveyor_Module_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Conveyor_Module_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Conveyor_Module_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Conveyor_Module_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Conveyor_Module_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Conveyor_Module_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Conveyor_Module_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Conveyor_Module_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.EMITTER) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Emitter_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Emitter_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Emitter_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Emitter_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Emitter_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Emitter_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Emitter_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Emitter_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Emitter_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Emitter_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.SENSOR) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Sensor_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Sensor_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Sensor_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Sensor_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Sensor_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Sensor_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Sensor_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Sensor_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Sensor_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Sensor_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (aRecipe[i] == X.FIELD_GENERATOR) {
                    switch (this.mTier) {
                        case 0: 
                        case 1: {
                            aRecipe[i] = ItemList.Field_Generator_LV;
                            break;
                        }
                        case 2: {
                            aRecipe[i] = ItemList.Field_Generator_MV;
                            break;
                        }
                        case 3: {
                            aRecipe[i] = ItemList.Field_Generator_HV;
                            break;
                        }
                        case 4: {
                            aRecipe[i] = ItemList.Field_Generator_EV;
                            break;
                        }
                        case 5: {
                            aRecipe[i] = ItemList.Field_Generator_IV;
                            break;
                        }
                        case 6: {
                            aRecipe[i] = ItemList.Field_Generator_LuV;
                            break;
                        }
                        case 7: {
                            aRecipe[i] = ItemList.Field_Generator_ZPM;
                            break;
                        }
                        case 8: {
                            aRecipe[i] = ItemList.Field_Generator_UV;
                            break;
                        }
                        case 9: {
                            aRecipe[i] = ItemList.Field_Generator_UHV;
                            break;
                        }
                        default: {
                            aRecipe[i] = ItemList.Field_Generator_UEV;
                            break;
                        }
                    }
                    continue;
                }
                if (!(aRecipe[i] instanceof X)) continue;
                throw new IllegalArgumentException("MISSING TIER MAPPING FOR: " + aRecipe[i] + " AT TIER " + this.mTier);
            }
            if (!GT_ModHandler.addCraftingRecipe(this.getStackForm(1L), GT_ModHandler.RecipeBits.DISMANTLEABLE | GT_ModHandler.RecipeBits.BUFFERED | GT_ModHandler.RecipeBits.NOT_REMOVABLE | GT_ModHandler.RecipeBits.REVERSIBLE, aRecipe)) {
                throw new IllegalArgumentException("INVALID CRAFTING RECIPE FOR: " + this.getStackForm(1L).getDisplayName());
            }
        }
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(String aName, int aTier, String aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aAmperage, int aGUIParameterA, int aGUIParameterB, ITexture[][][] aTextures, String aGUIName, String aNEIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect) {
        super(aName, aTier, aAmperage, aDescription, aTextures, aInputSlots, aOutputSlots, aGUIName, aNEIName);
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSound = aSound;
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
    }

    public GT_MetaTileEntity_BasicMachine_GT_Recipe(String aName, int aTier, String[] aDescription, GT_Recipe.GT_Recipe_Map aRecipes, int aInputSlots, int aOutputSlots, int aTankCapacity, int aAmperage, int aGUIParameterA, int aGUIParameterB, ITexture[][][] aTextures, String aGUIName, String aNEIName, String aSound, boolean aSharedTank, boolean aRequiresFluidForFiltering, int aSpecialEffect) {
        super(aName, aTier, aAmperage, aDescription, aTextures, aInputSlots, aOutputSlots, aGUIName, aNEIName);
        this.mSharedTank = aSharedTank;
        this.mTankCapacity = aTankCapacity;
        this.mSpecialEffect = aSpecialEffect;
        this.mRequiresFluidForFiltering = aRequiresFluidForFiltering;
        this.mRecipes = aRecipes;
        this.mSound = aSound;
        this.mGUIParameterA = (byte)aGUIParameterA;
        this.mGUIParameterB = (byte)aGUIParameterB;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_BasicMachine_GT_Recipe(this.mName, (int)this.mTier, this.mDescriptionArray, this.mRecipes, this.mInputSlotCount, this.mOutputItems == null ? 0 : this.mOutputItems.length, this.mTankCapacity, this.mAmperage, (int)this.mGUIParameterA, (int)this.mGUIParameterB, this.mTextures, this.mGUIName, this.mNEIName, this.mSound, this.mSharedTank, this.mRequiresFluidForFiltering, this.mSpecialEffect);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), this.mGUIName, GT_Utility.isStringValid(this.mNEIName) ? this.mNEIName : (this.getRecipeList() != null ? this.getRecipeList().mUnlocalizedName : ""), this.mGUIParameterA, this.mGUIParameterB);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (!super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, aSide, aStack)) {
            return false;
        }
        switch (this.mInputSlotCount) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.getFillableStack() == null) {
                    if (this.mRequiresFluidForFiltering) return false;
                    if (!this.getRecipeList().containsInput(aStack)) return false;
                    return true;
                }
                if (this.getRecipeList().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, true, GT_Values.V[this.mTier], new FluidStack[]{this.getFillableStack()}, this.getSpecialSlot(), new ItemStack[]{aStack}) == null) return false;
                return true;
            }
            case 2: {
                if (this.mRequiresFluidForFiltering) {
                    if (this.getFillableStack() == null) return false;
                }
                if (this.getInputAt(0) != null) {
                    if (this.getInputAt(1) != null) return true;
                }
                if (this.getInputAt(0) == null && this.getInputAt(1) == null) {
                    if (!this.getRecipeList().containsInput(aStack)) return false;
                    return true;
                } else {
                    ItemStack[] itemStackArray;
                    if (!this.getRecipeList().containsInput(aStack)) return false;
                    GT_Recipe.GT_Recipe_Map gT_Recipe_Map = this.getRecipeList();
                    IGregTechTileEntity iGregTechTileEntity = this.getBaseMetaTileEntity();
                    long l = GT_Values.V[this.mTier];
                    FluidStack[] fluidStackArray = new FluidStack[]{this.getFillableStack()};
                    ItemStack itemStack = this.getSpecialSlot();
                    if (aIndex == this.getInputSlot()) {
                        ItemStack[] itemStackArray2 = new ItemStack[2];
                        itemStackArray2[0] = aStack;
                        itemStackArray = itemStackArray2;
                        itemStackArray2[1] = this.getInputAt(1);
                    } else {
                        ItemStack[] itemStackArray3 = new ItemStack[2];
                        itemStackArray3[0] = this.getInputAt(0);
                        itemStackArray = itemStackArray3;
                        itemStackArray3[1] = aStack;
                    }
                    if (gT_Recipe_Map.findRecipe((IHasWorldObjectAndCoords)iGregTechTileEntity, this.mLastRecipe, true, l, fluidStackArray, itemStack, itemStackArray) == null) return false;
                }
                return true;
            }
        }
        int tID = this.getBaseMetaTileEntity().getMetaTileID();
        if (!(tID >= 211 && tID <= 218 || tID >= 1180 && tID <= 1187)) {
            if (tID < 10780) return this.getRecipeList().containsInput(aStack);
            if (tID > 10786) return this.getRecipeList().containsInput(aStack);
        }
        if (!GT_Utility.isStackValid(aStack)) return this.getRecipeList().containsInput(aStack);
        int[] nArray = OreDictionary.getOreIDs((ItemStack)aStack);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int oreID = nArray[n2];
            if (OreDictionary.getOreName((int)oreID).contains("circuit")) {
                return true;
            }
            ++n2;
        }
        return this.getRecipeList().containsInput(aStack);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            switch (this.mSpecialEffect) {
                case 0: {
                    break;
                }
                case 1: {
                    if (aBaseMetaTileEntity.getFrontFacing() == 1 || aBaseMetaTileEntity.getCoverIDAtSide((byte)1) != 0 || aBaseMetaTileEntity.getOpacityAtSide((byte)1)) break;
                    Random tRandom = aBaseMetaTileEntity.getWorld().rand;
                    new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.0, 0.0).setIdentifier("smoke").setPosition((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f, (float)aBaseMetaTileEntity.getYCoord() + 0.9f + tRandom.nextFloat() * 0.2f, (float)aBaseMetaTileEntity.getZCoord() + 0.8f - tRandom.nextFloat() * 0.6f).setWorld(aBaseMetaTileEntity.getWorld()).run();
                }
            }
        }
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return this.mRecipes;
    }

    @Override
    public int getCapacity() {
        return this.mTankCapacity;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1 && GT_Utility.isStringValid(this.mSound)) {
            GT_Utility.doSoundAtClient(this.mSound, 100, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public void startProcess() {
        BaseMetaTileEntity myMetaTileEntity = (BaseMetaTileEntity)this.getBaseMetaTileEntity();
        if (myMetaTileEntity.mTickTimer > myMetaTileEntity.mLastSoundTick + (long)GT_Values.ticksBetweenSounds) {
            if (GT_Utility.isStringValid(this.mSound)) {
                this.sendLoopStart((byte)1);
            }
            myMetaTileEntity.mLastSoundTick = myMetaTileEntity.mTickTimer;
        }
    }

    @Override
    public FluidStack getFillableStack() {
        return this.mSharedTank ? this.getDrainableStack() : super.getFillableStack();
    }

    @Override
    public FluidStack setFillableStack(FluidStack aFluid) {
        return this.mSharedTank ? this.setDrainableStack(aFluid) : super.setFillableStack(aFluid);
    }

    @Override
    protected boolean displaysOutputFluid() {
        return !this.mSharedTank;
    }

    public static enum X {
        PUMP,
        WIRE,
        WIRE4,
        HULL,
        PIPE,
        GLASS,
        PLATE,
        MOTOR,
        ROTOR,
        SENSOR,
        PISTON,
        CIRCUIT,
        EMITTER,
        CONVEYOR,
        ROBOT_ARM,
        COIL_HEATING,
        COIL_ELECTRIC,
        STICK_MAGNETIC,
        STICK_DISTILLATION,
        BETTER_CIRCUIT,
        FIELD_GENERATOR,
        COIL_HEATING_DOUBLE,
        STICK_ELECTROMAGNETIC;

    }
}

