/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Hatch_Output
extends GT_MetaTileEntity_Hatch {
    private String lockedFluidName = null;
    private EntityPlayer playerThatLockedfluid = null;
    public byte mMode = 0;

    public GT_MetaTileEntity_Hatch_Output(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"Fluid Output for Multiblocks", "Capacity: " + GT_Utility.formatNumbers(8000 + 8000 * (aTier * (aTier + 1) >> 1)) + "L", "Right click with screwdriver to restrict output", "Can be restricted to put out Items and/or Steam/No Steam/1 specific Fluid", "Restricted Output Hatches are given priority for Multiblock Fluid output"}, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_Output(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_Output(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        return false;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Output(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IFluidHandler tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (aTick & 7L) == 0L && (tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            boolean temp = true;
            while (temp && this.mFluid != null) {
                int tFilledAmount;
                temp = false;
                FluidStack tDrained = aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()), Math.max(1, this.mFluid.amount), false);
                if (tDrained == null || (tFilledAmount = tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false)) <= 0) continue;
                temp = true;
                tTileEntity.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), aBaseMetaTileEntity.drain(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getFrontFacing()), tFilledAmount, true), true);
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.setByte("mMode", this.mMode);
        if (this.lockedFluidName != null && this.lockedFluidName.length() != 0) {
            aNBT.setString("lockedFluidName", this.lockedFluidName);
        } else {
            aNBT.removeTag("lockedFluidName");
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mMode = aNBT.getByte("mMode");
        this.lockedFluidName = aNBT.getString("lockedFluidName");
        this.lockedFluidName = this.lockedFluidName.length() == 0 ? null : this.lockedFluidName;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return true;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0;
    }

    @Override
    public int getCapacity() {
        return 8000 + 8000 * (this.mTier * (this.mTier + 1) >> 1);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return;
        }
        this.mMode = aPlayer.isSneaking() ? (byte)((this.mMode + 9) % 10) : (byte)((this.mMode + 1) % 10);
        switch (this.mMode) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("108", "Outputs misc. Fluids, Steam and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("109", "Outputs Steam and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("110", "Outputs Steam and misc. Fluids"));
                this.setLockedFluidName(null);
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("111", "Outputs Steam"));
                this.setLockedFluidName(null);
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("112", "Outputs misc. Fluids and Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("113", "Outputs only Items"));
                this.setLockedFluidName(null);
                break;
            }
            case 6: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("114", "Outputs only misc. Fluids"));
                this.setLockedFluidName(null);
                break;
            }
            case 7: {
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("115", "Outputs nothing"));
                this.setLockedFluidName(null);
                break;
            }
            case 8: {
                String inBrackets;
                this.playerThatLockedfluid = aPlayer;
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = this.trans("115.3", "currently none, will be locked to the next that is put in (or use fluid cell to lock)");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getUnlocalizedName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", this.trans("151.1", "Outputs items and 1 specific Fluid"), inBrackets));
                break;
            }
            case 9: {
                String inBrackets;
                this.playerThatLockedfluid = aPlayer;
                if (this.mFluid == null) {
                    this.setLockedFluidName(null);
                    inBrackets = this.trans("115.3", "currently none, will be locked to the next that is put in (or use fluid cell to lock)");
                } else {
                    this.setLockedFluidName(this.getDrainableStack().getUnlocalizedName());
                    inBrackets = this.getDrainableStack().getLocalizedName();
                }
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", this.trans("151.2", "Outputs 1 specific Fluid"), inBrackets));
            }
        }
    }

    private boolean tryToLockHatch(EntityPlayer aPlayer, byte aSide) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getBaseMetaTileEntity().getCoverIDAtSide(aSide), this.getBaseMetaTileEntity().getCoverDataAtSide(aSide), this.getBaseMetaTileEntity())) {
            return false;
        }
        if (!this.isFluidLocked()) {
            return false;
        }
        ItemStack tCurrentItem = aPlayer.inventory.getCurrentItem();
        if (tCurrentItem == null) {
            return false;
        }
        FluidStack tFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)tCurrentItem);
        if (tFluid == null && tCurrentItem.getItem() instanceof IFluidContainerItem) {
            tFluid = ((IFluidContainerItem)tCurrentItem.getItem()).getFluid(tCurrentItem);
        }
        if (tFluid != null) {
            if (this.getLockedFluidName() != null && !this.getLockedFluidName().equals(tFluid.getUnlocalizedName())) {
                GT_Utility.sendChatToPlayer(aPlayer, String.format("%s %s", this.trans("151.3", "Hatch is locked to a different fluid. To change the locking, empty it and made it locked to the next fluid with a screwdriver. Currently locked to"), StatCollector.translateToLocal((String)this.getLockedFluidName())));
            } else {
                this.setLockedFluidName(tFluid.getUnlocalizedName());
                if (this.mMode == 8) {
                    GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", this.trans("151.1", "Outputs items and 1 specific Fluid"), tFluid.getLocalizedName()));
                } else {
                    GT_Utility.sendChatToPlayer(aPlayer, String.format("%s (%s)", this.trans("151.2", "Outputs 1 specific Fluid"), tFluid.getLocalizedName()));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.tryToLockHatch(aPlayer, aSide)) {
            return true;
        }
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
    }

    @Override
    public String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public boolean outputsSteam() {
        return this.mMode < 4;
    }

    public boolean outputsLiquids() {
        return this.mMode % 2 == 0 || this.mMode == 9;
    }

    public boolean outputsItems() {
        return this.mMode % 4 < 2 && this.mMode != 9;
    }

    public boolean isFluidLocked() {
        return this.mMode == 8 || this.mMode == 9;
    }

    public String getLockedFluidName() {
        return this.lockedFluidName;
    }

    public void setLockedFluidName(String lockedFluidName) {
        this.lockedFluidName = lockedFluidName;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    protected void onEmptyingContainerWhenEmpty() {
        if (this.lockedFluidName == null && this.mFluid != null) {
            this.setLockedFluidName(this.mFluid.getUnlocalizedName());
            GT_Utility.sendChatToPlayer(this.playerThatLockedfluid, String.format(this.trans("151.4", "Sucessfully locked Fluid to %s"), this.mFluid.getLocalizedName()));
        }
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + "Output Hatch" + EnumChatFormatting.RESET, "Stored Fluid:", EnumChatFormatting.GOLD + (this.mFluid == null ? "No Fluid" : this.mFluid.getLocalizedName()) + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mFluid == null ? 0L : (long)this.mFluid.amount) + " L" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getCapacity()) + " L" + EnumChatFormatting.RESET, this.lockedFluidName == null ? "Not Locked" : "Locked to " + StatCollector.translateToLocal((String)this.getLockedFluidName())};
    }
}

