/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_1by1;
import gregtech.api.gui.GT_Container_2by2;
import gregtech.api.gui.GT_Container_3by3;
import gregtech.api.gui.GT_Container_4by4;
import gregtech.api.gui.GT_GUIContainer_1by1;
import gregtech.api.gui.GT_GUIContainer_2by2;
import gregtech.api.gui.GT_GUIContainer_3by3;
import gregtech.api.gui.GT_GUIContainer_4by4;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.extensions.ArrayExt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_Hatch_OutputBus
extends GT_MetaTileEntity_Hatch {
    public GT_MetaTileEntity_Hatch_OutputBus(int aID, String aName, String aNameRegional, int aTier) {
        this(aID, aName, aNameRegional, aTier, GT_MetaTileEntity_Hatch_OutputBus.getSlots(aTier));
    }

    public GT_MetaTileEntity_Hatch_OutputBus(int id, String name, String nameRegional, int tier, int slots) {
        super(id, name, nameRegional, tier, slots, ArrayExt.of("Item Output for Multiblocks", "Capacity: " + GT_MetaTileEntity_Hatch_OutputBus.getSlots(tier) + " stack" + (GT_MetaTileEntity_Hatch_OutputBus.getSlots(tier) >= 2 ? "s" : "")), new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_OutputBus(int aID, String aName, String aNameRegional, int aTier, String[] aDescription) {
        super(aID, aName, aNameRegional, aTier, GT_MetaTileEntity_Hatch_OutputBus.getSlots(aTier), aDescription, new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_OutputBus(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, int inventorySize) {
        super(aID, aName, aNameRegional, aTier, inventorySize, aDescription, new ITexture[0]);
    }

    @Deprecated
    public GT_MetaTileEntity_Hatch_OutputBus(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        this(aName, aTier, GT_MetaTileEntity_Hatch_OutputBus.getSlots(aTier), ArrayExt.of(aDescription), aTextures);
    }

    public GT_MetaTileEntity_Hatch_OutputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, GT_MetaTileEntity_Hatch_OutputBus.getSlots(aTier), aDescription, aTextures);
    }

    public GT_MetaTileEntity_Hatch_OutputBus(String name, int tier, int slots, String[] description, ITexture[][][] textures) {
        super(name, tier, slots, description, textures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_OutputBus(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mTier) {
            case 0: {
                return new GT_Container_1by1(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 1: {
                return new GT_Container_2by2(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 2: {
                return new GT_Container_3by3(aPlayerInventory, aBaseMetaTileEntity);
            }
        }
        return new GT_Container_4by4(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mTier) {
            case 0: {
                return new GT_GUIContainer_1by1(aPlayerInventory, aBaseMetaTileEntity, "Output Bus");
            }
            case 1: {
                return new GT_GUIContainer_2by2(aPlayerInventory, aBaseMetaTileEntity, "Output Bus");
            }
            case 2: {
                return new GT_GUIContainer_3by3(aPlayerInventory, aBaseMetaTileEntity, "Output Bus");
            }
        }
        return new GT_GUIContainer_4by4(aPlayerInventory, aBaseMetaTileEntity, "Output Bus");
    }

    public boolean storeAll(ItemStack aStack) {
        int mInventoryLength = this.mInventory.length;
        for (int i = 0; i < mInventoryLength && aStack.stackSize > 0; ++i) {
            ItemStack tSlot = this.mInventory[i];
            if (GT_Utility.isStackInvalid(tSlot)) {
                if (aStack.stackSize <= this.getInventoryStackLimit()) {
                    this.mInventory[i] = aStack;
                    return true;
                }
                this.mInventory[i] = aStack.splitStack(this.getInventoryStackLimit());
                continue;
            }
            int tRealStackLimit = Math.min(this.getInventoryStackLimit(), tSlot.getMaxStackSize());
            if (tSlot.stackSize >= tRealStackLimit || !tSlot.isItemEqual(aStack) || !ItemStack.areItemStackTagsEqual((ItemStack)tSlot, (ItemStack)aStack)) continue;
            if (aStack.stackSize + tSlot.stackSize <= tRealStackLimit) {
                this.mInventory[i].stackSize += aStack.stackSize;
                return true;
            }
            aStack.stackSize -= tRealStackLimit - tSlot.stackSize;
            this.mInventory[i].stackSize = tRealStackLimit;
        }
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        IInventory tTileEntity;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && (aTick & 7L) == 0L && (tTileEntity = aBaseMetaTileEntity.getIInventoryAtSide(aBaseMetaTileEntity.getFrontFacing())) != null) {
            GT_Utility.moveMultipleItemStacks(aBaseMetaTileEntity, tTileEntity, aBaseMetaTileEntity.getFrontFacing(), aBaseMetaTileEntity.getBackFacing(), null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mInventory.length);
            for (int i = 0; i < this.mInventory.length; ++i) {
                if (this.mInventory[i] == null || this.mInventory[i].stackSize > 0) continue;
                this.mInventory[i] = null;
            }
        }
    }
}

