/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IDamagableItem;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.internal.IGT_CraftingRecipe;
import gregtech.api.objects.GT_HashSet;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_Config;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Shaped_Recipe;
import gregtech.api.util.GT_Shapeless_Recipe;
import gregtech.api.util.GT_Utility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IC2Items;
import ic2.api.item.IElectricItem;
import ic2.api.item.ItemWrapper;
import ic2.api.reactor.IReactorComponent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.core.AdvRecipe;
import ic2.core.AdvShapelessRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCloning;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesArmorDyes;
import net.minecraft.item.crafting.RecipesMapCloning;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class GT_ModHandler {
    public static final List<IRecipe> sSingleNonBlockDamagableRecipeList = new ArrayList<IRecipe>(1000);
    private static final Map<String, ItemStack> sIC2ItemMap = new HashMap<String, ItemStack>();
    private static final List<IRecipe> sAllRecipeList = new ArrayList<IRecipe>(5000);
    private static final List<IRecipe> sBufferRecipeList = new ArrayList<IRecipe>(1000);
    private static final List<ItemStack> delayedRemovalByOutput = new ArrayList<ItemStack>();
    private static final List<InventoryCrafting> delayedRemovalByRecipe = new ArrayList<InventoryCrafting>();
    public static volatile int VERSION = 509;
    public static Collection<String> sNativeRecipeClasses = new HashSet<String>();
    public static Collection<String> sSpecialRecipeClasses = new HashSet<String>();
    public static GT_HashSet<GT_ItemStack> sNonReplaceableItems = new GT_HashSet();
    public static Object sBoxableWrapper = GT_Utility.callConstructor("gregtechmod.api.util.GT_IBoxableWrapper", 0, null, false, new Object[0]);
    private static final Map<IRecipeInput, RecipeOutput> sExtractorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sMaceratorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sCompressorRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sOreWashingRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sThermalCentrifugeRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static final Map<IRecipeInput, RecipeOutput> sMassfabRecipes = new HashMap<IRecipeInput, RecipeOutput>();
    private static boolean sBufferCraftingRecipes = true;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_list = new ArrayList<Integer>(100);
    private static final boolean sSingleNonBlockDamagableRecipeList_create = true;
    private static final ItemStack sMt1 = new ItemStack(Blocks.dirt, 1, 0);
    private static final ItemStack sMt2 = new ItemStack(Blocks.dirt, 1, 0);
    private static final String s_H = "h";
    private static final String s_F = "f";
    private static final String s_I = "I";
    private static final String s_P = "P";
    private static final String s_R = "R";
    private static final ItemStack[][] sShapes1 = new ItemStack[][]{{sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1, null}, {sMt1, null, sMt1, sMt1, null, sMt1, sMt1, sMt1, sMt1}, {null, sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1}, {sMt1, sMt1, sMt1, sMt1, null, sMt1, null, null, null}, {sMt1, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1}, {sMt1, sMt1, sMt1, sMt1, null, sMt1, sMt1, null, sMt1}, {null, null, null, sMt1, null, sMt1, sMt1, null, sMt1}, {null, sMt1, null, null, sMt1, null, null, sMt2, null}, {sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2, null}, {null, sMt1, null, null, sMt2, null, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt2, null, null, sMt2, null}, {null, sMt1, sMt1, null, sMt2, sMt1, null, sMt2, null}, {sMt1, sMt1, null, null, sMt2, null, null, sMt2, null}, {null, sMt1, sMt1, null, sMt2, null, null, sMt2, null}, {null, sMt1, null, sMt1, null, null, null, sMt1, sMt2}, {null, sMt1, null, null, null, sMt1, sMt2, sMt1, null}, {null, sMt1, null, sMt1, null, sMt1, null, null, sMt2}, {null, sMt1, null, sMt1, null, sMt1, sMt2, null, null}, {null, sMt2, null, null, sMt1, null, null, sMt1, null}, {null, sMt2, null, null, sMt2, null, sMt1, sMt1, sMt1}, {null, sMt2, null, null, sMt2, null, null, sMt1, null}, {null, sMt2, null, sMt1, sMt2, null, sMt1, sMt1, null}, {null, sMt2, null, null, sMt2, sMt1, null, sMt1, sMt1}, {null, sMt2, null, null, sMt2, null, sMt1, sMt1, null}, {sMt1, null, null, null, sMt2, null, null, null, sMt2}, {null, null, sMt1, null, sMt2, null, sMt2, null, null}, {sMt1, null, null, null, sMt2, null, null, null, null}, {null, null, sMt1, null, sMt2, null, null, null, null}, {sMt1, sMt2, null, null, null, null, null, null, null}, {sMt2, sMt1, null, null, null, null, null, null, null}, {sMt1, null, null, sMt2, null, null, null, null, null}, {sMt2, null, null, sMt1, null, null, null, null, null}, {sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt1, sMt2, sMt1, sMt1, null}, {null, sMt1, sMt1, sMt2, sMt1, sMt1, null, sMt1, sMt1}, {null, sMt2, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1}, {sMt1, sMt1, sMt1, sMt1, sMt2, sMt1, null, sMt2, null}, {sMt1, sMt1, null, sMt1, sMt2, sMt2, sMt1, sMt1, null}, {null, sMt1, sMt1, sMt2, sMt2, sMt1, null, sMt1, sMt1}, {null, sMt2, null, sMt1, sMt2, sMt1, sMt1, sMt1, sMt1}, {sMt1, null, null, null, sMt1, null, null, null, null}, {null, sMt1, null, sMt1, null, null, null, null, null}, {sMt1, sMt1, null, sMt2, null, sMt1, sMt2, null, null}, {null, sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2}};
    public static List<Integer> sSingleNonBlockDamagableRecipeList_validsShapes1 = new ArrayList<Integer>(44);
    public static boolean sSingleNonBlockDamagableRecipeList_validsShapes1_update = false;
    public static List<Integer> sSingleNonBlockDamagableRecipeList_warntOutput = new ArrayList<Integer>(50);
    public static List<Integer> sVanillaRecipeList_warntOutput = new ArrayList<Integer>(50);
    public static final List<IRecipe> sSingleNonBlockDamagableRecipeList_verified = new ArrayList<IRecipe>(1000);
    private static final Cache<GT_ItemStack, ItemStack> sSmeltingRecipeCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
    public static List<Integer> sAnySteamFluidIDs = new ArrayList<Integer>();
    public static List<Integer> sSuperHeatedSteamFluidIDs = new ArrayList<Integer>();
    private static List<IRecipe> bufferedRecipes;

    public static boolean isWater(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getWater(1L)) || aFluid.isFluidEqual(GT_ModHandler.getDistilledWater(1L));
    }

    public static FluidStack getWater(long aAmount) {
        return FluidRegistry.getFluidStack((String)"water", (int)((int)aAmount));
    }

    public static FluidStack getDistilledWater(long aAmount) {
        FluidStack tFluid = FluidRegistry.getFluidStack((String)"ic2distilledwater", (int)((int)aAmount));
        if (tFluid == null) {
            tFluid = GT_ModHandler.getWater(aAmount);
        }
        return tFluid;
    }

    public static boolean isLava(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getLava(1L));
    }

    public static FluidStack getLava(long aAmount) {
        return FluidRegistry.getFluidStack((String)"lava", (int)((int)aAmount));
    }

    public static boolean isSteam(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getSteam(1L));
    }

    public static boolean isAnySteam(FluidStack aFluid) {
        return aFluid != null && (GT_ModHandler.isSteam(aFluid) || sAnySteamFluidIDs.contains(aFluid.getFluidID()));
    }

    public static boolean isSuperHeatedSteam(FluidStack aFluid) {
        return aFluid != null && sSuperHeatedSteamFluidIDs.contains(aFluid.getFluidID());
    }

    public static FluidStack getSteam(long aAmount) {
        return FluidRegistry.getFluidStack((String)"steam", (int)((int)aAmount));
    }

    public static boolean isMilk(FluidStack aFluid) {
        if (aFluid == null) {
            return false;
        }
        return aFluid.isFluidEqual(GT_ModHandler.getMilk(1L));
    }

    public static FluidStack getMilk(long aAmount) {
        return FluidRegistry.getFluidStack((String)"milk", (int)((int)aAmount));
    }

    public static ItemStack getEmptyFuelCan(long aAmount) {
        return ItemList.IC2_Fuel_Can_Empty.get(aAmount, new Object[0]);
    }

    public static ItemStack getEmptyCell(long aAmount) {
        return ItemList.Cell_Empty.get(aAmount, new Object[0]);
    }

    public static ItemStack getAirCell(long aAmount) {
        return ItemList.Cell_Air.get(aAmount, new Object[0]);
    }

    public static ItemStack getWaterCell(long aAmount) {
        return ItemList.Cell_Water.get(aAmount, new Object[0]);
    }

    public static ItemStack getLavaCell(long aAmount) {
        return ItemList.Cell_Lava.get(aAmount, new Object[0]);
    }

    public static ItemStack setFuelValue(ItemStack aStack, short aValue) {
        aStack.setTagCompound(GT_Utility.getNBTContainingShort(aStack.getTagCompound(), "GT.ItemFuelValue", aValue));
        return aStack;
    }

    public static int getFuelValue(ItemStack aStack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)aStack);
    }

    public static ItemStack getFuelCan(int aValue) {
        if (aValue < 5) {
            return ItemList.IC2_Fuel_Can_Empty.get(1L, new Object[0]);
        }
        ItemStack rFuelCanStack = ItemList.IC2_Fuel_Can_Filled.get(1L, new Object[0]);
        if (rFuelCanStack == null) {
            return null;
        }
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.setInteger("value", aValue / 5);
        rFuelCanStack.setTagCompound(tNBT);
        return rFuelCanStack;
    }

    public static int getFuelCanValue(ItemStack aFuelCan) {
        if (GT_Utility.isStackInvalid(aFuelCan) || !ItemList.IC2_Fuel_Can_Filled.isStackEqual(aFuelCan, false, true)) {
            return 0;
        }
        NBTTagCompound tNBT = aFuelCan.getTagCompound();
        return tNBT == null ? 0 : tNBT.getInteger("value") * 5;
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, ItemStack aReplacement) {
        if (GT_Utility.isStringInvalid(aItem) || !GregTech_API.sPreloadStarted) {
            return null;
        }
        if (!sIC2ItemMap.containsKey(aItem)) {
            try {
                ItemStack tStack = IC2Items.getItem((String)aItem);
                sIC2ItemMap.put(aItem, tStack);
                if (tStack == null && GT_Values.D1) {
                    GT_Log.err.println(aItem + " is not found in the IC2 Items!");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return GT_Utility.copyAmount(aAmount, sIC2ItemMap.get(aItem), aReplacement);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GT_ModHandler.getIC2Item(aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.feather.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getIC2Item(String aItem, long aAmount, int aMeta) {
        return GT_ModHandler.getIC2Item(aItem, aAmount, aMeta, null);
    }

    public static ItemStack getIC2Item(String aItem, long aAmount) {
        return GT_ModHandler.getIC2Item(aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount) {
        return GT_ModHandler.getModItem(aModID, aItem, aAmount, null);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, ItemStack aReplacement) {
        if (GT_Utility.isStringInvalid(aItem) || !GregTech_API.sPreloadStarted) {
            return null;
        }
        return GT_Utility.copyAmount(aAmount, GameRegistry.findItemStack((String)aModID, (String)aItem, (int)((int)aAmount)), aReplacement);
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta) {
        ItemStack rStack = GT_ModHandler.getModItem(aModID, aItem, aAmount);
        if (rStack == null) {
            return null;
        }
        Items.feather.setDamage(rStack, aMeta);
        return rStack;
    }

    public static ItemStack getModItem(String aModID, String aItem, long aAmount, int aMeta, ItemStack aReplacement) {
        ItemStack rStack = GT_ModHandler.getModItem(aModID, aItem, aAmount, aReplacement);
        if (rStack == null) {
            return null;
        }
        Items.feather.setDamage(rStack, aMeta);
        return rStack;
    }

    public static boolean getModeKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean getBoostKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean getJumpKeyDown(EntityPlayer aPlayer) {
        return false;
    }

    public static boolean addValuableOre(Block aBlock, int aMeta, int aValue) {
        if (aValue <= 0) {
            return false;
        }
        try {
            Class.forName("ic2.core.IC2").getMethod("addValuableOre", IRecipeInput.class, Integer.TYPE).invoke(null, new RecipeInputItemStack(new ItemStack(aBlock, 1, aMeta)), aValue);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addScrapboxDrop(float aChance, ItemStack aOutput) {
        if ((aOutput = GT_OreDictUnificator.get(true, aOutput)) == null || aChance <= 0.0f) {
            return false;
        }
        aOutput.stackSize = 1;
        if (GT_Config.troll && !GT_Utility.areStacksEqual(aOutput, new ItemStack(Items.wooden_hoe, 1, 0))) {
            return false;
        }
        if ((aChance = (float)GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.scrapboxdrops, aOutput, (double)aChance)) <= 0.0f) {
            return false;
        }
        try {
            GT_Utility.callMethod(GT_Utility.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "addDrop", true, false, true, GT_Utility.copyOrNull(aOutput), Float.valueOf(aChance));
            GT_Utility.callMethod(GT_Utility.getFieldContent("ic2.api.recipe.Recipes", "scrapboxDrops", true, true), "addRecipe", true, true, false, GT_Utility.copyOrNull(aOutput), Float.valueOf(aChance));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addToRecyclerBlackList(ItemStack aRecycledStack) {
        if (aRecycledStack == null) {
            return false;
        }
        try {
            Recipes.recyclerBlacklist.add((IRecipeInput)new RecipeInputItemStack(aRecycledStack));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null || GT_Utility.getContainerItem(aInput, false) != null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.smelting, aInput, true)) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(aInput, GT_Utility.copyOrNull(aOutput), 0.0f);
        return true;
    }

    public static boolean addSmeltingAndAlloySmeltingRecipe(ItemStack aInput, ItemStack aOutput, boolean hidden) {
        if (aInput == null || aOutput == null) {
            return false;
        }
        boolean temp = false;
        if (aInput.stackSize == 1 && GT_ModHandler.addSmeltingRecipe(aInput, aOutput)) {
            temp = true;
        }
        if (GT_Values.RA.addAlloySmelterRecipe(aInput, (ItemStack)(OrePrefixes.ingot.contains(aOutput) ? ItemList.Shape_Mold_Ingot.get(0L, new Object[0]) : (OrePrefixes.block.contains(aOutput) ? ItemList.Shape_Mold_Block.get(0L, new Object[0]) : (OrePrefixes.nugget.contains(aOutput) ? ItemList.Shape_Mold_Nugget.get(0L, new Object[0]) : null))), aOutput, 130, 3, hidden)) {
            temp = true;
        }
        if (GT_Mod.gregtechproxy.mTEMachineRecipes && GT_ModHandler.addInductionSmelterRecipe(aInput, null, aOutput, null, aOutput.stackSize * 1600, 0)) {
            temp = true;
        }
        return temp;
    }

    public static boolean addLiquidTransposerRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        aFullContainer = GT_OreDictUnificator.get(true, aFullContainer);
        if (aEmptyContainer == null || aFullContainer == null || aLiquid == null) {
            return false;
        }
        if (!GT_Mod.gregtechproxy.mTEMachineRecipes && !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.liquidtransposer, aFullContainer, true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerFill(aMJ * 10, aEmptyContainer, aFullContainer, aLiquid, true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addLiquidTransposerFillRecipe(ItemStack aEmptyContainer, FluidStack aLiquid, ItemStack aFullContainer, int aMJ) {
        aFullContainer = GT_OreDictUnificator.get(true, aFullContainer);
        if (aEmptyContainer == null || aFullContainer == null || aLiquid == null) {
            return false;
        }
        if (!GT_Mod.gregtechproxy.mTEMachineRecipes && !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.liquidtransposerfilling, aFullContainer, true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerFill(aMJ * 10, aEmptyContainer, aFullContainer, aLiquid, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addLiquidTransposerEmptyRecipe(ItemStack aFullContainer, FluidStack aLiquid, ItemStack aEmptyContainer, int aMJ) {
        aEmptyContainer = GT_OreDictUnificator.get(true, aEmptyContainer);
        if (aFullContainer == null || aEmptyContainer == null || aLiquid == null) {
            return false;
        }
        if (!GT_Mod.gregtechproxy.mTEMachineRecipes && !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.liquidtransposeremptying, aFullContainer, true)) {
            return false;
        }
        try {
            ThermalExpansion.addTransposerExtract(aMJ * 10, aFullContainer, aEmptyContainer, aLiquid, 100, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addExtractionRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.extractor, aInput, true)) {
            return false;
        }
        GT_Values.RA.addExtractorRecipe(aInput, aOutput, 300, 2);
        return true;
    }

    public static boolean addRCBlastFurnaceRecipe(ItemStack aInput, ItemStack aOutput, int aTime) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null || aTime <= 0) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.rcblastfurnace, aInput, true)) {
            return false;
        }
        aInput = GT_Utility.copyOrNull(aInput);
        aOutput = GT_Utility.copyOrNull(aOutput);
        try {
            RailcraftCraftingManager.blastFurnace.addRecipe(aInput, true, false, aTime, aOutput);
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, false);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, 100, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance, boolean aOverwrite) {
        return GT_ModHandler.addPulverisationRecipe(aInput, aOutput1, aOutput2, aChance, null, 0, aOverwrite);
    }

    public static boolean addPulverisationRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3, boolean aOverwrite) {
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        aOutput2 = GT_OreDictUnificator.get(true, aOutput2);
        if (GT_Utility.isStackInvalid(aInput) || GT_Utility.isStackInvalid(aOutput1)) {
            return false;
        }
        if (GT_Utility.getContainerItem(aInput, false) == null) {
            GT_ModHandler.addMagneticraftRecipe(aInput, aOutput1, aOutput2, aChance2, aOutput3, aChance3);
            GT_ModHandler.addImmersiveEngineeringRecipe(aInput, aOutput1, aOutput2, aChance2, aOutput3, aChance3);
            GT_Values.RA.addPulveriserRecipe(aInput, new ItemStack[]{aOutput1, aOutput2, aOutput3}, new int[]{10000, aChance2 <= 0 ? 1000 : 100 * aChance2, aChance3 <= 0 ? 1000 : 100 * aChance3}, 400, 2);
            if (!OrePrefixes.log.contains(aInput)) {
                boolean aEnableTEMachineRecipes = GT_Mod.gregtechproxy.mTEMachineRecipes;
                if (Materials.Wood.contains(aOutput1)) {
                    if (aEnableTEMachineRecipes && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.pulverization, aInput, true)) {
                        if (aOutput2 == null) {
                            ThermalExpansion.addSawmillRecipe(32000, GT_Utility.copyOrNull(aInput), GT_Utility.copyOrNull(aOutput1));
                        } else {
                            ThermalExpansion.addSawmillRecipe(32000, GT_Utility.copyOrNull(aInput), GT_Utility.copyOrNull(aOutput1), GT_Utility.copyOrNull(aOutput2), aChance2 <= 0 ? 10 : aChance2);
                        }
                    }
                } else {
                    if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.rockcrushing, aInput, true)) {
                        try {
                            if (GT_Utility.getBlockFromStack(aInput) != Blocks.obsidian && GT_Utility.getBlockFromStack(aInput) != Blocks.gravel) {
                                IRockCrusherRecipe tRecipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(GT_Utility.copyAmount(1L, aInput), aInput.getItemDamage() != Short.MAX_VALUE, false);
                                tRecipe.addOutput(GT_Utility.copyOrNull(aOutput1), 1.0f / (float)aInput.stackSize);
                                if (aOutput2 != null) {
                                    tRecipe.addOutput(GT_Utility.copyOrNull(aOutput2), 0.01f * (float)(aChance2 <= 0 ? 10 : aChance2) / (float)aInput.stackSize);
                                }
                                if (aOutput3 != null) {
                                    tRecipe.addOutput(GT_Utility.copyOrNull(aOutput3), 0.01f * (float)(aChance3 <= 0 ? 10 : aChance3) / (float)aInput.stackSize);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (aEnableTEMachineRecipes && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.pulverization, aInput, true)) {
                        if (aOutput2 == null) {
                            ThermalExpansion.addPulverizerRecipe(32000, GT_Utility.copyOrNull(aInput), GT_Utility.copyOrNull(aOutput1));
                        } else {
                            ThermalExpansion.addPulverizerRecipe(32000, GT_Utility.copyOrNull(aInput), GT_Utility.copyOrNull(aOutput1), GT_Utility.copyOrNull(aOutput2), aChance2 <= 0 ? 10 : aChance2);
                        }
                    }
                }
            }
        }
        return true;
    }

    public static boolean addImmersiveEngineeringRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3) {
        return true;
    }

    public static boolean addMagneticraftRecipe(ItemStack aInput, ItemStack aOutput1, ItemStack aOutput2, int aChance2, ItemStack aOutput3, int aChance3) {
        return true;
    }

    public static boolean addSawmillRecipe(ItemStack aInput1, ItemStack aOutput1, ItemStack aOutput2) {
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        aOutput2 = GT_OreDictUnificator.get(true, aOutput2);
        if (aInput1 == null || aOutput1 == null) {
            return false;
        }
        if (!GT_Mod.gregtechproxy.mTEMachineRecipes && !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.sawmill, aInput1, true)) {
            return false;
        }
        try {
            ThermalExpansion.addSawmillRecipe(1600, aInput1, aOutput1, aOutput2, 100);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addAlloySmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, int aDuration, int aEUt, boolean aAllowSecondaryInputEmpty) {
        if (aInput1 == null || aInput2 == null && !aAllowSecondaryInputEmpty || aOutput1 == null) {
            return false;
        }
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        boolean temp = false;
        if (GT_Values.RA.addAlloySmelterRecipe(aInput1, aInput2, aOutput1, aDuration, aEUt)) {
            temp = true;
        }
        if (GT_Mod.gregtechproxy.mTEMachineRecipes && GT_ModHandler.addInductionSmelterRecipe(aInput1, aInput2, aOutput1, null, aDuration * aEUt * 2, 0)) {
            temp = true;
        }
        return temp;
    }

    public static boolean addInductionSmelterRecipe(ItemStack aInput1, ItemStack aInput2, ItemStack aOutput1, ItemStack aOutput2, int aEnergy, int aChance) {
        aOutput1 = GT_OreDictUnificator.get(true, aOutput1);
        aOutput2 = GT_OreDictUnificator.get(true, aOutput2);
        if (aInput1 == null || aOutput1 == null || GT_Utility.getContainerItem(aInput1, false) != null) {
            return false;
        }
        if (!GT_Mod.gregtechproxy.mTEMachineRecipes && !GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.inductionsmelter, aInput2 == null ? aInput1 : aOutput1, true)) {
            return false;
        }
        try {
            ThermalExpansion.addSmelterRecipe(aEnergy * 10, GT_Utility.copyOrNull(aInput1), aInput2 == null ? new ItemStack((Block)Blocks.sand, 1, 0) : aInput2, aOutput1, aOutput2, aChance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addOreToIngotSmeltingRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null) {
            return false;
        }
        FurnaceRecipes.smelting().func_151394_a(aInput, GT_Utility.copyOrNull(aOutput), 0.0f);
        return true;
    }

    public static void addIC2RecipesToGT(Map<IRecipeInput, RecipeOutput> aIC2RecipeList, GT_Recipe.GT_Recipe_Map aGTRecipeMap, boolean aAddGTRecipe, boolean aRemoveIC2Recipe, boolean aExcludeGTIC2Items) {
        HashMap<ItemStack, ItemStack> aRecipesToRemove = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<IRecipeInput, RecipeOutput> iRecipeInputRecipeOutputEntry : aIC2RecipeList.entrySet()) {
            if (iRecipeInputRecipeOutputEntry.getValue().items.size() <= 0) continue;
            for (ItemStack tStack : iRecipeInputRecipeOutputEntry.getKey().getInputs()) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (aAddGTRecipe && aGTRecipeMap.findRecipe(null, false, Long.MAX_VALUE, null, tStack) == null) {
                    try {
                        if (aExcludeGTIC2Items && (tStack.getUnlocalizedName().contains("gt.metaitem.01") || tStack.getUnlocalizedName().contains("gt.blockores") || tStack.getUnlocalizedName().contains("ic2.itemCrushed") || tStack.getUnlocalizedName().contains("ic2.itemPurifiedCrushed"))) continue;
                        switch (aGTRecipeMap.mUnlocalizedName) {
                            case "gt.recipe.macerator": 
                            case "gt.recipe.extractor": 
                            case "gt.recipe.compressor": {
                                aGTRecipeMap.addRecipe(true, new ItemStack[]{GT_Utility.copyAmount(iRecipeInputRecipeOutputEntry.getKey().getAmount(), tStack)}, (ItemStack[])iRecipeInputRecipeOutputEntry.getValue().items.toArray(), null, null, null, null, 300, 2, 0);
                                break;
                            }
                            case "gt.recipe.thermalcentrifuge": {
                                aGTRecipeMap.addRecipe(true, new ItemStack[]{GT_Utility.copyAmount(iRecipeInputRecipeOutputEntry.getKey().getAmount(), tStack)}, (ItemStack[])iRecipeInputRecipeOutputEntry.getValue().items.toArray(), null, null, null, null, 500, 48, 0);
                            }
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                if (!aRemoveIC2Recipe) continue;
                aRecipesToRemove.put(tStack, (ItemStack)iRecipeInputRecipeOutputEntry.getValue().items.get(0));
            }
        }
        GT_Utility.bulkRemoveSimpleIC2MachineRecipe(aRecipesToRemove, aIC2RecipeList);
    }

    public static Map<IRecipeInput, RecipeOutput> getExtractorRecipeList() {
        try {
            return Recipes.extractor.getRecipes();
        }
        catch (Throwable throwable) {
            return sExtractorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getCompressorRecipeList() {
        try {
            return Recipes.compressor.getRecipes();
        }
        catch (Throwable throwable) {
            return sCompressorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMaceratorRecipeList() {
        try {
            return Recipes.macerator.getRecipes();
        }
        catch (Throwable throwable) {
            return sMaceratorRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getThermalCentrifugeRecipeList() {
        try {
            return Recipes.centrifuge.getRecipes();
        }
        catch (Throwable throwable) {
            return sThermalCentrifugeRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getOreWashingRecipeList() {
        try {
            return Recipes.oreWashing.getRecipes();
        }
        catch (Throwable throwable) {
            return sOreWashingRecipes;
        }
    }

    public static Map<IRecipeInput, RecipeOutput> getMassFabricatorList() {
        try {
            return Recipes.matterAmplifier.getRecipes();
        }
        catch (Throwable throwable) {
            return sMassfabRecipes;
        }
    }

    public static boolean addThermalCentrifugeRecipe(ItemStack aInput, int aHeat, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.thermalcentrifuge, aInput, true)) {
            return false;
        }
        GT_Values.RA.addThermalCentrifugeRecipe(aInput, aOutput.length >= 1 ? (ItemStack)aOutput[0] : null, aOutput.length >= 2 ? (ItemStack)aOutput[1] : null, aOutput.length >= 3 ? (ItemStack)aOutput[2] : null, 500, 48);
        return true;
    }

    public static boolean addOreWasherRecipe(ItemStack aInput, int aWaterAmount, Object ... aOutput) {
        if (aInput == null || aOutput == null || aOutput.length <= 0 || aOutput[0] == null) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.orewashing, aInput, true)) {
            return false;
        }
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getWater(1000L), 500, 16);
        GT_Values.RA.addOreWasherRecipe(aInput, (ItemStack)aOutput[0], (ItemStack)aOutput[1], (ItemStack)aOutput[2], GT_ModHandler.getDistilledWater(200L), 300, 16);
        return true;
    }

    public static boolean addCompressionRecipe(ItemStack aInput, ItemStack aOutput) {
        aOutput = GT_OreDictUnificator.get(true, aOutput);
        if (aInput == null || aOutput == null || GT_Utility.areStacksEqual(aInput, aOutput, true)) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.compression, aInput, true)) {
            return false;
        }
        GT_Values.RA.addCompressorRecipe(aInput, aOutput, 300, 2);
        return true;
    }

    public static boolean addIC2MatterAmplifier(ItemStack aAmplifier, int aValue) {
        if (aAmplifier == null || aValue <= 0) {
            return false;
        }
        if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Machines.massfabamplifier, aAmplifier, true)) {
            return false;
        }
        try {
            NBTTagCompound tNBT = new NBTTagCompound();
            tNBT.setInteger("amplification", aValue);
            GT_Utility.callMethod(Recipes.matterAmplifier, "addRecipe", false, false, false, aAmplifier, tNBT);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public static boolean addRollingMachineRecipe(ItemStack aResult, Object[] aRecipe) {
        if ((aResult = GT_OreDictUnificator.get(true, aResult)) == null || aRecipe == null || aResult.stackSize <= 0) {
            return false;
        }
        try {
            RailcraftCraftingManager.rollingMachine.getRecipeList().add(new ShapedOreRecipe(GT_Utility.copyOrNull(aResult), aRecipe));
        }
        catch (Throwable e) {
            return GT_ModHandler.addCraftingRecipe(GT_Utility.copyOrNull(aResult), aRecipe);
        }
        return true;
    }

    public static void stopBufferingCraftingRecipes() {
        sBufferCraftingRecipes = false;
        GT_ModHandler.bulkRemoveRecipeByOutput(delayedRemovalByOutput);
        GT_ModHandler.bulkRemoveByRecipe(delayedRemovalByRecipe);
        sBufferRecipeList.forEach(GameRegistry::addRecipe);
        delayedRemovalByOutput.clear();
        delayedRemovalByRecipe.clear();
        sBufferRecipeList.clear();
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, false, true, false, false, false, false, false, false, false, false, false, false, true, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, 0L, aRecipe);
    }

    public static boolean addCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.MIRRORED) != 0L, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & RecipeBits.REVERSIBLE) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    private static boolean addCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get(true, aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return false;
        }
        if (aResult != null && Items.feather.getDamage(aResult) == Short.MAX_VALUE) {
            Items.feather.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        boolean tDoWeCareIfThereWasARecipe = aOnlyAddIfThereIsAnyRecipeOutputtingThis;
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            StringBuilder shape = new StringBuilder("");
            int idx = 0;
            if (aRecipe[idx] instanceof Boolean) {
                throw new IllegalArgumentException();
            }
            ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
            while (aRecipe[idx] instanceof String) {
                StringBuilder s = new StringBuilder((String)aRecipe[idx++]);
                shape.append((CharSequence)s);
                while (s.length() < 3) {
                    s.append(" ");
                }
                if (s.length() > 3) {
                    throw new IllegalArgumentException();
                }
                block33: for (char c : s.toString().toCharArray()) {
                    switch (c) {
                        case 'b': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                            continue block33;
                        }
                        case 'c': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                            continue block33;
                        }
                        case 'd': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                            continue block33;
                        }
                        case 'f': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolFile.name());
                            continue block33;
                        }
                        case 'h': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                            continue block33;
                        }
                        case 'i': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                            continue block33;
                        }
                        case 'j': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                            continue block33;
                        }
                        case 'k': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                            continue block33;
                        }
                        case 'm': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                            continue block33;
                        }
                        case 'p': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                            continue block33;
                        }
                        case 'r': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSoftHammer.name());
                            continue block33;
                        }
                        case 's': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                            continue block33;
                        }
                        case 'w': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                            continue block33;
                        }
                        case 'x': {
                            tRecipeList.add(Character.valueOf(c));
                            tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                        }
                    }
                }
            }
            aRecipe = tRecipeList.toArray();
            if (aRecipe[idx] instanceof Boolean) {
                ++idx;
            }
            HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
            HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
            tItemStackMap.put(Character.valueOf(' '), null);
            boolean tRemoveRecipe = true;
            while (idx < aRecipe.length) {
                if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.getDisplayName()));
                        for (Object tContent : aRecipe) {
                            GT_Log.err.println(tContent);
                        }
                    }
                    return false;
                }
                Character chr = (Character)aRecipe[idx];
                Object in = aRecipe[idx + 1];
                if (in instanceof ItemStack) {
                    ItemStack is = (ItemStack)in;
                    tItemStackMap.put(chr, GT_Utility.copyOrNull(is));
                    tItemDataMap.put(chr, GT_OreDictUnificator.getItemData(is));
                } else if (in instanceof ItemData) {
                    String tString = in.toString();
                    switch (tString) {
                        case "plankWood": {
                            tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneNetherrack": {
                            tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneObsidian": {
                            tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        case "stoneEndstone": {
                            tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                            break;
                        }
                        default: {
                            tItemDataMap.put(chr, (ItemData)in);
                        }
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre(in, 1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                    String string = in.toString();
                    aRecipe[idx + 1] = string;
                    in = string;
                } else if (in instanceof String) {
                    if (in.equals(OreDictNames.craftingChest.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingBook.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                    } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                    } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                        tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                    }
                    ItemStack tStack = GT_OreDictUnificator.getFirstOre(in, 1L);
                    if (tStack == null) {
                        tRemoveRecipe = false;
                    } else {
                        tItemStackMap.put(chr, tStack);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
                idx += 2;
            }
            if (aReversible && aResult != null) {
                ItemData[] tData = new ItemData[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
                }
                if (GT_Utility.arrayContainsNonNull(tData)) {
                    GT_OreDictUnificator.addItemData(aResult, new ItemData(tData));
                }
            }
            if (aCheckForCollisions && tRemoveRecipe) {
                ItemStack[] tRecipe = new ItemStack[9];
                int x = -1;
                for (char chr : shape.toString().toCharArray()) {
                    tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                    if (tRecipe[x] == null || Items.feather.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                    Items.feather.setDamage(tRecipe[x], 0);
                }
                if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                    tThereWasARecipe = GT_ModHandler.removeRecipe(tRecipe) != null || tThereWasARecipe;
                } else {
                    GT_ModHandler.removeRecipeDelayed(tRecipe);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.stackSize <= 0) {
            return false;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            if (tDoWeCareIfThereWasARecipe || !aBuffered) {
                tThereWasARecipe = GT_ModHandler.removeRecipeByOutput(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
            } else {
                GT_ModHandler.removeRecipeByOutputDelayed(aResult);
            }
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tDoWeCareIfThereWasARecipe && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
            int tList_sS = tList.size();
            for (int i = 0; i < tList_sS && !tThereWasARecipe; ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tRecipe.getRecipeOutput()), aResult, true)) continue;
                tList.remove(i--);
                tList_sS = tList.size();
                tThereWasARecipe = true;
            }
        }
        if (Items.feather.getDamage(aResult) == Short.MAX_VALUE || Items.feather.getDamage(aResult) < 0) {
            Items.feather.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack(aResult);
        if (tThereWasARecipe || !aOnlyAddIfThereIsAnyRecipeOutputtingThis) {
            if (sBufferCraftingRecipes && aBuffered) {
                sBufferRecipeList.add((IRecipe)new GT_Shaped_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            } else {
                GameRegistry.addRecipe((IRecipe)new GT_Shaped_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored));
            }
        }
        return true;
    }

    public static boolean addShapelessEnchantingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, aEnchantmentsAdded, aEnchantmentLevelsAdded, true, false, false, false, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | RecipeBits.BUFFERED, aRecipe);
    }

    public static boolean addShapelessCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return GT_ModHandler.addShapelessCraftingRecipe(aResult, new Enchantment[]{}, new int[]{}, (aBitMask & RecipeBits.BUFFERED) != 0L, (aBitMask & RecipeBits.KEEPNBT) != 0L, (aBitMask & RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & RecipeBits.NOT_REMOVABLE) == 0L, aRecipe);
    }

    private static boolean addShapelessCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, Object[] aRecipe) {
        aResult = GT_OreDictUnificator.get(true, aResult);
        if (aRecipe == null || aRecipe.length <= 0) {
            return false;
        }
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            if (aRecipe[i] instanceof IItemContainer) {
                aRecipe[i] = ((IItemContainer)aRecipe[i]).get(1L, new Object[0]);
                continue;
            }
            if (aRecipe[i] instanceof Enum) {
                aRecipe[i] = ((Enum)aRecipe[i]).name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        try {
            ItemStack[] tRecipe = new ItemStack[9];
            int i = 0;
            for (Object tObject : aRecipe) {
                if (tObject == null) {
                    if (GT_Values.D1) {
                        GT_Log.err.println("WARNING: Missing Item for shapeless Recipe: " + (aResult == null ? "null" : aResult.getDisplayName()));
                    }
                    for (Object tContent : aRecipe) {
                        GT_Log.err.println(tContent);
                    }
                    return false;
                }
                if (tObject instanceof ItemStack) {
                    tRecipe[i] = (ItemStack)tObject;
                } else if (tObject instanceof String) {
                    tRecipe[i] = GT_OreDictUnificator.getFirstOre(tObject, 1L);
                    if (tRecipe[i] == null) break;
                }
                ++i;
            }
            if (sBufferCraftingRecipes && aBuffered) {
                GT_ModHandler.removeRecipeDelayed(tRecipe);
            } else {
                GT_ModHandler.removeRecipe(tRecipe);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aResult == null || aResult.stackSize <= 0) {
            return false;
        }
        if (Items.feather.getDamage(aResult) == Short.MAX_VALUE || Items.feather.getDamage(aResult) < 0) {
            Items.feather.setDamage(aResult, 0);
        }
        GT_Utility.updateItemStack(aResult);
        if (sBufferCraftingRecipes && aBuffered) {
            sBufferRecipeList.add(new GT_Shapeless_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        } else {
            GameRegistry.addRecipe((IRecipe)new GT_Shapeless_Recipe(GT_Utility.copyOrNull(aResult), aDismantleable, aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe));
        }
        return true;
    }

    public static boolean removeFurnaceSmelting(ItemStack aInput) {
        if (aInput != null) {
            for (Object tInput : FurnaceRecipes.smelting().getSmeltingList().keySet()) {
                if (!GT_Utility.isStackValid(tInput) || !GT_Utility.areStacksEqual(aInput, (ItemStack)tInput, true)) continue;
                FurnaceRecipes.smelting().getSmeltingList().remove(tInput);
                return true;
            }
        }
        return false;
    }

    public static ItemStack removeRecipe(ItemStack ... aRecipe) {
        if (aRecipe == null) {
            return null;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        ItemStack rReturn = null;
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
        int tList_sS = tList.size();
        try {
            for (int i = 0; i < tList_sS; ++i) {
                while (i < tList_sS) {
                    if ((!(tList.get(i) instanceof IGT_CraftingRecipe) || ((IGT_CraftingRecipe)tList.get(i)).isRemovable()) && ((IRecipe)tList.get(i)).matches(aCrafting, GT_Values.DW)) {
                        rReturn = ((IRecipe)tList.get(i)).getCraftingResult(aCrafting);
                        if (rReturn != null) {
                            tList.remove(i--);
                        }
                        tList_sS = tList.size();
                    }
                    ++i;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        return rReturn;
    }

    public static void removeRecipeDelayed(ItemStack ... aRecipe) {
        if (!sBufferCraftingRecipes) {
            GT_ModHandler.removeRecipe(aRecipe);
            return;
        }
        if (aRecipe == null) {
            return;
        }
        if (Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < aRecipe.length && i < 9; ++i) {
            aCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        delayedRemovalByRecipe.add(aCrafting);
    }

    public static void bulkRemoveByRecipe(List<InventoryCrafting> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
        GT_Mod.GT_FML_LOGGER.info("BulkRemoveByRecipe: tList: " + tList.size() + " toRemove: " + toRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            return toRemove.stream().anyMatch(aCrafting -> tRecipe.matches(aCrafting, GT_Values.DW));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput) {
        if (sBufferCraftingRecipes) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GT_ModHandler.removeRecipeByOutput(aOutput);
    }

    public static boolean removeRecipeByOutputDelayed(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (sBufferCraftingRecipes && aIgnoreNBT && !aNotRemoveShapelessRecipes && !aOnlyRemoveNativeHandlers) {
            return delayedRemovalByOutput.add(aOutput);
        }
        return GT_ModHandler.removeRecipeByOutput(aOutput, aIgnoreNBT, aNotRemoveShapelessRecipes, aOnlyRemoveNativeHandlers);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput) {
        return GT_ModHandler.removeRecipeByOutput(aOutput, true, false, false);
    }

    public static boolean removeRecipeByOutput(ItemStack aOutput, boolean aIgnoreNBT, boolean aNotRemoveShapelessRecipes, boolean aOnlyRemoveNativeHandlers) {
        if (aOutput == null) {
            return false;
        }
        boolean rReturn = false;
        ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
        aOutput = GT_OreDictUnificator.get(aOutput);
        int tList_sS = tList.size();
        for (int i = 0; i < tList_sS; ++i) {
            IRecipe tRecipe = (IRecipe)tList.get(i);
            if (aNotRemoveShapelessRecipes && (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) || (aOnlyRemoveNativeHandlers ? !sNativeRecipeClasses.contains(tRecipe.getClass().getName()) : sSpecialRecipeClasses.contains(tRecipe.getClass().getName()))) continue;
            ItemStack tStack = tRecipe.getRecipeOutput();
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable() || !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tStack), aOutput, aIgnoreNBT)) continue;
            tList.remove(i--);
            tList_sS = tList.size();
            rReturn = true;
        }
        return rReturn;
    }

    public static boolean bulkRemoveRecipeByOutput(List<ItemStack> toRemove) {
        ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
        Set setToRemove = toRemove.parallelStream().map(GT_OreDictUnificator::get_nocopy).collect(Collectors.toSet());
        GT_Mod.GT_FML_LOGGER.info("BulkRemoveRecipeByOutput: tList: " + tList.size() + " setToRemove: " + setToRemove.size());
        Set tListToRemove = tList.parallelStream().filter(tRecipe -> {
            if (tRecipe instanceof IGT_CraftingRecipe && !((IGT_CraftingRecipe)tRecipe).isRemovable()) {
                return false;
            }
            if (sSpecialRecipeClasses.contains(tRecipe.getClass().getName())) {
                return false;
            }
            ItemStack tStack = GT_OreDictUnificator.get_nocopy(tRecipe.getRecipeOutput());
            return setToRemove.stream().anyMatch(aOutput -> GT_Utility.areStacksEqual(tStack, aOutput, true));
        }).collect(Collectors.toSet());
        tList.removeIf(tListToRemove::contains);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack getAllRecipeOutput(World aWorld, ItemStack ... aRecipe) {
        if (aRecipe == null || aRecipe.length == 0) {
            return null;
        }
        if (aWorld == null) {
            aWorld = GT_Values.DW;
        }
        boolean temp = false;
        for (ItemStack itemStack : aRecipe) {
            if (itemStack == null) continue;
            temp = true;
            break;
        }
        if (!temp) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        List tList = CraftingManager.getInstance().getRecipeList();
        List<IRecipe> list = sAllRecipeList;
        synchronized (list) {
            if (sAllRecipeList.size() != tList.size()) {
                sAllRecipeList.clear();
                sAllRecipeList.addAll(tList);
            }
            int j = sAllRecipeList.size();
            for (int i = 0; i < j; ++i) {
                IRecipe tRecipe = sAllRecipeList.get(i);
                if (!tRecipe.matches(aCrafting, aWorld)) continue;
                if (i > 10) {
                    sAllRecipeList.remove(i);
                    sAllRecipeList.add(i - 10, tRecipe);
                }
                return tRecipe.getCraftingResult(aCrafting);
            }
        }
        int tIndex = 0;
        ItemStack tStack1 = null;
        ItemStack tStack2 = null;
        int j = aCrafting.getSizeInventory();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack = aCrafting.getStackInSlot(i);
            if (tStack == null) continue;
            if (tIndex == 0) {
                tStack1 = tStack;
            }
            if (tIndex == 1) {
                tStack2 = tStack;
            }
            ++tIndex;
        }
        if (tIndex == 2) {
            assert (tStack1 != null && tStack2 != null);
            if (tStack1.getItem() == tStack2.getItem() && tStack1.stackSize == 1 && tStack2.stackSize == 1 && tStack1.getItem().isRepairable()) {
                int tNewDamage = tStack1.getMaxDamage() + tStack1.getItemDamage() - tStack2.getItemDamage() + tStack1.getMaxDamage() / 20;
                return new ItemStack(tStack1.getItem(), 1, tNewDamage < 0 ? 0 : tNewDamage);
            }
        }
        return null;
    }

    public static ItemStack getRecipeOutput(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(false, true, aRecipe);
    }

    public static ItemStack getRecipeOutputNoOreDict(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(false, false, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutput(aUncopiedStack, true, aRecipe);
    }

    public static ItemStack getRecipeOutput(boolean aUncopiedStack, boolean allowOreDict, ItemStack ... aRecipe) {
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return null;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        ArrayList tList = (ArrayList)CraftingManager.getInstance().getRecipeList();
        boolean found = false;
        for (IRecipe iRecipe : tList) {
            ItemStack tOutput;
            found = false;
            if (!allowOreDict && iRecipe instanceof ShapedOreRecipe) continue;
            try {
                found = iRecipe.matches(aCrafting, GT_Values.DW);
            }
            catch (Throwable e) {
                e.printStackTrace(GT_Log.err);
            }
            if (!found) continue;
            ItemStack itemStack = tOutput = aUncopiedStack ? iRecipe.getRecipeOutput() : iRecipe.getCraftingResult(aCrafting);
            if (tOutput == null || tOutput.stackSize <= 0) {
                if (GregTech_API.sPostloadFinished) continue;
                throw new GT_ItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
            }
            if (aUncopiedStack) {
                return tOutput;
            }
            return GT_Utility.copyOrNull(tOutput);
        }
        return null;
    }

    public static List<ItemStack> getVanillyToolRecipeOutputs(ItemStack ... aRecipe) {
        if (!GregTech_API.sPostloadStarted || GregTech_API.sPostloadFinished) {
            sSingleNonBlockDamagableRecipeList.clear();
        }
        if (sSingleNonBlockDamagableRecipeList.isEmpty()) {
            for (IRecipe tRecipe : (ArrayList)CraftingManager.getInstance().getRecipeList()) {
                boolean temp;
                ItemStack tStack = tRecipe.getRecipeOutput();
                if (!GT_Utility.isStackValid(tStack) || tStack.getMaxStackSize() != 1 || tStack.getMaxDamage() <= 0 || tStack.getItem() instanceof ItemBlock || tStack.getItem() instanceof IReactorComponent || GT_ModHandler.isElectricItem(tStack) || GT_Utility.isStackInList(tStack, sNonReplaceableItems) || tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe) continue;
                if (tRecipe instanceof ShapedOreRecipe) {
                    temp = true;
                    for (Object object : ((ShapedOreRecipe)tRecipe).getInput()) {
                        if (object == null) continue;
                        if (object instanceof ItemStack && (((ItemStack)object).getItem() == null || ((ItemStack)object).getMaxStackSize() < 2 || ((ItemStack)object).getMaxDamage() > 0 || ((ItemStack)object).getItem() instanceof ItemBlock)) {
                            temp = false;
                            break;
                        }
                        if (!(object instanceof List) || !((List)object).isEmpty()) continue;
                        temp = false;
                        break;
                    }
                    if (!temp) continue;
                    sSingleNonBlockDamagableRecipeList.add(tRecipe);
                    continue;
                }
                if (tRecipe instanceof ShapedRecipes) {
                    temp = true;
                    for (ItemStack itemStack : ((ShapedRecipes)tRecipe).recipeItems) {
                        if (itemStack == null || itemStack.getItem() != null && itemStack.getMaxStackSize() >= 2 && itemStack.getMaxDamage() <= 0 && !(itemStack.getItem() instanceof ItemBlock)) continue;
                        temp = false;
                        break;
                    }
                    if (!temp) continue;
                    sSingleNonBlockDamagableRecipeList.add(tRecipe);
                    continue;
                }
                sSingleNonBlockDamagableRecipeList.add(tRecipe);
            }
            GT_Log.out.println("GT_Mod: Created a List of Tool Recipes containing " + sSingleNonBlockDamagableRecipeList.size() + " Recipes for recycling." + (sSingleNonBlockDamagableRecipeList.size() > 1024 ? " Scanning all these Recipes is the reason for the startup Lag you receive right now." : ""));
        }
        List<ItemStack> rList = GT_ModHandler.getRecipeOutputs(sSingleNonBlockDamagableRecipeList, true, aRecipe);
        if (!GregTech_API.sPostloadStarted || GregTech_API.sPostloadFinished) {
            sSingleNonBlockDamagableRecipeList.clear();
        }
        return rList;
    }

    public static List<ItemStack> getRecipeOutputs(ItemStack ... aRecipe) {
        return GT_ModHandler.getRecipeOutputs(CraftingManager.getInstance().getRecipeList(), false, aRecipe);
    }

    public static List<ItemStack> getRecipeOutputsBuffered(ItemStack ... aRecipe) {
        if (bufferedRecipes == null) {
            bufferedRecipes = CraftingManager.getInstance().getRecipeList().stream().filter(tRecipe -> !(tRecipe instanceof ShapelessRecipes) && !(tRecipe instanceof ShapelessOreRecipe) && !(tRecipe instanceof IGT_CraftingRecipe)).filter(tRecipe -> {
                try {
                    ItemStack tOutput = ((IRecipe)tRecipe).getRecipeOutput();
                    if (tOutput.stackSize == 1 && tOutput.getMaxDamage() > 0 && tOutput.getMaxStackSize() == 1) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }).collect(Collectors.toList());
        }
        return GT_ModHandler.getRecipeOutputs(bufferedRecipes, false, aRecipe);
    }

    public static List<ItemStack> getRecipeOutputs(List<IRecipe> aList, boolean aDeleteFromList, ItemStack ... aRecipe) {
        int i;
        List<Object> rList = new ArrayList<ItemStack>();
        if (aRecipe == null || Arrays.stream(aRecipe).noneMatch(Objects::nonNull)) {
            return rList;
        }
        InventoryCrafting aCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (i = 0; i < 9 && i < aRecipe.length; ++i) {
            aCrafting.setInventorySlotContents(i, aRecipe[i]);
        }
        if (!aDeleteFromList) {
            HashSet stacks = new HashSet();
            aList.stream().filter(tRecipe -> {
                if (tRecipe instanceof ShapelessRecipes || tRecipe instanceof ShapelessOreRecipe || tRecipe instanceof IGT_CraftingRecipe) {
                    return false;
                }
                try {
                    return tRecipe.matches(aCrafting, GT_Values.DW);
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                    return false;
                }
            }).forEach(tRecipe -> stacks.add(tRecipe.getCraftingResult(aCrafting)));
            rList = stacks.stream().filter(tOutput -> tOutput.stackSize == 1 && tOutput.getMaxDamage() > 0 && tOutput.getMaxStackSize() == 1).collect(Collectors.toList());
        } else {
            for (i = 0; i < aList.size(); ++i) {
                boolean temp = false;
                try {
                    temp = aList.get(i).matches(aCrafting, GT_Values.DW);
                }
                catch (Throwable e) {
                    e.printStackTrace(GT_Log.err);
                }
                if (!temp) continue;
                IRecipe tRecipe2 = aList.get(i);
                ItemStack tOutput2 = tRecipe2.getCraftingResult(aCrafting);
                if (tOutput2 == null || tOutput2.stackSize <= 0) {
                    if (GregTech_API.sPostloadFinished) continue;
                    throw new GT_ItsNotMyFaultException("Seems another Mod added a Crafting Recipe with null Output. Tell the Developer of said Mod to fix that.");
                }
                if (tOutput2.stackSize != 1 || tOutput2.getMaxDamage() <= 0 || tOutput2.getMaxStackSize() != 1 || tRecipe2 instanceof ShapelessRecipes || tRecipe2 instanceof ShapelessOreRecipe || tRecipe2 instanceof IGT_CraftingRecipe) continue;
                rList.add(GT_Utility.copyOrNull(tOutput2));
                aList.remove(i--);
            }
        }
        return rList;
    }

    @Deprecated
    public static ItemStack getMaceratorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getMaceratorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    @Deprecated
    public static ItemStack getExtractorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getExtractorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    @Deprecated
    public static ItemStack getCompressorOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        return GT_Utility.copyOrNull(GT_ModHandler.getMachineOutput(aInput, GT_ModHandler.getCompressorRecipeList(), aRemoveInput, new NBTTagCompound(), aOutputSlot)[0]);
    }

    public static ItemStack getSmeltingOutput(ItemStack aInput, boolean aRemoveInput, ItemStack aOutputSlot) {
        if (aInput == null || aInput.stackSize < 1) {
            return null;
        }
        ItemStack rStack = null;
        try {
            rStack = (ItemStack)sSmeltingRecipeCache.get((Object)new GT_ItemStack(aInput), () -> GT_OreDictUnificator.get(FurnaceRecipes.smelting().getSmeltingResult(aInput)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rStack != null && (aOutputSlot == null || GT_Utility.areStacksEqual(rStack, aOutputSlot) && rStack.stackSize + aOutputSlot.stackSize <= aOutputSlot.getMaxStackSize())) {
            if (aRemoveInput) {
                --aInput.stackSize;
            }
            return rStack;
        }
        return null;
    }

    public static ItemStack[] getMachineOutput(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, boolean aRemoveInput, NBTTagCompound rRecipeMetaData, ItemStack ... aOutputSlots) {
        block8: {
            if (aOutputSlots == null || aOutputSlots.length <= 0) {
                return new ItemStack[0];
            }
            if (aInput == null) {
                return new ItemStack[aOutputSlots.length];
            }
            try {
                for (Map.Entry<IRecipeInput, RecipeOutput> tEntry : aRecipeList.entrySet()) {
                    ItemStack[] tList;
                    if (!tEntry.getKey().matches(aInput)) continue;
                    if (tEntry.getKey().getAmount() > aInput.stackSize || (tList = tEntry.getValue().items.toArray(new ItemStack[0])).length == 0) break;
                    ItemStack[] rList = new ItemStack[aOutputSlots.length];
                    rRecipeMetaData.setTag("return", (NBTBase)tEntry.getValue().metadata);
                    for (int i = 0; i < aOutputSlots.length && i < tList.length; i = (int)((byte)(i + 1))) {
                        if (tList[i] == null) continue;
                        if (aOutputSlots[i] == null || GT_Utility.areStacksEqual(tList[i], aOutputSlots[i]) && tList[i].stackSize + aOutputSlots[i].stackSize <= aOutputSlots[i].getMaxStackSize()) {
                            rList[i] = GT_Utility.copyOrNull(tList[i]);
                            continue;
                        }
                        return new ItemStack[aOutputSlots.length];
                    }
                    if (aRemoveInput) {
                        aInput.stackSize -= tEntry.getKey().getAmount();
                    }
                    return rList;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block8;
                e.printStackTrace(GT_Log.err);
            }
        }
        return new ItemStack[aOutputSlots.length];
    }

    public static ItemStack getRecyclerOutput(ItemStack aInput, int aScrapChance) {
        if (aInput == null || aScrapChance != 0) {
            return null;
        }
        try {
            if (Recipes.recyclerWhitelist.isEmpty()) {
                return Recipes.recyclerBlacklist.contains(aInput) ? null : ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            return Recipes.recyclerWhitelist.contains(aInput) ? ItemList.IC2_Scrap.get(1L, new Object[0]) : null;
        }
        catch (Throwable throwable) {
            try {
                return Recipes.recyclerBlacklist.contains(aInput) ? null : ItemList.IC2_Scrap.get(1L, new Object[0]);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    public static ItemStack getRandomScrapboxDrop() {
        return Recipes.scrapboxDrops.getDrop(ItemList.IC2_Scrapbox.get(1L, new Object[0]), false);
    }

    public static int chargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.getItem()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, GT_Values.V[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge;
                    return rCharge + ((rCharge = (int)Math.max(0.0, ElectricItem.manager.charge(aStack, (double)aCharge, tTier, true, aSimulate))) * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static int dischargeElectricItem(ItemStack aStack, int aCharge, int aTier, boolean aIgnoreLimit, boolean aSimulate, boolean aIgnoreDischargability) {
        try {
            int tTier;
            if (GT_ModHandler.isElectricItem(aStack) && ((tTier = ((IElectricItem)aStack.getItem()).getTier(aStack)) < 0 || tTier == aTier || aTier == Integer.MAX_VALUE)) {
                if (!aIgnoreLimit && tTier >= 0) {
                    aCharge = (int)Math.min((long)aCharge, GT_Values.V[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))] + (long)GT_Values.B[Math.max(0, Math.min(GT_Values.V.length - 1, tTier))]);
                }
                if (aCharge > 0) {
                    int rCharge = (int)Math.max(0.0, ElectricItem.manager.discharge(aStack, (double)(aCharge + (aCharge * 4 > aTier ? aTier : 0)), tTier, true, !aIgnoreDischargability, aSimulate));
                    return rCharge - (rCharge * 4 > aTier ? aTier : 0);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public static boolean canUseElectricItem(ItemStack aStack, int aCharge) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ElectricItem.manager.canUse(aStack, (double)aCharge);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean useElectricItem(ItemStack aStack, int aCharge, EntityPlayer aPlayer) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                ElectricItem.manager.use(aStack, 0.0, (EntityLivingBase)aPlayer);
                if (ElectricItem.manager.canUse(aStack, (double)aCharge)) {
                    return ElectricItem.manager.use(aStack, (double)aCharge, (EntityLivingBase)aPlayer);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean damageOrDechargeItem(ItemStack aStack, int aDamage, int aDecharge, EntityLivingBase aPlayer) {
        if (GT_Utility.isStackInvalid(aStack) || aStack.getMaxStackSize() <= 1 && aStack.stackSize > 1) {
            return false;
        }
        if (aPlayer != null && aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode) {
            return true;
        }
        if (aStack.getItem() instanceof IDamagableItem) {
            return ((IDamagableItem)aStack.getItem()).doDamageToItem(aStack, aDamage);
        }
        if (GT_ModHandler.isElectricItem(aStack)) {
            if (GT_ModHandler.canUseElectricItem(aStack, aDecharge)) {
                if (aPlayer != null && aPlayer instanceof EntityPlayer) {
                    return GT_ModHandler.useElectricItem(aStack, aDecharge, (EntityPlayer)aPlayer);
                }
                return GT_ModHandler.dischargeElectricItem(aStack, aDecharge, Integer.MAX_VALUE, true, false, true) >= aDecharge;
            }
        } else if (aStack.getItem().isDamageable()) {
            if (aPlayer == null) {
                aStack.setItemDamage(aStack.getItemDamage() + aDamage);
            } else {
                aStack.damageItem(aDamage, aPlayer);
            }
            if (aStack.getItemDamage() >= aStack.getMaxDamage()) {
                aStack.setItemDamage(aStack.getMaxDamage() + 1);
                ItemStack tStack = GT_Utility.getContainerItem(aStack, true);
                if (tStack != null) {
                    aStack.func_150996_a(tStack.getItem());
                    aStack.setItemDamage(tStack.getItemDamage());
                    aStack.stackSize = tStack.stackSize;
                    aStack.setTagCompound(tStack.getTagCompound());
                }
            }
            return true;
        }
        return false;
    }

    public static boolean useSolderingIron(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aStack == null) {
            return false;
        }
        if (GT_Utility.isStackInList(aStack, GregTech_API.sSolderingToolList)) {
            if (aPlayer instanceof EntityPlayer) {
                EntityPlayer tPlayer = (EntityPlayer)aPlayer;
                if (tPlayer.capabilities.isCreativeMode) {
                    return true;
                }
                if (GT_ModHandler.isElectricItem(aStack) && ElectricItem.manager.getCharge(aStack) > 1000.0 && GT_ModHandler.consumeSolderingMaterial(tPlayer)) {
                    if (GT_ModHandler.canUseElectricItem(aStack, 10000)) {
                        return GT_ModHandler.useElectricItem(aStack, 10000, (EntityPlayer)aPlayer);
                    }
                    GT_ModHandler.useElectricItem(aStack, (int)ElectricItem.manager.getCharge(aStack), (EntityPlayer)aPlayer);
                    return false;
                }
            } else {
                GT_ModHandler.damageOrDechargeItem(aStack, 1, 1000, aPlayer);
                return true;
            }
        }
        return false;
    }

    public static boolean consumeSolderingMaterial(EntityPlayer aPlayer) {
        if (aPlayer.capabilities.isCreativeMode) {
            return true;
        }
        for (int i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
            if (!GT_Utility.isStackInList(aPlayer.inventory.mainInventory[i], GregTech_API.sSolderingMetalList)) continue;
            if (aPlayer.inventory.mainInventory[i].stackSize < 1) {
                return false;
            }
            if (aPlayer.inventory.mainInventory[i].stackSize == 1) {
                aPlayer.inventory.mainInventory[i] = null;
            } else {
                --aPlayer.inventory.mainInventory[i].stackSize;
            }
            if (aPlayer.inventoryContainer != null) {
                aPlayer.inventoryContainer.detectAndSendChanges();
            }
            return true;
        }
        return false;
    }

    public static boolean isChargerItem(ItemStack aStack) {
        try {
            if (GT_ModHandler.isElectricItem(aStack)) {
                return ((IElectricItem)aStack.getItem()).canProvideEnergy(aStack);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isElectricItem(ItemStack aStack) {
        try {
            return aStack != null && aStack.getItem() instanceof IElectricItem && ((IElectricItem)aStack.getItem()).getTier(aStack) < Integer.MAX_VALUE;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isElectricItem(ItemStack aStack, byte aTier) {
        try {
            return aStack != null && aStack.getItem() instanceof IElectricItem && ((IElectricItem)aStack.getItem()).getTier(aStack) == aTier;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void registerBoxableItemToToolBox(ItemStack aStack) {
        if (aStack != null) {
            GT_ModHandler.registerBoxableItemToToolBox(aStack.getItem());
        }
    }

    public static void registerBoxableItemToToolBox(Item aItem) {
        if (aItem != null && sBoxableWrapper != null) {
            try {
                ItemWrapper.registerBoxable((Item)aItem, (IBoxable)((IBoxable)sBoxableWrapper));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static int getCapsuleCellContainerCountMultipliedWithStackSize(ItemStack ... aStacks) {
        int rAmount = 0;
        for (ItemStack tStack : aStacks) {
            if (tStack == null) continue;
            rAmount += GT_ModHandler.getCapsuleCellContainerCount(tStack) * tStack.stackSize;
        }
        return rAmount;
    }

    public static int getCapsuleCellContainerCount(ItemStack aStack) {
        if (aStack == null) {
            return 0;
        }
        if (GT_Utility.areStacksEqual(GT_Utility.getContainerForFilledItem(aStack, true), ItemList.Cell_Empty.get(1L, new Object[0]))) {
            return 1;
        }
        if (GT_Utility.areStacksEqual(aStack, GT_ModHandler.getIC2Item("waterCell", 1L, Short.MAX_VALUE))) {
            return 1;
        }
        for (OrePrefixes cellType : OrePrefixes.CELL_TYPES) {
            if (!cellType.contains(aStack)) continue;
            return 1;
        }
        return 0;
    }

    static {
        sNativeRecipeClasses.add(ShapedRecipes.class.getName());
        sNativeRecipeClasses.add(ShapedOreRecipe.class.getName());
        sNativeRecipeClasses.add(GT_Shaped_Recipe.class.getName());
        sNativeRecipeClasses.add(ShapelessRecipes.class.getName());
        sNativeRecipeClasses.add(ShapelessOreRecipe.class.getName());
        sNativeRecipeClasses.add(GT_Shapeless_Recipe.class.getName());
        sNativeRecipeClasses.add(AdvRecipe.class.getName());
        sNativeRecipeClasses.add(AdvShapelessRecipe.class.getName());
        sNativeRecipeClasses.add("appeng.recipes.game.ShapedRecipe");
        sNativeRecipeClasses.add("appeng.recipes.game.ShapelessRecipe");
        sNativeRecipeClasses.add("forestry.core.utils.ShapedRecipeCustom");
        sSpecialRecipeClasses.add(RecipeFireworks.class.getName());
        sSpecialRecipeClasses.add(RecipesArmorDyes.class.getName());
        sSpecialRecipeClasses.add(RecipeBookCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapCloning.class.getName());
        sSpecialRecipeClasses.add(RecipesMapExtending.class.getName());
        sSpecialRecipeClasses.add("jds.bibliocraft.BiblioSpecialRecipes");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQBlockRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.EntangledQuantumComputerRecipe");
        sSpecialRecipeClasses.add("dan200.qcraft.shared.QBlockRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.FacadeRecipe");
        sSpecialRecipeClasses.add("appeng.recipes.game.DisassembleRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.carts.LocomotivePaintingRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RotorRepairRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTableCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.RoutingTicketCopyRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.util.crafting.TankCartFilterRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.LocomotiveEmblemRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostColorRecipe");
        sSpecialRecipeClasses.add("mods.railcraft.common.emblems.EmblemPostEmblemRecipe");
        sSpecialRecipeClasses.add("mods.immibis.redlogic.interaction.RecipeDyeLumarButton");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes");
        sSpecialRecipeClasses.add("thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe");
        sSpecialRecipeClasses.add("twilightforest.item.TFMapCloningRecipe");
        sSpecialRecipeClasses.add("forestry.lepidopterology.MatingRecipe");
        sSpecialRecipeClasses.add("micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes");
        sSpecialRecipeClasses.add("shedar.mods.ic2.nuclearcontrol.StorageArrayRecipe");
        bufferedRecipes = null;
    }

    public static class ThermalExpansion {
        public static void addFurnaceRecipe(int energy, ItemStack input, ItemStack output) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("output", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            output.writeToNBT(toSend.getCompoundTag("output"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"FurnaceRecipe", (NBTTagCompound)toSend);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
            ThermalExpansion.addPulverizerRecipe(energy, input, primaryOutput, null, 0);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addPulverizerRecipe(energy, input, primaryOutput, secondaryOutput, 100);
        }

        public static void addPulverizerRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (input == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
            }
            toSend.setInteger("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"PulverizerRecipe", (NBTTagCompound)toSend);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput) {
            ThermalExpansion.addSawmillRecipe(energy, input, primaryOutput, null, 0);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addSawmillRecipe(energy, input, primaryOutput, secondaryOutput, 100);
        }

        public static void addSawmillRecipe(int energy, ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (input == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
            }
            toSend.setInteger("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SawmillRecipe", (NBTTagCompound)toSend);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
            ThermalExpansion.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
            ThermalExpansion.addSmelterRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100);
        }

        public static void addSmelterRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
            if (primaryInput == null || secondaryInput == null || primaryOutput == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("primaryInput", (NBTBase)new NBTTagCompound());
            toSend.setTag("secondaryInput", (NBTBase)new NBTTagCompound());
            toSend.setTag("primaryOutput", (NBTBase)new NBTTagCompound());
            toSend.setTag("secondaryOutput", (NBTBase)new NBTTagCompound());
            primaryInput.writeToNBT(toSend.getCompoundTag("primaryInput"));
            secondaryInput.writeToNBT(toSend.getCompoundTag("secondaryInput"));
            primaryOutput.writeToNBT(toSend.getCompoundTag("primaryOutput"));
            if (secondaryOutput != null) {
                secondaryOutput.writeToNBT(toSend.getCompoundTag("secondaryOutput"));
            }
            toSend.setInteger("secondaryChance", secondaryChance);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterRecipe", (NBTTagCompound)toSend);
        }

        public static void addSmelterBlastOre(Materials aMaterial) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setString("oreType", aMaterial.toString());
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"SmelterBlastOreType", (NBTTagCompound)toSend);
        }

        public static void addCrucibleRecipe(int energy, ItemStack input, FluidStack output) {
            if (input == null || output == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("output", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            output.writeToNBT(toSend.getCompoundTag("output"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CrucibleRecipe", (NBTTagCompound)toSend);
        }

        public static void addTransposerFill(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
            if (input == null || output == null || fluid == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("output", (NBTBase)new NBTTagCompound());
            toSend.setTag("fluid", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            output.writeToNBT(toSend.getCompoundTag("output"));
            toSend.setBoolean("reversible", reversible);
            fluid.writeToNBT(toSend.getCompoundTag("fluid"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerFillRecipe", (NBTTagCompound)toSend);
        }

        public static void addTransposerExtract(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
            if (input == null || output == null || fluid == null) {
                return;
            }
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setInteger("energy", energy);
            toSend.setTag("input", (NBTBase)new NBTTagCompound());
            toSend.setTag("output", (NBTBase)new NBTTagCompound());
            toSend.setTag("fluid", (NBTBase)new NBTTagCompound());
            input.writeToNBT(toSend.getCompoundTag("input"));
            output.writeToNBT(toSend.getCompoundTag("output"));
            toSend.setBoolean("reversible", reversible);
            toSend.setInteger("chance", chance);
            fluid.writeToNBT(toSend.getCompoundTag("fluid"));
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"TransposerExtractRecipe", (NBTTagCompound)toSend);
        }

        public static void addMagmaticFuel(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setString("fluidName", fluidName);
            toSend.setInteger("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"MagmaticFuel", (NBTTagCompound)toSend);
        }

        public static void addCompressionFuel(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setString("fluidName", fluidName);
            toSend.setInteger("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"CompressionFuel", (NBTTagCompound)toSend);
        }

        public static void addCoolant(String fluidName, int energy) {
            NBTTagCompound toSend = new NBTTagCompound();
            toSend.setString("fluidName", fluidName);
            toSend.setInteger("energy", energy);
            FMLInterModComms.sendMessage((String)"ThermalExpansion", (String)"Coolant", (NBTTagCompound)toSend);
        }
    }

    public static class RecipeBits {
        public static long MIRRORED = GT_Values.B[0];
        public static long BUFFERED = GT_Values.B[1];
        public static long KEEPNBT = GT_Values.B[2];
        public static long DISMANTLEABLE = GT_Values.B[3];
        public static long NOT_REMOVABLE = GT_Values.B[4];
        public static long REVERSIBLE = GT_Values.B[5];
        public static long DELETE_ALL_OTHER_RECIPES = GT_Values.B[6];
        public static long DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT = GT_Values.B[7];
        public static long DELETE_ALL_OTHER_SHAPED_RECIPES = GT_Values.B[8];
        public static long DELETE_ALL_OTHER_NATIVE_RECIPES = GT_Values.B[9];
        public static long DO_NOT_CHECK_FOR_COLLISIONS = GT_Values.B[10];
        public static long ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT = GT_Values.B[11];
        public static long ONLY_ADD_IF_RESULT_IS_NOT_NULL = GT_Values.B[12];
        public static long DONT_REMOVE_SHAPELESS = GT_Values.B[13];
    }
}

