/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.common.items.GT_FluidDisplayItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GT_FluidDisplayStackRenderer
implements IItemRenderer {
    public GT_FluidDisplayStackRenderer() {
        MinecraftForgeClient.registerItemRenderer((Item)ItemList.Display_Fluid.getItem(), (IItemRenderer)this);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        if (!item.hasTagCompound()) {
            return false;
        }
        return type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (item == null || item.getItem() == null || !(item.getItem() instanceof GT_FluidDisplayItem)) {
            return;
        }
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        IIcon icon = item.getItem().getIconFromDamage(item.getItemDamage());
        Tessellator tess = Tessellator.instance;
        tess.startDrawingQuads();
        float x_min = icon.getMinU();
        float x_max = icon.getMaxU();
        float y_min = icon.getMinV();
        float y_max = icon.getMaxV();
        tess.addVertexWithUV(0.0, 16.0, 0.0, (double)x_min, (double)y_max);
        tess.addVertexWithUV(16.0, 16.0, 0.0, (double)x_max, (double)y_max);
        tess.addVertexWithUV(16.0, 0.0, 0.0, (double)x_max, (double)y_min);
        tess.addVertexWithUV(0.0, 0.0, 0.0, (double)x_min, (double)y_min);
        tess.draw();
        if (item.getTagCompound() == null) {
            GL11.glDisable((int)3042);
            GL11.glDisable((int)3008);
            return;
        }
        long fluidAmount = item.getTagCompound().getLong("mFluidDisplayAmount");
        if (fluidAmount > 0L && !item.getTagCompound().getBoolean("mHideStackSize")) {
            int exp;
            double shortAmount;
            String amountString = fluidAmount < 10000L ? "" + fluidAmount + "L" : ((shortAmount = (double)fluidAmount / Math.pow(1000.0, exp = (int)(Math.log(fluidAmount) / Math.log(1000.0)))) >= 100.0 ? String.format("%.0f%cL", shortAmount, Character.valueOf("kMGTPE".charAt(exp - 1))) : (shortAmount >= 10.0 ? String.format("%.1f%cL", shortAmount, Character.valueOf("kMGTPE".charAt(exp - 1))) : String.format("%.2f%cL", shortAmount, Character.valueOf("kMGTPE".charAt(exp - 1)))));
            FontRenderer fontRender = Minecraft.getMinecraft().fontRenderer;
            float smallTextScale = fontRender.getUnicodeFlag() ? 0.75f : 0.5f;
            GL11.glDisable((int)3042);
            GL11.glScalef((float)smallTextScale, (float)smallTextScale, (float)1.0f);
            fontRender.drawString(amountString, 0, (int)(16.0f / smallTextScale) - fontRender.FONT_HEIGHT + 1, 0xFFFFFF, true);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3008);
        }
    }
}

