/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.GT_MetaGenerated_Item;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.GT_RenderUtil;
import gregtech.loaders.ExtraIcons;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_MetaGenerated_Item_Renderer
implements IItemRenderer {
    public GT_MetaGenerated_Item_Renderer() {
        for (GT_MetaGenerated_Item item : GT_MetaGenerated_Item.sInstances.values()) {
            MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this);
        }
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        if (GT_Utility.isStackInvalid(aStack) || aStack.getItemDamage() < 0) {
            return false;
        }
        return aType == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON || aType == IItemRenderer.ItemRenderType.INVENTORY || aType == IItemRenderer.ItemRenderType.EQUIPPED || aType == IItemRenderer.ItemRenderType.ENTITY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        return aType == IItemRenderer.ItemRenderType.ENTITY;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        short aMetaData = (short)aStack.getItemDamage();
        if (aMetaData < 0) {
            return;
        }
        GT_MetaGenerated_Item aItem = (GT_MetaGenerated_Item)aStack.getItem();
        GL11.glEnable((int)3042);
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            if (RenderItem.renderInFrame) {
                GL11.glScalef((float)0.85f, (float)0.85f, (float)0.85f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            } else {
                GL11.glTranslated((double)-0.5, (double)-0.42, (double)0.0);
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        if (aMetaData < aItem.mOffset) {
            IIcon tIcon;
            IIconContainer aIcon = aItem.getIconContainer(aMetaData);
            IIcon tOverlay = null;
            IIcon fluidIcon = null;
            if (aIcon == null) {
                tIcon = aStack.getIconIndex();
            } else {
                tIcon = aIcon.getIcon();
                tOverlay = aIcon.getOverlayIcon();
            }
            if (tIcon == null) {
                return;
            }
            FluidStack tFluid = GT_Utility.getFluidForFilledItem(aStack, true);
            if (tOverlay != null && tFluid != null && tFluid.getFluid() != null) {
                fluidIcon = tFluid.getFluid().getIcon(tFluid);
            }
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
            GL11.glBlendFunc((int)770, (int)771);
            if (fluidIcon == null) {
                short[] tModulation = aItem.getRGBa(aStack);
                GL11.glColor3f((float)((float)tModulation[0] / 255.0f), (float)((float)tModulation[1] / 255.0f), (float)((float)tModulation[2] / 255.0f));
            }
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(tIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)tIcon.getMaxU(), (float)tIcon.getMinV(), (float)tIcon.getMinU(), (float)tIcon.getMaxV(), (int)tIcon.getIconWidth(), (int)tIcon.getIconHeight(), (float)0.0625f);
            }
            if (fluidIcon != null) {
                int tColor = tFluid.getFluid().getColor(tFluid);
                GL11.glColor3f((float)((float)(tColor >> 16 & 0xFF) / 255.0f), (float)((float)(tColor >> 8 & 0xFF) / 255.0f), (float)((float)(tColor & 0xFF) / 255.0f));
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                    GT_RenderUtil.renderItemIcon(fluidIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
                } else {
                    ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)fluidIcon.getMaxU(), (float)fluidIcon.getMinV(), (float)fluidIcon.getMinU(), (float)fluidIcon.getMaxV(), (int)fluidIcon.getIconWidth(), (int)fluidIcon.getIconHeight(), (float)0.0625f);
                }
                GL11.glDepthFunc((int)515);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            if (tOverlay != null) {
                Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
                GL11.glBlendFunc((int)770, (int)771);
                if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                    GT_RenderUtil.renderItemIcon(tOverlay, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
                } else {
                    ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)tOverlay.getMaxU(), (float)tOverlay.getMinV(), (float)tOverlay.getMinU(), (float)tOverlay.getMaxV(), (int)tOverlay.getIconWidth(), (int)tOverlay.getIconHeight(), (float)0.0625f);
                }
            }
        } else {
            long tCharge;
            Long[] tStats;
            IIcon tIcon = aItem.mIconList[aMetaData - aItem.mOffset].length > 1 ? ((tStats = aItem.mElectricStats.get(aMetaData)) != null && tStats[3] < 0L ? ((tCharge = aItem.getRealCharge(aStack)) <= 0L ? aItem.mIconList[aMetaData - aItem.mOffset][1] : (tCharge >= tStats[0] ? aItem.mIconList[aMetaData - aItem.mOffset][8] : aItem.mIconList[aMetaData - aItem.mOffset][7 - (int)Math.max(0L, Math.min(5L, (tStats[0] - tCharge) * 6L / tStats[0]))])) : aItem.mIconList[aMetaData - aItem.mOffset][0]) : aItem.mIconList[aMetaData - aItem.mOffset][0];
            ItemList largeFluidCell = GT_MetaGenerated_Item_Renderer.getLargeFluidCell(aStack);
            if (largeFluidCell != null) {
                GT_MetaGenerated_Item_Renderer.renderLargeFluidCellExtraParts(type, largeFluidCell, aStack);
            }
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
            GL11.glBlendFunc((int)770, (int)771);
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(tIcon, 16.0, 0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)tIcon.getMaxU(), (float)tIcon.getMinV(), (float)tIcon.getMinU(), (float)tIcon.getMaxV(), (int)tIcon.getIconWidth(), (int)tIcon.getIconHeight(), (float)0.0625f);
            }
        }
        GL11.glDisable((int)3042);
    }

    @Nullable
    private static ItemList getLargeFluidCell(ItemStack stack) {
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Steel, stack)) {
            return ItemList.Large_Fluid_Cell_Steel;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Aluminium, stack)) {
            return ItemList.Large_Fluid_Cell_Aluminium;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_TungstenSteel, stack)) {
            return ItemList.Large_Fluid_Cell_TungstenSteel;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_StainlessSteel, stack)) {
            return ItemList.Large_Fluid_Cell_StainlessSteel;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Titanium, stack)) {
            return ItemList.Large_Fluid_Cell_Titanium;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Chrome, stack)) {
            return ItemList.Large_Fluid_Cell_Chrome;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Iridium, stack)) {
            return ItemList.Large_Fluid_Cell_Iridium;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Osmium, stack)) {
            return ItemList.Large_Fluid_Cell_Osmium;
        }
        if (GT_MetaGenerated_Item_Renderer.isSame(ItemList.Large_Fluid_Cell_Neutronium, stack)) {
            return ItemList.Large_Fluid_Cell_Neutronium;
        }
        return null;
    }

    private static void renderLargeFluidCellExtraParts(IItemRenderer.ItemRenderType type, ItemList item, ItemStack stack) {
        IIcon inner = item == ItemList.Large_Fluid_Cell_Steel ? ExtraIcons.steelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Aluminium ? ExtraIcons.aluminiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_StainlessSteel ? ExtraIcons.stainlesssteelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Titanium ? ExtraIcons.titaniumLargeCellInner : (item == ItemList.Large_Fluid_Cell_TungstenSteel ? ExtraIcons.tungstensteelLargeCellInner : (item == ItemList.Large_Fluid_Cell_Iridium ? ExtraIcons.iridiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_Osmium ? ExtraIcons.osmiumLargeCellInner : (item == ItemList.Large_Fluid_Cell_Chrome ? ExtraIcons.chromiumLargeCellInner : ExtraIcons.neutroniumLargeCellInner)))))));
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationItemsTexture);
        if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
            GT_RenderUtil.renderItemIcon(inner, 16.0, -0.001, 0.0f, 0.0f, -1.0f);
        } else {
            ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)inner.getMaxU(), (float)inner.getMinV(), (float)inner.getMinU(), (float)inner.getMaxV(), (int)inner.getIconWidth(), (int)inner.getIconHeight(), (float)0.0625f);
        }
        FluidStack fluidStack = GT_Utility.getFluidForFilledItem(stack, true);
        if (fluidStack != null && fluidStack.getFluid() != null) {
            IIcon fluidIcon = fluidStack.getFluid().getIcon(fluidStack);
            int fluidColor = fluidStack.getFluid().getColor(fluidStack);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDepthFunc((int)514);
            GL11.glColor3ub((byte)((byte)(fluidColor >> 16)), (byte)((byte)(fluidColor >> 8)), (byte)((byte)fluidColor));
            if (type.equals((Object)IItemRenderer.ItemRenderType.INVENTORY)) {
                GT_RenderUtil.renderItemIcon(fluidIcon, 16.0, -0.001, 0.0f, 0.0f, -1.0f);
            } else {
                ItemRenderer.renderItemIn2D((Tessellator)Tessellator.instance, (float)fluidIcon.getMaxU(), (float)fluidIcon.getMinV(), (float)fluidIcon.getMinU(), (float)fluidIcon.getMaxV(), (int)fluidIcon.getIconWidth(), (int)fluidIcon.getIconHeight(), (float)0.0625f);
            }
            GL11.glColor3ub((byte)-1, (byte)-1, (byte)-1);
            GL11.glDepthFunc((int)515);
        }
    }

    private static boolean isSame(ItemList item, ItemStack stack) {
        ItemStack internal = item.getInternalStack_unsafe();
        if (GT_Utility.isStackInvalid(internal)) {
            return false;
        }
        return internal.getItem() == stack.getItem() && internal.getItemDamage() == stack.getItemDamage();
    }
}

