/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_AbstractMultiFurnace;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_MultiFurnace
extends GT_MetaTileEntity_AbstractMultiFurnace<GT_MetaTileEntity_MultiFurnace>
implements IConstructable {
    private int mLevel = 0;
    private int mCostDiscount = 1;
    private static final int CASING_INDEX = 11;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final IStructureDefinition<GT_MetaTileEntity_MultiFurnace> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccc", "cmc", "ccc"}, {"CCC", "C-C", "CCC"}, {"b~b", "bbb", "bbb"}})).addElement(Character.valueOf('c'), StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)11)).addElement(Character.valueOf('m'), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMufflerToMachineList, 11, 2)).addElement(Character.valueOf('C'), GT_StructureUtility.ofCoil(GT_MetaTileEntity_AbstractMultiFurnace::setCoilLevel, GT_MetaTileEntity_AbstractMultiFurnace::getCoilLevel)).addElement(Character.valueOf('b'), GT_StructureUtility.ofHatchAdderOptional(GT_MetaTileEntity_AbstractMultiFurnace::addBottomHatch, 11, 1, GregTech_API.sBlockCasings1, 11)).build();

    public GT_MetaTileEntity_MultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_MultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MultiFurnace(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Furnace").addInfo("Controller Block for the Multi Smelter").addInfo("Smelts up to 8-128 items at once").addInfo("Items smelted increases with coil tier").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front bottom").addCasingInfo("Heat Proof Machine Casing", 8).addOtherStructurePart("Heating Coils", "Middle layer").addEnergyHatch("Any bottom casing", 1).addMaintenanceHatch("Any bottom casing", 1).addMufflerHatch("Top Middle", 2).addInputBus("Any bottom casing", 1).addOutputBus("Any bottom casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide != aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
        }
        if (aActive) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_GLOW).extFacing().glow().build()};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiFurnace.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sFurnaceRecipes;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (tInputList.isEmpty()) {
            return false;
        }
        int mVolatage = GT_Utility.safeInt(this.getMaxInputVoltage());
        int tMaxParrallel = 8 * this.mLevel;
        int tCurrenParrallel = 0;
        ItemStack tSmeltStack = tInputList.get(0);
        ItemStack tOutputStack = GT_ModHandler.getSmeltingOutput(tSmeltStack, false, null);
        if (tOutputStack == null) {
            return false;
        }
        for (ItemStack item : tInputList) {
            if (!tSmeltStack.isItemEqual(item)) continue;
            if (item.stackSize < tMaxParrallel - tCurrenParrallel) {
                tCurrenParrallel += item.stackSize;
                item.stackSize = 0;
                continue;
            }
            item.stackSize = tCurrenParrallel + item.stackSize - tMaxParrallel;
            tCurrenParrallel = tMaxParrallel;
            break;
        }
        this.mOutputItems = new ItemStack[(tCurrenParrallel *= tOutputStack.stackSize) / 64 + 1];
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            int size;
            ItemStack tNewStack = tOutputStack.copy();
            tNewStack.stackSize = size = Math.min(tCurrenParrallel, 64);
            tCurrenParrallel -= size;
            this.mOutputItems[i] = tNewStack;
        }
        if (this.mOutputItems.length > 0) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(4, 512, 1, mVolatage);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            this.mEUt = GT_Utility.safeInt((long)this.mEUt * (long)this.mLevel / (long)this.mCostDiscount, 1);
            if (this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
        }
        this.updateSlots();
        return true;
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_MultiFurnace> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mLevel = 0;
        this.mCostDiscount = 1;
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        this.setCoilLevel(HeatingCoilLevel.None);
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 2, 0)) {
            return false;
        }
        if (this.getCoilLevel() == HeatingCoilLevel.None) {
            return false;
        }
        if (this.mMaintenanceHatches.size() != 1) {
            return false;
        }
        this.mLevel = this.getCoilLevel().getLevel();
        this.mCostDiscount = this.getCoilLevel().getCostDiscount();
        return true;
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                byte tUsedMeta;
                if (xPos == tX && zPos == tZ || (tUsedMeta = aBaseMetaTileEntity.getMetaID(xPos, tY + 1, zPos)) < 12 || tUsedMeta > 14 || aBaseMetaTileEntity.getBlock(xPos, tY + 1, zPos) != GregTech_API.sBlockCasings1) continue;
                aBaseMetaTileEntity.getWorld().setBlock(xPos, tY + 1, zPos, GregTech_API.sBlockCasings5, tUsedMeta - 12, 3);
            }
        }
    }

    @Override
    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiFurnace.isValidMetaTileEntity(tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiFurnace.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.translateToLocal((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.translateToLocal((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.translateToLocal((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.translateToLocal((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.translateToLocal((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.translateToLocal((String)"GT5U.MS.multismelting") + ": " + EnumChatFormatting.GREEN + this.mLevel * 8 + EnumChatFormatting.RESET + " Discount: (EU/t) / " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mCostDiscount) + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 2, 0);
    }
}

