/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.util;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiHelper {
    private static final RenderItem render = new RenderItem();

    public static boolean isMouseBetween(int mouseX, int mouseY, int x, int y, int width, int height) {
        int xSize = x + width;
        int ySize = y + height;
        return mouseX >= x && mouseX <= xSize && mouseY >= y && mouseY <= ySize;
    }

    public static void drawItemStack(ItemStack stack, int x, int y) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        render.renderItemAndEffectIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().getTextureManager(), stack, x, y);
        render.renderItemOverlayIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().getTextureManager(), stack, x, y);
        RenderHelper.disableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glDisable((int)2896);
    }

    public static void drawScaledItemStack(ItemStack stack, int x, int y, float scale) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        render.renderItemAndEffectIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().getTextureManager(), stack, (int)((float)x / scale), (int)((float)y / scale));
        render.renderItemOverlayIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().getTextureManager(), stack, x, y);
        RenderHelper.disableStandardItemLighting();
        GL11.glPopMatrix();
    }

    public static void drawIconWithoutColor(int x, int y, int width, int height, float zLevel) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(x + 0), (double)(y + height), (double)zLevel, 0.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, 1.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + 0), (double)zLevel, 1.0, 0.0);
        t.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)zLevel, 0.0, 0.0);
        t.draw();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawIconWithColor(int x, int y, int width, int height, float zLevel, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(x + 0), (double)(y + height), (double)zLevel, 0.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, 1.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + 0), (double)zLevel, 1.0, 0.0);
        t.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)zLevel, 0.0, 0.0);
        t.draw();
        RenderHelper.disableStandardItemLighting();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawSizedIconWithoutColor(int x, int y, int width, int height, float zLevel) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glTranslated((double)x, (double)y, (double)zLevel);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(x + 0), (double)(y + height), (double)zLevel, 0.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, 1.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + 0), (double)zLevel, 1.0, 0.0);
        t.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)zLevel, 0.0, 0.0);
        t.draw();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static void drawSizedIconWithColor(int x, int y, int width, int height, float zLevel, Color color) {
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glColor4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        GL11.glTranslated((double)x, (double)y, (double)zLevel);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glEnable((int)32826);
        GL11.glEnable((int)2929);
        Tessellator t = Tessellator.instance;
        t.startDrawingQuads();
        t.addVertexWithUV((double)(x + 0), (double)(y + height), (double)zLevel, 0.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + height), (double)zLevel, 1.0, 1.0);
        t.addVertexWithUV((double)(x + width), (double)(y + 0), (double)zLevel, 1.0, 0.0);
        t.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)zLevel, 0.0, 0.0);
        t.draw();
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
    }

    public static List<String> getTooltip(ItemStack stack) {
        Minecraft mc = Minecraft.getMinecraft();
        List list = stack.getTooltip((EntityPlayer)mc.thePlayer, mc.gameSettings.advancedItemTooltips);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.getRarity().rarityColor + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        return list;
    }
}

