/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.buttons.ButtonBack;
import amerifrance.guideapi.buttons.ButtonNext;
import amerifrance.guideapi.buttons.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiCategory;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncEntry;
import amerifrance.guideapi.wrappers.PageWrapper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiEntry
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public EntryAbstract entry;
    public List<PageWrapper> pageWrapperList = new ArrayList<PageWrapper>();
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int pageNumber;

    public GuiEntry(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.category = category;
        this.entry = entry;
        this.pageTexture = book.pageTexture;
        this.outlineTexture = book.outlineTexture;
        this.pageNumber = 0;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.pageWrapperList.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonBack = new ButtonBack(0, this.guiLeft + this.xSize / 6, this.guiTop, this);
        this.buttonList.add(this.buttonBack);
        this.buttonNext = new ButtonNext(1, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.buttonList.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(2, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.buttonList.add(this.buttonPrev);
        for (IPage page : this.entry.pageList) {
            page.onInit(this.book, this.category, this.entry, this.player, this.bookStack, this);
            this.pageWrapperList.add(new PageWrapper(this, this.book, this.category, this.entry, page, this.guiLeft, this.guiTop, this.player, this.fontRendererObj, this.bookStack));
        }
    }

    public void drawScreen(int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.pageTexture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.bookColor);
        if (this.pageNumber < this.pageWrapperList.size() && this.pageWrapperList.get(this.pageNumber).canPlayerSee()) {
            this.pageWrapperList.get(this.pageNumber).draw(mouseX, mouseY, this);
            this.pageWrapperList.get(this.pageNumber).drawExtras(mouseX, mouseY, this);
        }
        this.drawCenteredString(this.fontRendererObj, String.valueOf(this.pageNumber + 1) + "/" + String.valueOf(this.pageWrapperList.size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.fontRendererObj, this.entry.getLocalizedName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.pageNumber != 0;
        this.buttonNext.visible = this.pageNumber != this.pageWrapperList.size() - 1;
        super.drawScreen(mouseX, mouseY, renderPartialTicks);
    }

    public void mouseClicked(int mouseX, int mouseY, int typeofClick) {
        super.mouseClicked(mouseX, mouseY, typeofClick);
        for (PageWrapper wrapper : this.pageWrapperList) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                this.pageWrapperList.get((int)this.pageNumber).page.onLeftClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
            }
            if (typeofClick != 1) continue;
            this.pageWrapperList.get((int)this.pageNumber).page.onRightClicked(this.book, this.category, this.entry, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.mc.displayGuiScreen((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        if (keyCode == 14 || keyCode == this.mc.gameSettings.keyBindUseItem.getKeyCode()) {
            this.mc.displayGuiScreen((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        }
        if ((keyCode == 200 || keyCode == 205) && this.pageNumber + 1 < this.pageWrapperList.size()) {
            ++this.pageNumber;
        }
        if ((keyCode == 208 || keyCode == 203) && this.pageNumber > 0) {
            --this.pageNumber;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            this.mc.displayGuiScreen((GuiScreen)new GuiCategory(this.book, this.category, this.player, this.bookStack));
        } else if (button.id == 1 && this.pageNumber + 1 < this.pageWrapperList.size()) {
            ++this.pageNumber;
        } else if (button.id == 2 && this.pageNumber > 0) {
            --this.pageNumber;
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncEntry(this.book.categoryList.indexOf(this.category), this.category.entryList.indexOf(this.entry), this.pageNumber));
    }
}

