/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.items;

import amerifrance.guideapi.GuideAPI;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IGuideLinked;
import amerifrance.guideapi.api.base.Book;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemGuideBook
extends Item {
    public IIcon pagesIcon;
    public TIntObjectMap<IIcon> customIcons = new TIntObjectHashMap();

    public ItemGuideBook() {
        this.setCreativeTab(GuideAPI.tabGuide);
        this.setUnlocalizedName("GuideBook");
        this.setMaxStackSize(1);
        this.setHasSubtypes(true);
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.getItemDamage()) {
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            player.openGui((Object)GuideAPI.instance, stack.getItemDamage(), world, (int)player.posX, (int)player.posY, (int)player.posZ);
        }
        return stack;
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.getItemDamage() && world.getBlock(x, y, z) instanceof IGuideLinked) {
            IGuideLinked guideLinked = (IGuideLinked)world.getBlock(x, y, z);
            Book book = GuideRegistry.getBook(stack.getItemDamage());
            String entryName = guideLinked.getLinkedEntryUnlocName(world, x, y, z, player, stack);
            for (CategoryAbstract category : book.categoryList) {
                for (EntryAbstract entry : category.entryList) {
                    if (!entry.unlocEntryName.equals(entryName)) continue;
                    GuideAPI.proxy.openEntry(book, category, entry, player, stack);
                    return true;
                }
            }
        }
        return false;
    }

    public String getUnlocalizedName(ItemStack stack) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.getItemDamage()) {
            String name = String.valueOf(stack.getItemDamage());
            return this.getUnlocalizedName() + "." + name;
        }
        return super.getUnlocalizedName(stack);
    }

    public int getRenderPasses(int metadata) {
        return this.requiresMultipleRenderPasses() ? 2 : 1;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon icon = (IIcon)this.customIcons.get(stack.getItemDamage());
        if (icon == null) {
            icon = pass == 0 ? this.itemIcon : this.pagesIcon;
        }
        return icon;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.getItemDamage()) {
            return GuideRegistry.getBook(stack.getItemDamage()).getLocalizedDisplayName();
        }
        return super.getItemStackDisplayName(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.itemIcon = ir.registerIcon("guideapi:book_cover");
        this.pagesIcon = ir.registerIcon("guideapi:book_pages");
        for (int i = 0; i < GuideRegistry.getBookList().size(); ++i) {
            Book book = GuideRegistry.getBook(i);
            if (book.itemTexture == null) continue;
            this.customIcons.put(i, (Object)ir.registerIcon(book.itemTexture));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() > stack.getItemDamage() && GuideRegistry.getBook((int)stack.getItemDamage()).itemTexture == null) {
            if (pass == 0) {
                return GuideRegistry.getBook((int)stack.getItemDamage()).bookColor.getRGB();
            }
            return super.getColorFromItemStack(stack, pass);
        }
        return super.getColorFromItemStack(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs par2CreativeTabs, List list) {
        if (!GuideRegistry.isEmpty()) {
            for (Book book : GuideRegistry.getBookList()) {
                ItemStack stack = new ItemStack((Item)this, 1, GuideRegistry.getIndexOf(book));
                if (stack.stackTagCompound == null) {
                    stack.stackTagCompound = new NBTTagCompound();
                }
                stack.stackTagCompound.setBoolean("CreativeBook", book.isLostBook);
                list.add(stack);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() < stack.getItemDamage()) {
            list.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"text.book.warning"));
        }
        if (!GuideRegistry.isEmpty() && GuideRegistry.getSize() >= stack.getItemDamage() && GuideRegistry.getBook((int)stack.getItemDamage()).author != null) {
            list.add(StatCollector.translateToLocal((String)GuideRegistry.getBook((int)stack.getItemDamage()).author));
        }
        if (stack.stackTagCompound == null) {
            stack.stackTagCompound = new NBTTagCompound();
        }
        if (stack.stackTagCompound.getBoolean("CreativeBook")) {
            list.add(EnumChatFormatting.GOLD + StatCollector.translateToLocal((String)"text.book.creative"));
        }
    }
}

