/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.pages.reciperenderers;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IRecipeRenderer;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

public class BasicRecipeRenderer<T extends IRecipe>
extends IRecipeRenderer.RecipeRendererBase<T> {
    private long lastCycle = -1L;
    private int cycleIdx = 0;
    private Random rand = new Random();

    public BasicRecipeRenderer(T recipe) {
        super(recipe);
    }

    @Override
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        Minecraft mc = Minecraft.getMinecraft();
        long time = mc.theWorld.getTotalWorldTime();
        if (this.lastCycle < 0L || this.lastCycle < time - 20L) {
            if (this.lastCycle > 0L) {
                ++this.cycleIdx;
                this.cycleIdx = Math.max(0, this.cycleIdx);
            }
            this.lastCycle = mc.theWorld.getTotalWorldTime();
        }
        Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("guideapi:textures/gui/recipe_elements.png"));
        guiBase.drawTexturedModalRect(guiLeft + 42, guiTop + 53, 0, 0, 105, 65);
        guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.shaped.crafting"), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        int outputX = 90 + (guiLeft + guiBase.xSize / 7);
        int outputY = 36 + (guiTop + guiBase.xSize / 5);
        GuiHelper.drawItemStack(this.recipe.getRecipeOutput(), outputX, outputY);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, outputX, outputY, 15, 15)) {
            this.tooltips = GuiHelper.getTooltip(this.recipe.getRecipeOutput());
        }
    }

    protected int getRandomizedCycle(int index, int max) {
        this.rand.setSeed(index);
        return (index + this.rand.nextInt(max) + this.cycleIdx) % max;
    }
}

