/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util;

import amerifrance.guideapi.ConfigHandler;
import amerifrance.guideapi.api.GuideAPIItems;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.NBTBookTags;
import amerifrance.guideapi.items.ItemLostPage;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class EventHandler {
    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.entity.worldObj.isRemote && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            NBTTagCompound tag = this.getModTag(player, "guideapi");
            if (ConfigHandler.canSpawnWithBooks) {
                for (Book book : GuideRegistry.getBookList()) {
                    if (!book.spawnWithBook || tag.getBoolean("hasInitial" + book.unlocBookTitle)) continue;
                    player.inventory.addItemStackToInventory(GuideRegistry.getItemStackForBook(book));
                    player.inventoryContainer.detectAndSendChanges();
                    tag.setBoolean("hasInitial" + book.unlocBookTitle, true);
                }
            }
        }
    }

    public NBTTagCompound getModTag(EntityPlayer player, String modName) {
        NBTTagCompound modTag;
        NBTTagCompound persistTag;
        NBTTagCompound tag = player.getEntityData();
        if (tag.hasKey("PlayerPersisted")) {
            persistTag = tag.getCompoundTag("PlayerPersisted");
        } else {
            persistTag = new NBTTagCompound();
            tag.setTag("PlayerPersisted", (NBTBase)persistTag);
        }
        if (persistTag.hasKey(modName)) {
            modTag = persistTag.getCompoundTag(modName);
        } else {
            modTag = new NBTTagCompound();
            persistTag.setTag(modName, (NBTBase)modTag);
        }
        return modTag;
    }

    @SubscribeEvent
    public void onAnvil(AnvilUpdateEvent event) {
        ItemStack left = event.left;
        ItemStack right = event.right;
        if (left == null || right == null || !right.hasTagCompound()) {
            return;
        }
        if (left.getItem() == GuideAPIItems.guideBook && right.getItem() == GuideAPIItems.lostPage) {
            if (ItemLostPage.getPageCharacteristics(right) != null && left.getItemDamage() == GuideRegistry.getIndexOf((Book)ItemLostPage.getPageCharacteristics(right)[0])) {
                ItemStack output = left.copy();
                if (!output.hasTagCompound()) {
                    output.setTagCompound(new NBTTagCompound());
                }
                output.stackTagCompound.setBoolean(right.stackTagCompound.getString(NBTBookTags.KEY_TAG), true);
                event.output = output;
                event.cost = 5;
            }
        } else if (left.getItem() == GuideAPIItems.lostPage && right.getItem() == Items.paper) {
            ItemStack output = left.copy();
            output.stackSize = 2;
            event.output = output;
            event.cost = 5;
        }
    }
}

