/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.util.serialization;

import amerifrance.guideapi.GuideAPI;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.BookBuilder;
import amerifrance.guideapi.interfaces.ITypeReader;
import amerifrance.guideapi.util.serialization.TypeReaders;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import cpw.mods.fml.common.registry.GameData;
import java.awt.Color;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class BookCreator {
    private static Map<Class, ITypeReader> serializers = Maps.newHashMap();
    private static Map<String, Class<?>> idents = Maps.newHashMap();

    public static void registerJsonBooks(GsonBuilder gsonBuilder) {
        File[] files;
        File folder = new File(GuideAPI.getConfigDir().getPath() + "/books");
        folder.mkdir();
        for (File file : files = folder.listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"))) {
            GuideRegistry.registerBook(BookCreator.createBookFromJson(gsonBuilder, file));
        }
    }

    public static Book createBookFromJson(GsonBuilder gsonBuilder, File file) {
        try {
            Gson gson = gsonBuilder.setPrettyPrinting().create();
            return (Book)gson.fromJson((Reader)new FileReader(file), Book.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void createJsonFromBook(GsonBuilder gsonBuilder, Book book) {
        try {
            Gson gson = gsonBuilder.setPrettyPrinting().create();
            String reverse = gson.toJson((Object)book, Book.class);
            FileWriter fw = new FileWriter(new File(GuideAPI.getConfigDir().getPath(), book.getLocalizedDisplayName() + ".json"));
            fw.write(reverse);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerSerializer(ITypeReader<?> serializer) {
        serializers.put(serializer.getType(), serializer);
        idents.put(serializer.getType().getSimpleName(), serializer.getType());
    }

    public static void registerCustomSerializers(GsonBuilder gsonBuilder) {
        TypeReaders.init();
        gsonBuilder.registerTypeAdapter(ItemStack.class, (Object)new CustomItemStackJson());
        gsonBuilder.registerTypeAdapter(Color.class, (Object)new CustomColorJson());
        gsonBuilder.registerTypeAdapter(IPage.class, (Object)new CustomPageJson());
        gsonBuilder.registerTypeHierarchyAdapter(EntryAbstract.class, (Object)new CustomEntryJson());
        gsonBuilder.registerTypeHierarchyAdapter(CategoryAbstract.class, (Object)new CustomCategoryJson());
        gsonBuilder.registerTypeHierarchyAdapter(Book.class, (Object)new CustomBookJson());
    }

    public static class CustomBookJson
    implements JsonDeserializer<Book>,
    JsonSerializer<Book> {
        public Book deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String displayName = json.getAsJsonObject().get("unlocDisplayName").getAsString();
            String welcome = json.getAsJsonObject().get("unlocWelcomeMessage").getAsString();
            String title = json.getAsJsonObject().get("unlocBookTitle").getAsString();
            String author = json.getAsJsonObject().get("author").getAsString();
            Color color = (Color)context.deserialize(json.getAsJsonObject().get("color"), Color.class);
            boolean spawnWithBook = json.getAsJsonObject().get("spawnWithBook").getAsBoolean();
            boolean isLostBook = json.getAsJsonObject().get("isLostBook").getAsBoolean();
            int lootChance = json.getAsJsonObject().get("lootChance").getAsInt();
            String[] chestHooks = (String[])context.deserialize(json.getAsJsonObject().get("chestHooks"), new TypeToken<String[]>(){}.getType());
            List list = (List)context.deserialize(json.getAsJsonObject().get("categoryList"), new TypeToken<List<CategoryAbstract>>(){}.getType());
            BookBuilder builder = new BookBuilder();
            builder.setCategories(list);
            builder.setUnlocBookTitle(title);
            builder.setUnlocWelcomeMessage(welcome);
            builder.setUnlocDisplayName(displayName);
            builder.setAuthor(author);
            builder.setBookColor(color);
            builder.setSpawnWithBook(spawnWithBook);
            builder.setIsLostBook(isLostBook);
            builder.setLootChance(lootChance);
            builder.setChestHooks(chestHooks);
            return builder.build();
        }

        public JsonElement serialize(Book src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("unlocDisplayName", context.serialize((Object)src.unlocDisplayName));
            jsonObject.add("unlocWelcomeMessage", context.serialize((Object)src.unlocWelcomeMessage));
            jsonObject.add("unlocBookTitle", context.serialize((Object)src.unlocBookTitle));
            jsonObject.add("author", context.serialize((Object)src.author));
            jsonObject.add("color", context.serialize((Object)src.bookColor));
            jsonObject.add("spawnWithBook", context.serialize((Object)src.spawnWithBook));
            jsonObject.add("isLostBook", context.serialize((Object)src.isLostBook));
            jsonObject.add("lootChance", context.serialize((Object)src.lootChance));
            jsonObject.add("chestHooks", context.serialize((Object)src.chestHooks));
            jsonObject.add("categoryList", context.serialize(src.categoryList));
            return jsonObject;
        }
    }

    public static class CustomCategoryJson
    implements JsonDeserializer<CategoryAbstract>,
    JsonSerializer<CategoryAbstract> {
        public CategoryAbstract deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = (String)context.deserialize(json.getAsJsonObject().get("type"), String.class);
            return (CategoryAbstract)((ITypeReader)serializers.get(idents.get(name))).deserialize(json, typeOfT, context);
        }

        public JsonElement serialize(CategoryAbstract src, Type typeOfSrc, JsonSerializationContext context) {
            return ((ITypeReader)serializers.get(src.getClass())).serialize(src, typeOfSrc, context);
        }
    }

    public static class CustomEntryJson
    implements JsonDeserializer<EntryAbstract>,
    JsonSerializer<EntryAbstract> {
        public EntryAbstract deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = (String)context.deserialize(json.getAsJsonObject().get("type"), String.class);
            return (EntryAbstract)((ITypeReader)serializers.get(idents.get(name))).deserialize(json, typeOfT, context);
        }

        public JsonElement serialize(EntryAbstract src, Type typeOfSrc, JsonSerializationContext context) {
            return ((ITypeReader)serializers.get(src.getClass())).serialize(src, typeOfSrc, context);
        }
    }

    public static class CustomPageJson
    implements JsonDeserializer<IPage>,
    JsonSerializer<IPage> {
        public IPage deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = (String)context.deserialize(json.getAsJsonObject().get("type"), String.class);
            return (IPage)((ITypeReader)serializers.get(idents.get(name))).deserialize(json, typeOfT, context);
        }

        public JsonElement serialize(IPage src, Type typeOfSrc, JsonSerializationContext context) {
            return ((ITypeReader)serializers.get(src.getClass())).serialize(src, typeOfSrc, context);
        }
    }

    public static class CustomColorJson
    implements JsonDeserializer<Color>,
    JsonSerializer<Color> {
        public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int red = json.getAsJsonObject().get("red").getAsInt();
            int green = json.getAsJsonObject().get("green").getAsInt();
            int blue = json.getAsJsonObject().get("blue").getAsInt();
            int alpha = json.getAsJsonObject().get("alpha").getAsInt();
            return new Color(red, green, blue, alpha);
        }

        public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("red", (Number)src.getRed());
            jsonObject.addProperty("green", (Number)src.getGreen());
            jsonObject.addProperty("blue", (Number)src.getBlue());
            jsonObject.addProperty("alpha", (Number)src.getAlpha());
            return jsonObject;
        }
    }

    public static class CustomItemStackJson
    implements JsonDeserializer<ItemStack>,
    JsonSerializer<ItemStack> {
        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            int meta = json.getAsJsonObject().get("metadata").getAsInt();
            return new ItemStack((Item)GameData.getItemRegistry().getObject(name), 1, meta);
        }

        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", GameData.getItemRegistry().getNameForObject((Object)src.getItem()));
            jsonObject.addProperty("metadata", (Number)src.getItemDamage());
            return jsonObject;
        }
    }
}

