/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import codechicken.multipart.MultiPartRegistry;
import codechicken.multipart.TMultiPart;
import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.parts.PartOpticFiber;
import com.cout970.magneticraft.parts.electric.PartCableHigh;
import com.cout970.magneticraft.parts.electric.PartCableLow;
import com.cout970.magneticraft.parts.electric.PartCableMedium;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_Down;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_East;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_North;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_South;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_Up;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_West;
import com.cout970.magneticraft.parts.fluid.PartBrassPipe;
import com.cout970.magneticraft.parts.fluid.PartCopperPipe;
import com.cout970.magneticraft.parts.fluid.PartIronPipe;
import com.cout970.magneticraft.parts.heat.PartHeatCable;

public class ManagerMultiPart {
    public void init() {
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new CableLowFactory(), (String[])new String[]{ManagerItems.part_copper_cable_low.func_77658_a()});
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new CableMediumFactory(), (String[])new String[]{ManagerItems.part_copper_cable_medium.func_77658_a()});
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new CableHighFactory(), (String[])new String[]{ManagerItems.part_copper_cable_high.func_77658_a()});
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new CopperPipeFactory(), (String[])new String[]{ManagerItems.part_copper_pipe.func_77658_a()});
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new IronPipeFactory(), (String[])new String[]{ManagerItems.part_iron_pipe.func_77658_a()});
        MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new HeatCableFactory(), (String[])new String[]{ManagerItems.partheatcable.func_77658_a()});
        if (Magneticraft.DEBUG) {
            MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new OpticFiberFactory(), (String[])new String[]{ManagerItems.part_optic_fiber.func_77658_a()});
            MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new BrassPipeFactory(), (String[])new String[]{ManagerItems.part_brass_pipe.func_77658_a()});
        }
        for (MgDirection d : MgDirection.values()) {
            MultiPartRegistry.registerParts((MultiPartRegistry.IPartFactory)new CopperWireFactory(), (String[])new String[]{ManagerItems.part_copper_wire.func_77658_a() + "_" + d.name()});
        }
    }

    public class CopperWireFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String name, boolean arg1) {
            MgDirection dir = MgDirection.valueOf(name.replaceFirst(ManagerItems.part_copper_wire.func_77658_a() + "_", ""));
            if (dir == MgDirection.DOWN) {
                return new PartWireCopper_Down();
            }
            if (dir == MgDirection.UP) {
                return new PartWireCopper_Up();
            }
            if (dir == MgDirection.NORTH) {
                return new PartWireCopper_North();
            }
            if (dir == MgDirection.SOUTH) {
                return new PartWireCopper_South();
            }
            if (dir == MgDirection.WEST) {
                return new PartWireCopper_West();
            }
            if (dir == MgDirection.EAST) {
                return new PartWireCopper_East();
            }
            return null;
        }
    }

    public class HeatCableFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartHeatCable();
        }
    }

    public class IronPipeFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartIronPipe();
        }
    }

    public class CopperPipeFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartCopperPipe();
        }
    }

    public class CableHighFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartCableHigh();
        }
    }

    public class CableMediumFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartCableMedium();
        }
    }

    public class OpticFiberFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartOpticFiber();
        }
    }

    public class CableLowFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartCableLow();
        }
    }

    public class BrassPipeFactory
    implements MultiPartRegistry.IPartFactory {
        public TMultiPart createPart(String arg0, boolean arg1) {
            return new PartBrassPipe();
        }
    }
}

