/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.conveyor.prefab;

import com.cout970.magneticraft.api.conveyor.IConveyorBelt;
import com.cout970.magneticraft.api.conveyor.IConveyorBeltLane;
import com.cout970.magneticraft.api.conveyor.IHitBoxArray;
import com.cout970.magneticraft.api.conveyor.IItemBox;
import com.cout970.magneticraft.api.conveyor.prefab.HitBoxArray;
import com.cout970.magneticraft.api.conveyor.prefab.ItemBox;
import com.cout970.magneticraft.api.util.MgUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class ConveyorBeltLane
implements IConveyorBeltLane {
    protected IConveyorBelt parent;
    protected List<IItemBox> content = new ArrayList<IItemBox>();
    protected HitBoxArray hitBox = new HitBoxArray();
    protected boolean isLeft;

    public ConveyorBeltLane(IConveyorBelt parent, boolean isLeft) {
        this.parent = parent;
        this.isLeft = isLeft;
    }

    public void avance(IItemBox b) {
        this.setHitBoxSpace(b.getPosition(), false);
        if (this.hasHitBoxSpace(b.getPosition() + 1)) {
            b.setPosition(b.getPosition() + 1);
        }
        this.setHitBoxSpace(b.getPosition(), true);
    }

    @Override
    public void setHitBoxSpace(int pos, boolean value) {
        TileEntity tile = null;
        if (4 + pos >= this.hitBox.size()) {
            tile = ConveyorBeltLane.getFrontConveyor(this.parent);
        }
        for (int i = 0; i < 4; ++i) {
            if (i + pos >= this.hitBox.size()) {
                this.setHitBoxSpaceExtern(tile, i + pos - 16, value);
                continue;
            }
            this.hitBox.setOccupied(pos + i, value);
        }
    }

    @Override
    public void setHitBoxSpaceExtern(TileEntity tile, int pos, boolean value) {
        block8: {
            IConveyorBelt.BeltInteraction iter;
            IConveyorBelt con;
            block10: {
                block9: {
                    if (!(tile instanceof IConveyorBelt)) break block8;
                    con = (IConveyorBelt)tile;
                    iter = IConveyorBelt.BeltInteraction.InterBelt(this.parent.getDir(), con.getDir());
                    if (iter != IConveyorBelt.BeltInteraction.DIRECT) break block9;
                    con.getSideLane(this.isLeft).getHitBoxes().setOccupied(pos % 16, value);
                    break block8;
                }
                if (iter != IConveyorBelt.BeltInteraction.LEFT_T) break block10;
                if (this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        con.getSideLane(false).getHitBoxes().setOccupied(i % 16, value);
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        con.getSideLane(false).getHitBoxes().setOccupied(i % 16, value);
                    }
                }
                break block8;
            }
            if (iter != IConveyorBelt.BeltInteraction.RIGHT_T) break block8;
            if (!this.isLeft) {
                for (int i = 2; i < 6; ++i) {
                    con.getSideLane(true).getHitBoxes().setOccupied(i % 16, value);
                }
            } else {
                for (int i = 10; i < 14; ++i) {
                    con.getSideLane(true).getHitBoxes().setOccupied(i % 16, value);
                }
            }
        }
    }

    @Override
    public boolean hasHitBoxSpace(int pos) {
        TileEntity tile = null;
        if (4 + pos >= this.hitBox.size()) {
            tile = ConveyorBeltLane.getFrontConveyor(this.parent);
        }
        for (int i = 0; i < 4; ++i) {
            if (!(i + pos >= this.hitBox.size() ? !this.hasHitBoxSpaceExtern(tile, i + pos - 16) : this.hitBox.hasSpace(pos + i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasHitBoxSpaceExtern(TileEntity tile, int pos) {
        if (tile instanceof IConveyorBelt) {
            IConveyorBelt con = (IConveyorBelt)tile;
            boolean temp = false;
            IConveyorBelt.BeltInteraction iter = IConveyorBelt.BeltInteraction.InterBelt(this.parent.getDir(), con.getDir());
            if (iter == IConveyorBelt.BeltInteraction.DIRECT) {
                return !con.getSideLane(this.isLeft).getHitBoxes().hasSpace(pos % 16);
            }
            if (iter == IConveyorBelt.BeltInteraction.LEFT_T) {
                if (this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        temp |= con.getSideLane(false).getHitBoxes().hasSpace(i % 16);
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        temp |= con.getSideLane(false).getHitBoxes().hasSpace(i % 16);
                    }
                }
                return !temp;
            }
            if (iter == IConveyorBelt.BeltInteraction.RIGHT_T) {
                if (!this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        temp |= con.getSideLane(true).getHitBoxes().hasSpace(i % 16);
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        temp |= con.getSideLane(true).getHitBoxes().hasSpace(i % 16);
                    }
                }
                return !temp;
            }
        }
        return false;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        String side = this.isLeft ? "Left" : "Right";
        for (int i = 0; i < this.hitBox.size(); ++i) {
            nbt.func_74757_a(side + "_" + i, this.hitBox.hasSpace(i));
        }
        NBTTagList list = new NBTTagList();
        nbt.func_74768_a(side + "Size", this.content.size());
        for (IItemBox aContent : this.content) {
            NBTTagCompound t = new NBTTagCompound();
            if (aContent != null) {
                aContent.save(t);
            }
            list.func_74742_a((NBTBase)t);
        }
        nbt.func_74782_a(side + "_Boxes", (NBTBase)list);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        String side = this.isLeft ? "Left" : "Right";
        this.content.clear();
        for (int i = 0; i < this.hitBox.size(); ++i) {
            this.getHitBoxes().setOccupied(i, nbt.func_74767_n(side + "_" + i));
        }
        int content_size = nbt.func_74762_e(side + "Size");
        NBTTagList list = nbt.func_150295_c(side + "_Boxes", 10);
        for (int i = 0; i < content_size; ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            if (!t.func_74764_b("Left")) continue;
            ItemBox box = new ItemBox(null);
            box.load(t);
            this.content.add(box);
        }
    }

    public static TileEntity getFrontConveyor(IConveyorBelt c) {
        TileEntity t = c.getParent();
        if (c.getOrientation().getLevel() == 1) {
            return MgUtils.getTileEntity(t, c.getDir().toVecInt().add(0, 1, 0));
        }
        TileEntity retval = MgUtils.getTileEntity(t, c.getDir());
        if (!(retval instanceof IConveyorBelt)) {
            retval = MgUtils.getTileEntity(t, c.getDir().toVecInt().add(0, -1, 0));
        }
        return retval;
    }

    @Override
    public IConveyorBelt getConveyorBelt() {
        return this.parent;
    }

    @Override
    public List<IItemBox> getItemBoxes() {
        return this.content;
    }

    @Override
    public IHitBoxArray getHitBoxes() {
        return this.hitBox;
    }

    @Override
    public boolean isOnLeft() {
        return this.isLeft;
    }
}

