/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.kinetic;

import com.cout970.magneticraft.api.kinetic.IKineticConductor;
import com.cout970.magneticraft.api.kinetic.IKineticTile;
import com.cout970.magneticraft.api.kinetic.KineticNetwork;
import com.cout970.magneticraft.api.kinetic.KineticType;
import com.cout970.magneticraft.api.util.MgDirection;
import net.minecraft.tileentity.TileEntity;

public class KineticConductor
implements IKineticConductor {
    public TileEntity tile;
    public KineticType type;
    public double lose = 0.1;
    public float rotation;
    public double mass = 1.0;
    public double speed;
    public double lastSpeed;
    public long time;
    public KineticNetwork net;

    public KineticConductor(TileEntity p) {
        this.tile = p;
        this.type = KineticType.Transport;
    }

    public KineticConductor(TileEntity p, double lose, double mass) {
        this.tile = p;
        this.lose = lose;
        this.mass = mass;
        this.type = KineticType.Consumer;
    }

    public KineticConductor(TileEntity p, double lose) {
        this.tile = p;
        this.lose = lose;
        this.type = KineticType.Consumer;
    }

    @Override
    public double getLose() {
        return this.lose;
    }

    @Override
    public void iterate() {
        this.lastSpeed = this.speed;
        this.speed = 0.0;
    }

    @Override
    public KineticNetwork getNetwork() {
        return this.net;
    }

    @Override
    public void setNetwork(KineticNetwork net) {
        this.net = net;
    }

    @Override
    public TileEntity getParent() {
        return this.tile;
    }

    @Override
    public KineticType getFunction() {
        return this.type;
    }

    @Override
    public double getWork() {
        return 0.5 * this.getMass() * this.getSpeed() * this.getSpeed();
    }

    @Override
    public MgDirection[] getValidSides() {
        return ((IKineticTile)this.tile).getValidSides();
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public double getSpeed() {
        return this.lastSpeed;
    }

    @Override
    public void setSpeed(double speed) {
        this.speed += speed;
    }

    @Override
    public void setLose(double lose) {
        this.lose = lose;
    }

    @Override
    public void setMass(double mass) {
        this.mass = mass;
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float angle) {
        this.rotation = angle;
    }

    @Override
    public double getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return (double)(this.time - aux) * 1.0E-6;
    }
}

