/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.kinetic;

import com.cout970.magneticraft.api.kinetic.IKineticConductor;
import com.cout970.magneticraft.api.kinetic.IKineticController;
import com.cout970.magneticraft.api.kinetic.KineticPathFinder;
import java.util.LinkedList;
import net.minecraft.world.World;

public class KineticNetwork {
    public LinkedList<IKineticConductor> componets = new LinkedList();
    public World world;

    public KineticNetwork(IKineticConductor firts) {
        this.componets.add(firts);
        this.world = firts.getParent().func_145831_w();
    }

    public void findComponents() {
        KineticPathFinder finder = new KineticPathFinder(this.world, this.componets.getFirst());
        while (finder.iterate()) {
        }
        this.componets.clear();
        this.componets.addAll(finder.conds);
    }

    public void applyForce(double F) {
        this.setSpeed(Math.max(0.0, F / this.getMass() - this.getResistance()));
    }

    private double getMass() {
        double mass = 0.0;
        for (IKineticConductor cond : this.componets) {
            mass += cond.getMass();
        }
        return mass;
    }

    public double getResistance() {
        double resistance = 0.0;
        for (IKineticConductor cond : this.componets) {
            resistance += cond.getLose();
        }
        return resistance;
    }

    public double getSpeed() {
        if (this.componets.getLast() == null) {
            return 0.0;
        }
        return this.componets.getLast().getSpeed();
    }

    public void setSpeed(double speed) {
        for (IKineticConductor cond : this.componets) {
            cond.setSpeed(speed);
        }
    }

    public void ajustRotation(float rotation) {
        for (IKineticConductor cond : this.componets) {
            cond.setRotation(rotation);
        }
    }

    public void preventUpdates() {
        this.componets.stream().filter(cond -> cond instanceof IKineticController).forEach(cond -> ((IKineticController)cond).preventUpdate());
    }

    public void stop(IKineticConductor kinetic) {
        for (IKineticConductor cond : this.componets) {
            cond.setRotation(kinetic.getRotation());
            cond.setSpeed(0.0);
        }
    }
}

