/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.tilerender;

import codechicken.lib.vec.Vector3;
import com.cout970.magneticraft.client.model.ModelWire;
import com.cout970.magneticraft.client.model.ModelWireCorner;
import com.cout970.magneticraft.client.tilerender.ModelTextures;
import com.cout970.magneticraft.parts.electric.PartWireCopper;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_Down;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_East;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_North;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_South;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_Up;
import com.cout970.magneticraft.parts.electric.wires.PartWireCopper_West;
import com.cout970.magneticraft.util.RenderUtil;
import org.lwjgl.opengl.GL11;

public class TileRenderWireCopper {
    public ModelWire model = new ModelWire();
    public ModelWireCorner model2 = new ModelWireCorner();

    public void render(PartWireCopper p, Vector3 pos) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)pos.x, (double)pos.y, (double)pos.z);
        RenderUtil.bindTexture(ModelTextures.WIRE_COPPER_BLOCK);
        this.applyRotations(p);
        this.model.renderStatic(PartWireCopper.pixel);
        if (p.Conn != 0) {
            int source = p.Conn & p.getConMask();
            byte conn = (byte)(source & 0x3F);
            byte aux = (byte)(source >> 6 & 0x3F);
            int ext = 0;
            int fin = 0;
            byte[] rot = this.getRotation(p, conn);
            ext = (byte)(ext | 1 & aux >> rot[0]);
            ext = (byte)(ext | (1 & aux >> rot[1]) << 1);
            ext = (byte)(ext | (1 & aux >> rot[2]) << 2);
            ext = (byte)(ext | (1 & aux >> rot[3]) << 3);
            fin |= 1 & conn >> rot[0];
            fin |= (1 & conn >> rot[1]) << 1;
            fin |= (1 & conn >> rot[2]) << 2;
            this.model.renderDynamic(PartWireCopper.pixel, fin |= (1 & conn >> rot[3]) << 3);
            RenderUtil.bindTexture(ModelTextures.WIRE_COPPER_CORNER);
            this.model2.renderDynamic(PartWireCopper.pixel, ext);
        }
        GL11.glPopMatrix();
    }

    private byte[] getRotation(PartWireCopper p, int s) {
        if (p instanceof PartWireCopper_Down) {
            return new byte[]{3, 5, 2, 4};
        }
        if (p instanceof PartWireCopper_Up) {
            return new byte[]{2, 5, 3, 4};
        }
        if (p instanceof PartWireCopper_East) {
            return new byte[]{3, 1, 2, 0};
        }
        if (p instanceof PartWireCopper_West) {
            return new byte[]{3, 0, 2, 1};
        }
        if (p instanceof PartWireCopper_North) {
            return new byte[]{0, 5, 1, 4};
        }
        if (p instanceof PartWireCopper_South) {
            return new byte[]{1, 5, 0, 4};
        }
        return new byte[]{3, 5, 2, 4};
    }

    private void applyRotations(PartWireCopper p) {
        if (p instanceof PartWireCopper_Down) {
            GL11.glTranslatef((float)0.5f, (float)-1.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
            return;
        }
        if (p instanceof PartWireCopper_Up) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.5f, (float)-2.5f, (float)-0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
            return;
        }
        if (p instanceof PartWireCopper_East) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)-2.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
            return;
        }
        if (p instanceof PartWireCopper_West) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
            return;
        }
        if (p instanceof PartWireCopper_North) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.5f, (float)-1.5f, (float)-0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
            return;
        }
        if (p instanceof PartWireCopper_South) {
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.5f, (float)-2.5f, (float)0.5f);
            GL11.glTranslatef((float)0.0f, (float)(PartWireCopper.pixel * 3.0f), (float)0.0f);
        }
    }
}

