/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.items;

import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricPole;
import com.cout970.magneticraft.api.electricity.ITileElectricPole;
import com.cout970.magneticraft.api.electricity.prefab.InterPoleWire;
import com.cout970.magneticraft.api.util.NBTUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.items.ItemBasic;
import com.cout970.magneticraft.tabs.CreativeTabsMg;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemHeavyCopperCoil
extends ItemBasic {
    public ItemHeavyCopperCoil(String unlocalizedname) {
        super(unlocalizedname);
        this.func_77637_a(CreativeTabsMg.IndustrialAgeTab);
    }

    public ItemStack func_77659_a(ItemStack is, World w, EntityPlayer p) {
        if (w.field_72995_K) {
            return is;
        }
        MovingObjectPosition mop = this.func_77621_a(w, p, false);
        if (p.func_70093_af() && (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK)) {
            NBTUtils.setBoolean("Connected", is, false);
            p.func_145747_a((IChatComponent)new ChatComponentText("Connection reset."));
        }
        return super.func_77659_a(is, w, p);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_77648_a(ItemStack item, EntityPlayer p, World w, int x, int y, int z, int side, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        TileEntity t = w.func_147438_o(x, y, z);
        if (!(t instanceof ITileElectricPole)) {
            if (!p.func_70093_af()) return false;
            NBTUtils.setBoolean("Connected", item, false);
            if (w.field_72995_K) return false;
            p.func_145747_a((IChatComponent)new ChatComponentText("Connection reset."));
            return false;
        }
        IElectricPole pole1 = ElectricUtils.getElectricPole(t);
        if (pole1 == null) return false;
        if (!NBTUtils.getBoolean("Connected", item)) {
            NBTUtils.setBoolean("Connected", item, true);
            NBTUtils.setInteger("xCoord", item, pole1.getParent().field_145851_c);
            NBTUtils.setInteger("yCoord", item, pole1.getParent().field_145848_d);
            NBTUtils.setInteger("zCoord", item, pole1.getParent().field_145849_e);
            if (w.field_72995_K) return true;
            p.func_145747_a((IChatComponent)new ChatComponentText("Attached wire to the pole at " + pole1.getParent().field_145851_c + ", " + pole1.getParent().field_145848_d + ", " + pole1.getParent().field_145849_e + "."));
            return true;
        }
        TileEntity tile = w.func_147438_o(NBTUtils.getInteger("xCoord", item), NBTUtils.getInteger("yCoord", item), NBTUtils.getInteger("zCoord", item));
        IElectricPole pole2 = ElectricUtils.getElectricPole(tile);
        if (pole2 == null) return false;
        if (pole1 == pole2) {
            if (w.field_72995_K) return false;
            p.func_145747_a((IChatComponent)new ChatComponentText("You cannot attach a wire to the same pole."));
            return false;
        }
        if (pole1.canConnectWire(pole2.getTier(), pole2, true) && pole2.canConnectWire(pole1.getTier(), pole1, true)) {
            InterPoleWire wire = new InterPoleWire(new VecInt(pole1.getParent()), new VecInt(pole2.getParent()));
            wire.setWorld(pole1.getParent().func_145831_w());
            if (wire.getDistance() <= 16.0) {
                pole1.onConnect(wire);
                pole2.onConnect(wire);
                NBTUtils.setBoolean("Connected", item, false);
                if (w.field_72995_K) return true;
                p.func_145747_a((IChatComponent)new ChatComponentText("Wire attached successfully."));
                return true;
            }
            if (w.field_72995_K) return false;
            p.func_145747_a((IChatComponent)new ChatComponentText("Distance between poles is too high."));
            return false;
        }
        if (w.field_72995_K) return false;
        p.func_145747_a((IChatComponent)new ChatComponentText("Poles could not be connected."));
        return false;
    }
}

