/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.FakePlayerProvider;
import com.cout970.magneticraft.util.tile.TileHeatConductor;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;

public class TileGeothermalPump
extends TileHeatConductor
implements IGuiSync {
    public int buffer;
    private List<VecInt> pipes = new LinkedList<VecInt>();
    private List<VecInt> lava = new LinkedList<VecInt>();
    private List<VecInt> finder = new LinkedList<VecInt>();
    private List<VecInt> visited = new LinkedList<VecInt>();
    private int alt;
    private boolean update;
    private boolean working;
    private int cooldown;
    private boolean blocked;
    private MgDirection[] sides = new MgDirection[]{MgDirection.NORTH, MgDirection.EAST, MgDirection.SOUTH, MgDirection.WEST, MgDirection.DOWN, MgDirection.UP};

    @Override
    public IHeatConductor initHeatCond() {
        return new HeatConductor(this, 1600.0, 1000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (!this.update) {
            if (this.field_145850_b.func_82737_E() % 40L == 0L) {
                this.update = this.searchForLava();
            }
        } else if (!this.blocked) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.cooldown <= 0) {
                this.cooldown = 20;
                if (this.pipes.size() == 0) {
                    this.getLava();
                    this.blocked = true;
                } else {
                    VecInt c = this.pipes.get(0);
                    this.field_145850_b.func_147449_b(c.getX(), c.getY(), c.getZ(), ManagerBlocks.concreted_pipe);
                    this.pipes.remove(0);
                }
            }
        } else if (this.isControlled()) {
            if (this.heat.getTemperature() < 1200.0 && this.buffer > 0) {
                int i = Math.min(12, this.buffer);
                this.heat.applyCalories(EnergyConverter.FUELtoCALORIES(i));
                this.buffer -= i;
                this.working = true;
            } else {
                this.working = false;
            }
            if (this.buffer <= 0) {
                if (this.lava.size() == 0) {
                    this.update = false;
                    this.blocked = false;
                    this.working = false;
                } else {
                    VecInt b = this.lava.get(0);
                    Block bl = this.field_145850_b.func_147439_a(b.getX(), b.getY(), b.getZ());
                    if (Block.func_149680_a((Block)bl, (Block)Blocks.field_150353_l)) {
                        this.field_145850_b.func_147449_b(b.getX(), b.getY(), b.getZ(), Blocks.field_150343_Z);
                        this.buffer = 20000;
                        this.working = true;
                    }
                    this.lava.remove(0);
                }
            }
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    private void setActive(boolean b) {
        int m = this.func_145832_p();
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, m % 6 + 6, 3);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, m % 6, 3);
        }
    }

    private void getLava() {
        this.lava.clear();
        VecInt bc = new VecInt(this.field_145851_c, this.alt, this.field_145849_e);
        Block b = this.field_145850_b.func_147439_a(bc.getX(), bc.getY(), bc.getZ());
        int m = this.field_145850_b.func_72805_g(bc.getX(), bc.getY(), bc.getZ());
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150353_l)) {
            if (m == 0) {
                this.lava.add(bc);
            }
            if (!this.finder.contains(bc)) {
                this.finder.add(bc);
            }
        }
        if (Block.func_149680_a((Block)b, (Block)Blocks.field_150343_Z) && !this.finder.contains(bc)) {
            this.finder.add(bc);
        }
        this.pathFinder(bc);
        this.visited.clear();
        this.finder.clear();
    }

    public void pathFinder(VecInt c) {
        if (this.lava.size() > 20) {
            return;
        }
        if (this.visited.size() > 4000) {
            --this.alt;
            return;
        }
        for (MgDirection d : this.sides) {
            VecInt bc = new VecInt(c.getX() + d.getOffsetX(), c.getY() + d.getOffsetY(), c.getZ() + d.getOffsetZ());
            if (this.visited.contains(bc)) continue;
            this.visited.add(bc);
            Block b = this.field_145850_b.func_147439_a(bc.getX(), bc.getY(), bc.getZ());
            int m = this.field_145850_b.func_72805_g(bc.getX(), bc.getY(), bc.getZ());
            if (Block.func_149680_a((Block)b, (Block)Blocks.field_150353_l)) {
                if (m == 0) {
                    this.lava.add(bc);
                }
                if (!this.finder.contains(bc)) {
                    this.finder.add(bc);
                }
            }
            if (!Block.func_149680_a((Block)b, (Block)Blocks.field_150343_Z) || this.finder.contains(bc)) continue;
            this.finder.add(bc);
        }
        ArrayList<VecInt> temp = new ArrayList<VecInt>();
        temp.addAll(this.finder);
        for (VecInt cc : temp) {
            this.finder.remove(cc);
            this.pathFinder(cc);
        }
    }

    public boolean searchForLava() {
        this.pipes.clear();
        for (int y = this.field_145848_d - 1; y > 0; --y) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, y, this.field_145849_e);
            if (!this.field_145850_b.func_72962_a((EntityPlayer)FakePlayerProvider.getFakePlayer((WorldServer)this.field_145850_b), this.field_145851_c, y, this.field_145849_e)) {
                return false;
            }
            if (Block.func_149680_a((Block)b, (Block)Blocks.field_150343_Z) || Block.func_149680_a((Block)b, (Block)Blocks.field_150353_l)) {
                this.alt = y;
                this.getLava();
                if (this.lava.isEmpty()) {
                    this.alt = 0;
                    continue;
                }
                return true;
            }
            if (Block.func_149680_a((Block)b, (Block)ManagerBlocks.concreted_pipe)) continue;
            this.pipes.add(new VecInt(this.field_145851_c, y, this.field_145849_e));
        }
        return false;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.heat.getTemperature());
        craft.func_71112_a(cont, 1, this.buffer);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.heat.setTemperature(value);
        }
        if (id == 1) {
            this.buffer = value;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.buffer = nbt.func_74762_e("Buffer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Buffer", this.buffer);
    }
}

