/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import cofh.api.energy.IEnergyHandler;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileRFAlternator
extends TileConductorLow
implements IEnergyHandler {
    public int storage = 0;
    public int maxStorage = 32000;
    public double min = 100.0;

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this){

            @Override
            public void iterate() {
                super.iterate();
                if (!TileRFAlternator.this.isControlled()) {
                    return;
                }
                if (this.getVoltage() < TileRFAlternator.this.min && TileRFAlternator.this.storage > 0) {
                    int change = (int)Math.min((TileRFAlternator.this.min - this.getVoltage()) * 80.0, 400.0);
                    change = Math.min(change, TileRFAlternator.this.storage);
                    this.applyPower(EnergyConverter.RFtoW(change));
                    TileRFAlternator.this.storage -= change;
                }
            }

            @Override
            public int getStorage() {
                return TileRFAlternator.this.storage;
            }

            @Override
            public int getMaxStorage() {
                return TileRFAlternator.this.maxStorage;
            }

            @Override
            public void setStorage(int charge) {
                TileRFAlternator.this.storage = charge;
            }

            @Override
            public void applyCharge(int charge) {
                TileRFAlternator.this.storage += charge;
                if (TileRFAlternator.this.storage > TileRFAlternator.this.maxStorage) {
                    TileRFAlternator.this.storage = TileRFAlternator.this.maxStorage;
                }
            }

            @Override
            public void drainCharge(int charge) {
                TileRFAlternator.this.storage -= charge;
                if (TileRFAlternator.this.storage < 0) {
                    TileRFAlternator.this.storage = 0;
                }
            }

            @Override
            public void save(NBTTagCompound nbt) {
                super.save(nbt);
                nbt.func_74768_a("Storage", TileRFAlternator.this.storage);
            }

            @Override
            public void load(NBTTagCompound nbt) {
                super.load(nbt);
                TileRFAlternator.this.storage = nbt.func_74762_e("Storage");
            }

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileRFAlternator.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public boolean isAbleToConnect(IConnectable c, VecInt d) {
                return TileRFAlternator.this.getDirection().opposite().toVecInt().equals(d);
            }
        };
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getDirection().toForgeDir() == from;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        int accepted = Math.max(Math.min(maxReceive, this.maxStorage - this.storage), 0);
        if (!simulate) {
            this.storage += accepted;
        }
        return accepted;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.maxStorage;
    }
}

