/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.prefab.HeatConductor;
import com.cout970.magneticraft.api.radiation.IRadiactiveItem;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.IReactorComponent;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.tile.TileHeatConductor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileReactorVessel
extends TileHeatConductor
implements IInventoryManaged,
IGuiSync,
IBarProvider,
IReactorComponent {
    private static final double AVOGADROS_CONSTANT = 6.022E23;
    public InventoryComponent inv = new InventoryComponent(this, 1, "ReactorVessel");
    private double neutrons;
    private double production;

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public String getName() {
        return "Reactor Vessel";
    }

    @Override
    public IHeatConductor initHeatCond() {
        return new HeatConductor(this, 2000.0, 1000.0);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.production = 0.0;
        double desintegration = 0.0;
        ItemStack g = this.inv.func_70301_a(0);
        if (g != null && g.func_77973_b() instanceof IRadiactiveItem) {
            IRadiactiveItem item = (IRadiactiveItem)g.func_77973_b();
            double initialMass = item.getGrams(g);
            double NewMass = initialMass * Math.exp(-item.getDecayConstant(g) * 5.0E11);
            item.setGrams(g, NewMass);
            double prod = (initialMass - NewMass) * 6.022E23 * item.getEnergyPerFision(g);
            g.func_77964_b(g.func_77973_b().getDamage(g));
            this.heat.applyCalories(EnergyConverter.RFtoCALORIES(prod *= 1.0E-10));
            this.production += EnergyConverter.RFtoCALORIES(prod);
        }
        this.neutrons = 0.0;
        this.addRadiation(desintegration);
    }

    public void addRadiation(double d) {
        this.neutrons += d;
    }

    public void setRadiation(double rad) {
        this.neutrons = rad;
    }

    public double getRadiation() {
        return this.neutrons;
    }

    public double getSpeed() {
        return 1.0E-12;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting c) {
        c.func_71112_a(cont, 0, (int)this.heat.getTemperature());
        c.func_71112_a(cont, 1, (int)this.production);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.heat.setTemperature(value);
        }
        if (id == 1) {
            this.production = value;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
        this.neutrons = nbt.func_74769_h("Neutrons");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
        nbt.func_74780_a("Neutrons", this.neutrons);
    }

    @Override
    public String getMessage() {
        return "Calories generated: " + this.production + "cal/t";
    }

    @Override
    public float getLevel() {
        return (float)Math.min(Math.sqrt(this.production) * 0.01, 1.0);
    }

    @Override
    public int getType() {
        return 1;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @Override
    public float getMaxLevel() {
        return 0.0f;
    }
}

