/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.BufferedConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.client.gui.component.IEnergyTracker;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class TileSteamEngine
extends TileConductorLow
implements IFluidHandler1_8,
IGuiSync {
    public static final int STEAM_LIMIT = 40;
    public float animation;
    private long time;
    public TankMg tank = new TankMg(this, 6000);
    private boolean working;
    public int steamConsumition;
    public int electricProduction;
    public float steamConsumitionM;
    public float electricProductionM;

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return (float)((double)(this.time - aux) * 1.0E-6);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.steamConsumitionM = this.steamConsumition;
            this.electricProductionM = this.electricProduction;
            this.steamConsumition = 0;
            this.electricProduction = 0;
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.tank.getFluidAmount() > 0 && this.cond.getVoltage() <= 100.0 && this.isControlled()) {
            int steam = Math.min(this.tank.getFluidAmount(), 40);
            if (steam > 0) {
                this.tank.drain(steam, true);
                this.cond.applyPower(EnergyConverter.STEAMtoW(steam));
                this.electricProduction = (int)((double)this.electricProduction + EnergyConverter.STEAMtoW(steam));
                this.steamConsumition += steam;
                this.working = true;
            } else {
                this.working = false;
            }
        } else {
            this.working = false;
        }
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() - 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && FluidRegistry.getFluid((String)"steam") == resource.getFluid()) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return fluid != null && FluidRegistry.getFluid((String)"steam") == fluid;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public IElectricConductor initConductor() {
        return new BufferedConductor(this, 0.01, 80000, 66.66666666666667, 75.0);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage() & 0xFFFF);
        craft.func_71112_a(cont, 2, (this.cond.getStorage() & 0xFFFF0000) >>> 16);
        craft.func_71112_a(cont, 3, this.tank.getFluidAmount());
        craft.func_71112_a(cont, 4, (int)this.steamConsumitionM);
        craft.func_71112_a(cont, 5, (int)this.electricProductionM);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.cond.setStorage(value & 0xFFFF);
        }
        if (id == 2) {
            this.cond.setStorage(this.cond.getStorage() | value << 16);
        }
        if (id == 3) {
            this.tank.setFluid(FluidRegistry.getFluidStack((String)"steam", (int)value));
        }
        if (id == 4) {
            this.steamConsumitionM = value;
        }
        if (id == 5) {
            this.electricProductionM = value;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public IEnergyTracker getEnergyTracker() {
        return new IEnergyTracker(){

            @Override
            public boolean isConsume() {
                return false;
            }

            @Override
            public float getMaxChange() {
                return (float)EnergyConverter.STEAMtoW(40.0);
            }

            @Override
            public float getChangeInTheLastTick() {
                return 0.0f;
            }

            @Override
            public float getChangeInTheLastSecond() {
                return TileSteamEngine.this.electricProductionM;
            }
        };
    }
}

