/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.multiblock.controllers;

import com.cout970.magneticraft.api.access.RecipePolymerizer;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.TileCopperTank;
import com.cout970.magneticraft.tileentity.TileHeater;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Base;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.fluid.TankMg;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TilePolymerizer
extends TileMB_Base
implements IInventoryManaged,
ISidedInventory,
IGuiSync {
    public int progress;
    public int maxProgress = 200;
    public InventoryComponent inv = new InventoryComponent(this, 2, "Polymerizer");
    public TankMg input;
    public IHeatConductor heater;
    public InventoryComponent in;
    public InventoryComponent out;
    public int drawCounter;

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.input == null || this.in == null || this.out == null || this.heater == null || this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.searchTanks();
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isControlled() && this.canCraft()) {
            if (this.progress >= this.maxProgress) {
                this.craft();
                this.progress = 0;
            } else {
                ++this.progress;
            }
            this.heater.drainCalories(EnergyConverter.RFtoCALORIES(40.0));
        } else {
            this.progress = 0;
        }
        this.distributeItems();
    }

    private void distributeItems() {
        int s;
        if (this.in != null && ((TileBase)this.in.tile).isControlled()) {
            if (this.getInv().func_70301_a(0) != null) {
                s = InventoryUtils.findCombination(this.in, this.getInv().func_70301_a(0));
                if (s != -1) {
                    InventoryUtils.traspass(this.in, this, s, 0);
                }
            } else {
                this.func_70299_a(0, InventoryUtils.getItemStack(this.in));
            }
        }
        if (this.out != null && ((TileBase)this.out.tile).isControlled() && this.getInv().func_70301_a(1) != null && (s = InventoryUtils.getSlotForStack(this.out, this.getInv().func_70301_a(1))) != -1) {
            InventoryUtils.traspass(this, this.out, 1, s);
        }
    }

    private void craft() {
        RecipePolymerizer recipe = RecipePolymerizer.getRecipe(this.getInv().func_70301_a(0));
        this.func_70298_a(0, 1);
        if (this.getInv().func_70301_a(1) == null) {
            this.getInv().func_70299_a(1, recipe.getOutput().func_77946_l());
        } else {
            ItemStack i = this.getInv().func_70301_a(1);
            i.field_77994_a += recipe.getOutput().field_77994_a;
            this.getInv().func_70299_a(1, i);
        }
        this.heater.drainCalories(EnergyConverter.RFtoCALORIES(100.0));
        this.input.drain(500, true);
    }

    private boolean canCraft() {
        RecipePolymerizer recipe = RecipePolymerizer.getRecipe(this.getInv().func_70301_a(0));
        if (recipe == null) {
            return false;
        }
        if (!MgUtils.areEqual(recipe.getFluid(), this.input.getFluid())) {
            return false;
        }
        if (this.input.getFluidAmount() < recipe.getFluid().amount) {
            return false;
        }
        if (this.heater.getTemperature() < recipe.getTemperature()) {
            return false;
        }
        ItemStack output = this.getInv().func_70301_a(1);
        return output == null || MgUtils.areEqual(output, recipe.getOutput(), true) && output.field_77994_a + recipe.getOutput().field_77994_a <= this.func_70297_j_();
    }

    private void searchTanks() {
        IHeatConductor[] comp;
        MgDirection d = MgDirection.getDirection(this.func_145832_p() % 6).opposite();
        VecInt vec = d.toVecInt();
        TileEntity tile = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(4));
        if (tile instanceof TileCopperTank) {
            this.input = ((TileCopperTank)tile).getTank();
        }
        if ((tile = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(d.step(MgDirection.DOWN).toVecInt().getOpposite()))) instanceof IInventoryManaged) {
            this.in = ((IInventoryManaged)tile).getInv();
        }
        if ((tile = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(d.step(MgDirection.UP).toVecInt().getOpposite()))) instanceof IInventoryManaged) {
            this.out = ((IInventoryManaged)tile).getInv();
        }
        if ((tile = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(3))) instanceof TileHeater && (comp = ((TileHeater)tile).getHeatCond(vec.getOpposite())) != null) {
            this.heater = comp[0];
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        if (this.input == null || this.heater == null) {
            return;
        }
        craft.func_71112_a(cont, 0, (int)this.heater.getTemperature());
        if (this.input.getFluidAmount() > 0) {
            craft.func_71112_a(cont, 1, this.input.getFluid().getFluidID());
            craft.func_71112_a(cont, 2, this.input.getFluidAmount());
        } else {
            craft.func_71112_a(cont, 1, -1);
        }
        craft.func_71112_a(cont, 3, this.progress);
        ((TileHeater)this.heater.getParent()).sendGUINetworkData(cont, craft);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (this.input == null || this.heater == null) {
            return;
        }
        if (id == 0) {
            this.heater.setTemperature(value);
        }
        if (id == 1) {
            if (value == -1) {
                this.input.setFluid(null);
            } else {
                this.input.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
        if (id == 2) {
            this.input.getFluid().amount = value;
        }
        if (id == 3) {
            this.progress = value;
        }
        ((TileHeater)this.heater.getParent()).getGUINetworkData(id, value);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v1 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), -1, -1, 0);
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), 1, 1, 4);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(v1.add(block), v2.add(block));
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    public IBarProvider getProgressBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return TilePolymerizer.this.maxProgress;
            }

            @Override
            public float getLevel() {
                return TilePolymerizer.this.progress;
            }
        };
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }
}

