/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import com.cout970.magneticraft.util.InventoryComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class InventoryResizable
extends InventoryComponent {
    private int maxSlots;
    private int curSlots;

    public InventoryResizable(TileEntity t, int slots, String n) {
        super(t, slots, n);
        this.curSlots = this.maxSlots = slots;
    }

    public int getCurSlots() {
        return this.curSlots;
    }

    public void unlock() {
        this.func_70296_d();
        this.curSlots = this.maxSlots;
    }

    public void lock() {
        this.func_70296_d();
        for (ItemStack is : this.inventory) {
            if (is == null) continue;
            return;
        }
        this.curSlots = 0;
    }

    public boolean resize(int delta) {
        this.func_70296_d();
        int newSlots = this.curSlots + delta;
        if (newSlots < 0 || newSlots > this.maxSlots) {
            return false;
        }
        if (delta < 0) {
            for (int i = newSlots; i < this.curSlots; ++i) {
                if (this.inventory[i] == null) continue;
                return false;
            }
        }
        this.curSlots = newSlots;
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack is) {
        return slot < this.curSlots && super.func_94041_b(slot, is);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String name) {
        super.readFromNBT(nbt, name);
        this.curSlots = nbt.func_74762_e(name + "curSlots");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String name) {
        super.writeToNBT(nbt, name);
        nbt.func_74768_a(name + "curSlots", this.curSlots);
    }
}

